/*
 * Decompiled with CFR 0.152.
 */
package netmatch.wizard;

import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import netmatch.multipleAttrChoice;
import netmatch.netMatchFrame;
import org.jdesktop.layout.GroupLayout;

public class WizardPanel2
extends JPanel
implements ActionListener {
    private JComboBox edgeAttrCombo;
    private JComboBox nodeAttrCombo;
    private netMatchFrame frame;

    public WizardPanel2(netMatchFrame frame) {
        this.frame = frame;
        this.initComponents();
        this.acquireAttr();
    }

    public void acquireAttr() {
        int i;
        this.nodeAttrCombo.removeActionListener(this);
        this.edgeAttrCombo.removeActionListener(this);
        this.nodeAttrCombo.removeAllItems();
        this.edgeAttrCombo.removeAllItems();
        CyAttributes nodesAttributes = Cytoscape.getNodeAttributes();
        CyAttributes edgesAttributes = Cytoscape.getEdgeAttributes();
        String[] attrs = edgesAttributes.getAttributeNames();
        for (i = 0; i < attrs.length; ++i) {
            this.edgeAttrCombo.addItem(attrs[i]);
        }
        this.edgeAttrCombo.addItem("Select a List of Attributes...");
        attrs = nodesAttributes.getAttributeNames();
        this.nodeAttrCombo.addItem("Use node ID's as Attributes");
        for (i = 0; i < attrs.length; ++i) {
            this.nodeAttrCombo.addItem(attrs[i]);
        }
        this.nodeAttrCombo.addItem("Select a List of Attributes...");
        this.nodeAttrCombo.addActionListener(this);
        this.edgeAttrCombo.addActionListener(this);
    }

    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.nodeAttrCombo) {
            if (((JComboBox)o).getSelectedItem().toString().equals("Select a List of Attributes...") || ((JComboBox)o).getSelectedItem().toString().equals("List of Attributes (select to change)...")) {
                multipleAttrChoice m = new multipleAttrChoice(this.frame, "*Multiple Node Attributes", (JComboBox)o, true);
                m.setVisible(true);
            } else {
                ArrayList<Object> l = new ArrayList<Object>();
                l.add(this.nodeAttrCombo.getSelectedItem());
                this.frame.setAttrList(l, true);
            }
        } else if (o == this.edgeAttrCombo) {
            if (((JComboBox)o).getSelectedItem().toString().equals("Select a List of Attributes...") || ((JComboBox)o).getSelectedItem().toString().equals("List of Attributes (select to change)...")) {
                multipleAttrChoice m = new multipleAttrChoice(this.frame, "*Multiple Edge Attributes", (JComboBox)o, false);
                m.setVisible(true);
            } else {
                ArrayList<Object> l = new ArrayList<Object>();
                l.add(this.edgeAttrCombo.getSelectedItem());
                this.frame.setAttrList(l, false);
            }
        }
    }

    public void setAttrList(ArrayList attrs, boolean isNodeAttr) {
        JComboBox c = isNodeAttr ? this.nodeAttrCombo : this.edgeAttrCombo;
        c.removeActionListener(this);
        if (attrs == null) {
            c.removeItem("Select a List of Attributes...");
            c.removeItem("List of Attributes (select to change)...");
            c.addItem("Select a List of Attributes...");
            c.setSelectedIndex(0);
        } else {
            c.removeItem("Select a List of Attributes...");
            c.removeItem("List of Attributes (select to change)...");
            c.addItem("List of Attributes (select to change)...");
            c.setSelectedItem("List of Attributes (select to change)...");
        }
        c.addActionListener(this);
    }

    public boolean validateAndSave() {
        return true;
    }

    private void initComponents() {
        JLabel jLabel1 = new JLabel();
        JLabel jLabel2 = new JLabel();
        this.nodeAttrCombo = new JComboBox();
        JLabel jLabel3 = new JLabel();
        this.edgeAttrCombo = new JComboBox();
        jLabel1.setFont(new Font("Tahoma", 1, 11));
        jLabel1.setText("Please select the attributes from following list: ");
        jLabel2.setText("Node attributes:");
        this.nodeAttrCombo.setModel(new DefaultComboBoxModel());
        jLabel3.setText("Edge attributes:");
        this.edgeAttrCombo.setModel(new DefaultComboBoxModel());
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(18, 18, 18).add(layout.createParallelGroup(1, false).add(jLabel3).add(jLabel2).add(jLabel1).add(this.nodeAttrCombo, 0, 321, Short.MAX_VALUE).add(this.edgeAttrCombo, 0, -1, Short.MAX_VALUE)).addContainerGap(61, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(jLabel1).add(16, 16, 16).add(jLabel2).addPreferredGap(0).add(this.nodeAttrCombo, -2, -1, -2).add(15, 15, 15).add(jLabel3).addPreferredGap(0).add(this.edgeAttrCombo, -2, -1, -2).addContainerGap(124, Short.MAX_VALUE)));
    }

    public String getNodeValue() {
        return (String)this.nodeAttrCombo.getSelectedItem();
    }

    public String getEdgeValue() {
        return (String)this.edgeAttrCombo.getSelectedItem();
    }
}

