/*
 * Decompiled with CFR 0.152.
 */
package netmatch.algorithm;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import netmatch.algorithm.Graph;
import netmatch.algorithm.VF2MonoState;
import netmatch.algorithm.myInteger;
import netmatch.algorithm.netMatch;

public class myMatch {
    private JFrame frame;
    private Graph g1;
    private Graph g2;
    private netMatch instance;

    public myMatch(netMatch instance, JFrame frame) {
        this.frame = frame;
        this.instance = instance;
        this.g1 = null;
        this.g2 = null;
    }

    public myInteger match(VF2MonoState s, BufferedWriter out) {
        this.g1 = s.GetGraph1();
        this.g2 = s.GetGraph2();
        int n = this.g1.NodeCount() < this.g2.NodeCount() ? this.g2.NodeCount() : this.g1.NodeCount();
        int[] c1 = new int[n];
        int[] c2 = new int[n];
        myInteger count = new myInteger(0);
        this.match(c1, c2, out, s, count);
        return count;
    }

    public myInteger match(VF2MonoState s, ArrayList out, ArrayList source) {
        this.g1 = s.GetGraph1();
        this.g2 = s.GetGraph2();
        int n = this.g1.NodeCount() < this.g2.NodeCount() ? this.g2.NodeCount() : this.g1.NodeCount();
        int[] c1 = new int[n];
        int[] c2 = new int[n];
        myInteger count = new myInteger(0);
        this.match(c1, c2, out, source, s, count);
        return count;
    }

    private boolean match(int[] c1, int[] c2, BufferedWriter out, VF2MonoState s, myInteger pcount) {
        if (s.IsGoal()) {
            pcount.setValue(pcount.intValue() + 1);
            int n = s.CoreLen();
            s.GetCoreSet(c1, c2);
            return this.vis(n, c1, c2, out);
        }
        if (s.IsDead()) {
            return false;
        }
        myInteger n1 = new myInteger(65535);
        myInteger n2 = new myInteger(65535);
        try {
            while (s.NextPair(n1, n2, n1.intValue(), n2.intValue())) {
                if (!s.IsFeasiblePair(n1.intValue(), n2.intValue())) continue;
                VF2MonoState s1 = s.Clone();
                s1.AddPair(n1.intValue(), n2.intValue());
                if (this.match(c1, c2, out, s1, pcount)) {
                    s1.BackTrack();
                    s1 = null;
                    return true;
                }
                s1.BackTrack();
                s1 = null;
            }
        }
        catch (Exception e) {
            if (this.frame != null) {
                JOptionPane.showMessageDialog(this.frame, "Error in Matching!", "NetMatch Error", 0);
            } else {
                System.err.println("NetMatch Error in Matching!");
            }
            return false;
        }
        return false;
    }

    private boolean match(int[] c1, int[] c2, ArrayList out, ArrayList source, VF2MonoState s, myInteger pcount) {
        if (s.IsGoal()) {
            pcount.setValue(pcount.intValue() + 1);
            int n = s.CoreLen();
            s.GetCoreSet(c1, c2);
            return this.vis(n, c1, c2, out, source);
        }
        if (s.IsDead()) {
            return false;
        }
        myInteger n1 = new myInteger(65535);
        myInteger n2 = new myInteger(65535);
        try {
            while (s.NextPair(n1, n2, n1.intValue(), n2.intValue())) {
                if (this.instance.checkTask()) {
                    return false;
                }
                if (!s.IsFeasiblePair(n1.intValue(), n2.intValue())) continue;
                VF2MonoState s1 = s.Clone();
                s1.AddPair(n1.intValue(), n2.intValue());
                if (this.match(c1, c2, out, source, s1, pcount)) {
                    s1.BackTrack();
                    s1 = null;
                    return true;
                }
                s1.BackTrack();
                s1 = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            if (this.frame != null) {
                JOptionPane.showMessageDialog(this.frame, "Error in Matching! Check network and query attributes!", "NetMatch Error", 0);
            } else {
                System.err.println("NetMatch Error in Matching!");
            }
            return false;
        }
        return false;
    }

    private boolean vis(int n, int[] ni1, int[] ni2, BufferedWriter out) {
        try {
            System.out.println();
            for (int i = 0; i < n; ++i) {
                System.out.print("(" + ni1[i] + ", " + ni2[i] + ')');
                out.write("(" + ni1[i] + ", " + ni2[i] + ')');
            }
            System.out.println();
            out.write("\r\n");
        }
        catch (IOException e) {
            System.err.println("IO Exception in myMatch: " + e.toString());
        }
        return false;
    }

    private boolean vis(int n, int[] ni1, int[] ni2, ArrayList array, ArrayList source) {
        try {
            int[] tmp1 = new int[n];
            int[] tmp2 = new int[n];
            for (int i = 0; i < n; ++i) {
                tmp1[i] = this.g1.getCyNetworkID(ni1[i]);
                tmp2[i] = this.g2.getCyNetworkID(ni2[i]);
            }
            array.add(tmp2);
            source.add(tmp1);
        }
        catch (Exception e) {
            if (this.frame != null) {
                JOptionPane.showMessageDialog(this.frame, "NetMatch Error. Unable to write matching!", "NetMatch Error", 0);
            }
            System.err.println("NetMatch Error. Unable to write Mathcing!");
        }
        return false;
    }
}

