/*
 * Decompiled with CFR 0.152.
 */
package netmatch.qtool;

import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import netmatch.qtool.Network;
import netmatch.qtool.QEdge;
import netmatch.qtool.QElement;
import netmatch.qtool.QNode;
import netmatch.qtool.QText;
import netmatch.qtool.QToolFrame;

public class QCreateStructure
extends PBasicInputEventHandler {
    private QToolFrame frame;
    private int structureType;

    public QCreateStructure(QToolFrame frame) {
        this.frame = frame;
        this.structureType = 0;
    }

    private void showPopup(PInputEvent event) {
        QElement popupElement;
        Point2D pos = event.getPosition();
        int x = (int)pos.getX();
        int y = (int)pos.getY();
        if (event.getPickedNode() instanceof QText) {
            popupElement = ((QText)event.getPickedNode()).getOwner();
        } else {
            if (!(event.getPickedNode() instanceof QElement)) {
                return;
            }
            popupElement = (QElement)event.getPickedNode();
        }
        this.frame.popup.show((Component)event.getComponent(), x, y, popupElement);
    }

    /*
     * WARNING - void declaration
     */
    private void showInfo(PInputEvent event) {
        void var2_2;
        QElement elem;
        if (event.getPickedNode() instanceof QText) {
            elem = ((QText)event.getPickedNode()).getOwner();
        } else if (event.getPickedNode() instanceof QElement) {
            elem = (QElement)event.getPickedNode();
        } else {
            this.frame.infoArea.setText("");
            return;
        }
        this.frame.infoArea.setText(var2_2.getInfo());
    }

    public void mouseMoved(PInputEvent event) {
        super.mouseMoved(event);
        this.showInfo(event);
    }

    public void setStructure(int i) {
        this.structureType = i;
    }

    public void mouseClicked(PInputEvent event) {
        if (event.isRightMouseButton()) {
            this.showPopup(event);
            return;
        }
        if (!event.isLeftMouseButton()) {
            return;
        }
        PLayer edgeLayer = ((PCanvas)event.getComponent()).getCamera().getLayer(0);
        PLayer nodeLayer = ((PCanvas)event.getComponent()).getCamera().getLayer(1);
        Point2D pressPoint = event.getPosition();
        switch (this.structureType) {
            case 0: {
                QNode node1 = new QNode((float)pressPoint.getX(), (float)pressPoint.getY(), "n" + Network.nodeCount++);
                QNode node2 = new QNode((float)pressPoint.getX(), (float)pressPoint.getY() + 60.0f, "n" + Network.nodeCount++);
                QNode node3 = new QNode((float)pressPoint.getX(), (float)pressPoint.getY() + 120.0f, "n" + Network.nodeCount++);
                QEdge edge1 = new QEdge("e" + Network.edgeCount++);
                edge1.setSource(node1);
                edge1.setTarget(node2);
                node1.addEdge(edge1);
                node2.addEdge(edge1);
                QEdge edge2 = new QEdge("e" + Network.edgeCount++);
                edge2.setSource(node2);
                edge2.setTarget(node3);
                node2.addEdge(edge2);
                node3.addEdge(edge2);
                node1.addToLayer(nodeLayer);
                node2.addToLayer(nodeLayer);
                node3.addToLayer(nodeLayer);
                edgeLayer.addChild((PNode)edge1);
                edgeLayer.addChild((PNode)edge2);
                edge1.update();
                edge2.update();
                Network.nCount += 3;
                Network.eCount += 2;
                this.frame.updateStatus();
                break;
            }
            case 1: {
                QNode node1 = new QNode((float)pressPoint.getX(), (float)pressPoint.getY(), "n" + Network.nodeCount++);
                QNode node2 = new QNode((float)pressPoint.getX() + 50.0f, (float)pressPoint.getY() + 50.0f, "n" + Network.nodeCount++);
                QNode node3 = new QNode((float)pressPoint.getX(), (float)pressPoint.getY() + 100.0f, "n" + Network.nodeCount++);
                QEdge edge1 = new QEdge("e" + Network.edgeCount++);
                edge1.setSource(node1);
                edge1.setTarget(node2);
                node1.addEdge(edge1);
                node2.addEdge(edge1);
                QEdge edge2 = new QEdge("e" + Network.edgeCount++);
                edge2.setSource(node2);
                edge2.setTarget(node3);
                node2.addEdge(edge2);
                node3.addEdge(edge2);
                QEdge edge3 = new QEdge("e" + Network.edgeCount++);
                edge3.setSource(node1);
                edge3.setTarget(node3);
                node1.addEdge(edge3);
                node3.addEdge(edge3);
                node1.addToLayer(nodeLayer);
                node2.addToLayer(nodeLayer);
                node3.addToLayer(nodeLayer);
                edgeLayer.addChild((PNode)edge1);
                edgeLayer.addChild((PNode)edge2);
                edgeLayer.addChild((PNode)edge3);
                edge1.update();
                edge2.update();
                edge3.update();
                Network.nCount += 3;
                Network.eCount += 3;
                this.frame.updateStatus();
                break;
            }
            case 3: {
                QNode node1 = new QNode((float)pressPoint.getX(), (float)pressPoint.getY(), "n" + Network.nodeCount++);
                QNode node2 = new QNode((float)pressPoint.getX() + 70.0f, (float)pressPoint.getY(), "n" + Network.nodeCount++);
                QNode node3 = new QNode((float)pressPoint.getX(), (float)pressPoint.getY() + 70.0f, "n" + Network.nodeCount++);
                QNode node4 = new QNode((float)pressPoint.getX() + 70.0f, (float)pressPoint.getY() + 70.0f, "n" + Network.nodeCount++);
                QEdge edge1 = new QEdge("e" + Network.edgeCount++);
                edge1.setSource(node1);
                edge1.setTarget(node3);
                node1.addEdge(edge1);
                node3.addEdge(edge1);
                QEdge edge2 = new QEdge("e" + Network.edgeCount++);
                edge2.setSource(node1);
                edge2.setTarget(node4);
                node1.addEdge(edge2);
                node4.addEdge(edge2);
                QEdge edge3 = new QEdge("e" + Network.edgeCount++);
                edge3.setSource(node2);
                edge3.setTarget(node3);
                node2.addEdge(edge3);
                node3.addEdge(edge3);
                QEdge edge4 = new QEdge("e" + Network.edgeCount++);
                edge4.setSource(node2);
                edge4.setTarget(node4);
                node2.addEdge(edge4);
                node4.addEdge(edge4);
                node1.addToLayer(nodeLayer);
                node2.addToLayer(nodeLayer);
                node3.addToLayer(nodeLayer);
                node4.addToLayer(nodeLayer);
                edgeLayer.addChild((PNode)edge1);
                edgeLayer.addChild((PNode)edge2);
                edgeLayer.addChild((PNode)edge3);
                edgeLayer.addChild((PNode)edge4);
                edge1.update();
                edge2.update();
                edge3.update();
                edge4.update();
                Network.nCount += 4;
                Network.eCount += 4;
                this.frame.updateStatus();
                break;
            }
            case 4: {
                QNode node;
                int i;
                ArrayList mn = this.mToN();
                if (mn == null) break;
                int m = (Integer)mn.get(0);
                int n = (Integer)mn.get(1);
                ArrayList<QNode> mNodes = new ArrayList<QNode>(m);
                ArrayList<QNode> nNodes = new ArrayList<QNode>(n);
                int shift = 0;
                if (m < n) {
                    shift = 35 * (n - m);
                }
                for (i = 0; i < m; ++i) {
                    node = new QNode((float)pressPoint.getX() + (float)(70 * i) + (float)shift, (float)pressPoint.getY(), "n" + Network.nodeCount++);
                    node.addToLayer(nodeLayer);
                    mNodes.add(node);
                }
                shift = m > n ? 35 * (m - n) : 0;
                for (i = 0; i < n; ++i) {
                    node = new QNode((float)pressPoint.getX() + (float)(70 * i) + (float)shift, (float)pressPoint.getY() + 70.0f, "n" + Network.nodeCount++);
                    node.addToLayer(nodeLayer);
                    nNodes.add(node);
                }
                for (int s = 0; s < m; ++s) {
                    for (int t = 0; t < n; ++t) {
                        QEdge edge = new QEdge("e" + Network.edgeCount++);
                        QNode snode = (QNode)mNodes.get(s);
                        QNode tnode = (QNode)nNodes.get(t);
                        edge.setSource(snode);
                        edge.setTarget(tnode);
                        snode.addEdge(edge);
                        tnode.addEdge(edge);
                        edgeLayer.addChild((PNode)edge);
                        edge.update();
                    }
                }
                Network.nCount += m + n;
                Network.eCount += m * n;
                this.frame.updateStatus();
                break;
            }
            case 2: {
                QNode node1 = new QNode((float)pressPoint.getX(), (float)pressPoint.getY(), "n" + Network.nodeCount++);
                QNode node2 = new QNode((float)pressPoint.getX() - 50.0f, (float)pressPoint.getY() + 50.0f, "n" + Network.nodeCount++);
                QNode node3 = new QNode((float)pressPoint.getX() + 50.0f, (float)pressPoint.getY() + 50.0f, "n" + Network.nodeCount++);
                QNode node4 = new QNode((float)pressPoint.getX(), (float)pressPoint.getY() + 100.0f, "n" + Network.nodeCount++);
                QEdge edge1 = new QEdge("e" + Network.edgeCount++);
                edge1.setSource(node1);
                edge1.setTarget(node2);
                node1.addEdge(edge1);
                node2.addEdge(edge1);
                QEdge edge2 = new QEdge("e" + Network.edgeCount++);
                edge2.setSource(node1);
                edge2.setTarget(node3);
                node1.addEdge(edge2);
                node3.addEdge(edge2);
                QEdge edge3 = new QEdge("e" + Network.edgeCount++);
                edge3.setSource(node2);
                edge3.setTarget(node4);
                node2.addEdge(edge3);
                node4.addEdge(edge3);
                QEdge edge4 = new QEdge("e" + Network.edgeCount++);
                edge4.setSource(node3);
                edge4.setTarget(node4);
                node3.addEdge(edge4);
                node4.addEdge(edge4);
                node1.addToLayer(nodeLayer);
                node2.addToLayer(nodeLayer);
                node3.addToLayer(nodeLayer);
                node4.addToLayer(nodeLayer);
                edgeLayer.addChild((PNode)edge1);
                edgeLayer.addChild((PNode)edge2);
                edgeLayer.addChild((PNode)edge3);
                edgeLayer.addChild((PNode)edge4);
                edge1.update();
                edge2.update();
                edge3.update();
                edge4.update();
                Network.nCount += 4;
                Network.eCount += 4;
                this.frame.updateStatus();
                break;
            }
        }
        this.frame.isModif = true;
        this.frame.setTitleModif();
    }

    private ArrayList mToN() {
        Object[] message = new Object[3];
        JSpinner mSpinner = new JSpinner(new SpinnerNumberModel(4, 0, Integer.MAX_VALUE, 1));
        JSpinner nSpinner = new JSpinner(new SpinnerNumberModel(4, 0, Integer.MAX_VALUE, 1));
        JTextField nTextField = new JTextField(25);
        JLabel mLabel = new JLabel("m:");
        mLabel.setAlignmentX(0.0f);
        JLabel nLabel = new JLabel("n: ");
        nLabel.setAlignmentX(0.0f);
        JPanel pm = new JPanel(new BorderLayout(5, 5));
        pm.add((Component)mLabel, "West");
        pm.add((Component)mSpinner, "Center");
        JPanel pn = new JPanel(new BorderLayout(5, 5));
        pn.add((Component)nLabel, "West");
        pn.add((Component)nSpinner, "Center");
        message[0] = "<html>Please select <em>m</em> and <em>n</em>:</html>";
        message[1] = pm;
        message[2] = pn;
        Object[] options = new String[]{"Ok", "Cancel"};
        int result = JOptionPane.showOptionDialog(this.frame, message, "Please configure m to n pattern", -1, 1, null, options, options[0]);
        switch (result) {
            case 0: {
                ArrayList<Object> mn = new ArrayList<Object>();
                mn.add(mSpinner.getValue());
                mn.add(nSpinner.getValue());
                return mn;
            }
        }
        return null;
    }
}

