/*
 * Decompiled with CFR 0.152.
 */
package netmatch.qtool;

import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolox.util.PFixedWidthStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import netmatch.qtool.QElement;
import netmatch.qtool.QNode;

public class QEdge
extends PPath
implements QElement {
    private static final Color EDGE_COLOR = new Color(33, 33, 119);
    private static final PFixedWidthStroke eStroke = new PFixedWidthStroke(2.0f);
    private QNode source;
    private QNode target;
    private String attr = "?";
    private String id;
    private int valence = 0;
    Point2D.Float p11;
    Point2D.Float p21;
    Point2D.Float middle;
    Point2D.Float p1;
    Point2D.Float p2;
    Point2D.Float point;
    AffineTransform at;

    public QEdge(String id) {
        this.setStroke((Stroke)eStroke);
        this.setStrokePaint(EDGE_COLOR);
        this.id = id;
        this.point = new Point2D.Float();
        this.p11 = new Point2D.Float();
        this.p21 = new Point2D.Float();
        this.p1 = new Point2D.Float();
        this.p2 = new Point2D.Float();
        this.middle = new Point2D.Float();
        this.at = new AffineTransform();
    }

    public QEdge(QNode s, QNode t, String id) {
        this(id);
        this.source = s;
        this.target = t;
        this.update();
    }

    public void setValence(int newValence) {
        this.valence = newValence;
    }

    public int getValence() {
        return this.valence;
    }

    public void update() {
        boolean flag = false;
        QNode first = this.source;
        QNode second = this.target;
        float shift = 20.0f * (float)Math.floor((this.valence + 1) / 2);
        float sign = 1.0f;
        if (this.valence % 2 == 0) {
            sign = -1.0f;
        }
        if (this.target.getId().compareTo(this.source.getId()) < 0) {
            first = this.target;
            second = this.source;
            flag = true;
        }
        Point2D start = first.getFullBoundsReference().getCenter2D();
        Point2D end = second.getFullBoundsReference().getCenter2D();
        this.reset();
        this.moveTo((float)start.getX(), (float)start.getY());
        if (this.valence > 0) {
            this.point.setLocation((float)start.getX() + (float)(end.getX() - start.getX()) / 2.0f, (float)start.getY() + (float)(end.getY() - start.getY()) / 2.0f);
            double angle = Math.atan((end.getY() - start.getY()) / (end.getX() - start.getX()));
            if (end.getX() >= start.getX()) {
                this.point.setLocation(this.point.getX() + (double)(sign * shift) * Math.sin(angle), this.point.getY() - (double)(sign * shift) * Math.cos(angle));
            } else {
                this.point.setLocation(this.point.getX() - (double)(sign * shift) * Math.sin(angle), this.point.getY() + (double)(sign * shift) * Math.cos(angle));
            }
            this.lineTo((float)this.point.getX(), (float)this.point.getY());
        } else {
            this.point.setLocation((start.getX() + end.getX()) / 2.0, (start.getY() + end.getY()) / 2.0);
        }
        this.lineTo((float)end.getX(), (float)end.getY());
        if (flag) {
            this.drawArrow(this.point, start);
        } else {
            this.drawArrow(this.point, end);
        }
    }

    private void drawArrow(Point2D start, Point2D end) {
        this.middle.setLocation(((float)start.getX() + (float)end.getX()) / 2.0f, ((float)start.getY() + (float)end.getY()) / 2.0f);
        this.p1.setLocation((float)this.middle.getX() - 5.0f, (float)this.middle.getY() - 5.0f);
        this.p2.setLocation((float)this.middle.getX() - 5.0f, (float)this.middle.getY() + 5.0f);
        double d1 = start.distance(end);
        double d2 = start.distance(end.getX(), start.getY());
        double angle = Math.acos(d2 / d1);
        if (end.getX() < start.getX()) {
            this.p1.setLocation((float)this.middle.getX() + 5.0f, (float)this.middle.getY() - 5.0f);
            this.p2.setLocation((float)this.middle.getX() + 5.0f, (float)this.middle.getY() + 5.0f);
        } else if (end.getX() == start.getX() && end.getY() < start.getY()) {
            this.p1.setLocation((float)this.p1.getX() + 10.0f, (float)this.p1.getY());
            this.p2.setLocation((float)this.p2.getX() + 10.0f, (float)this.p2.getY());
        }
        if (end.getX() < start.getX() && end.getY() > start.getY() || end.getX() > start.getX() && end.getY() < start.getY()) {
            angle = -angle;
        }
        this.at.setToIdentity();
        this.at.rotate(angle, this.middle.getX(), this.middle.getY());
        this.at.transform(this.p1, this.p11);
        this.at.transform(this.p2, this.p21);
        this.moveTo((float)this.middle.getX(), (float)this.middle.getY());
        this.lineTo((float)this.p11.getX(), (float)this.p11.getY());
        this.moveTo((float)this.middle.getX(), (float)this.middle.getY());
        this.lineTo((float)this.p21.getX(), (float)this.p21.getY());
    }

    public void delete(PLayer nodeLayer, PLayer edgeLayer) {
        if (this.getSource() != null) {
            this.getSource().removeEdge(this);
        }
        if (this.getTarget() != null) {
            this.getTarget().removeEdge(this);
        }
        edgeLayer.removeChild((PNode)this);
    }

    public String getInfo() {
        return "Edge\nId: " + this.id + "\n" + "Attribute: " + this.attr + "\n" + "Source Id: " + this.getSource().getId() + "\n" + "Target Id: " + this.getTarget().getId() + "\n";
    }

    public String getId() {
        return this.id;
    }

    void drawTo(Point2D end) {
        if (this.source == null) {
            return;
        }
        Point2D start = this.source.getFullBoundsReference().getCenter2D();
        this.reset();
        this.moveTo((float)start.getX(), (float)start.getY());
        this.lineTo((float)end.getX(), (float)end.getY());
        this.point.setLocation((start.getX() + end.getX()) / 2.0, (start.getY() + end.getY()) / 2.0);
        this.drawArrow(this.point, end);
    }

    public void setAttr(String attr) {
        this.attr = attr;
    }

    public String getAttr() {
        return this.attr;
    }

    public QNode getSource() {
        return this.source;
    }

    void setSource(QNode s) {
        this.source = s;
    }

    public QNode getTarget() {
        return this.target;
    }

    void setTarget(QNode t) {
        this.target = t;
    }
}

