/*
 * Decompiled with CFR 0.152.
 */
package netmatch.qtool;

import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PLayer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import netmatch.qtool.Network;
import netmatch.qtool.QEdge;
import netmatch.qtool.QElement;
import netmatch.qtool.QLoop;
import netmatch.qtool.QNode;
import netmatch.qtool.QPath;
import netmatch.qtool.QToolFrame;

public class QPopupMenu
extends JPopupMenu
implements ActionListener {
    private QToolFrame frame;
    private QElement popupElement;
    private PLayer nodeLayer;
    private PLayer edgeLayer;
    private String[] constrains = new String[]{">", ">=", "<", "<=", "="};

    public QPopupMenu(QToolFrame frame) {
        this.frame = frame;
        JMenuItem mItem = new JMenuItem("Edit Attribute...", frame.menu[14]);
        mItem.addActionListener(this);
        this.add(mItem);
        mItem = new JMenuItem("Delete", frame.menu[13]);
        mItem.addActionListener(this);
        this.add(mItem);
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals("Edit Attribute...")) {
            String oldLabel = this.popupElement.getAttr();
            String newLabel = this.popupElement instanceof QPath ? this.editPath(oldLabel) : this.editAttr(oldLabel);
            if (newLabel != null) {
                this.popupElement.setAttr(newLabel);
                this.popupElement.update();
                this.frame.isModif = true;
                this.frame.setTitleModif();
            }
        } else if (command.equals("Delete")) {
            this.popupElement.delete(this.nodeLayer, this.edgeLayer);
            this.frame.isModif = true;
            this.frame.setTitleModif();
            if (this.popupElement instanceof QNode) {
                --Network.nCount;
            } else if (this.popupElement instanceof QLoop) {
                --Network.lCount;
            } else if (this.popupElement instanceof QEdge) {
                --Network.eCount;
            } else if (this.popupElement instanceof QPath) {
                --Network.pCount;
            }
            this.frame.updateStatus();
        }
    }

    private int parseConstrain(String attr) {
        String c = attr.substring(1, 3);
        if (this.constrains[1].equals(c)) {
            return 1;
        }
        if (this.constrains[3].equals(c)) {
            return 3;
        }
        c = attr.substring(1, 2);
        if (this.constrains[0].equals(c)) {
            return 0;
        }
        if (this.constrains[2].equals(c)) {
            return 2;
        }
        if (this.constrains[4].equals(c)) {
            return 4;
        }
        return -1;
    }

    private int parseNumber(int constrainIndex, String attr) {
        int beginIndex = 1 + this.constrains[constrainIndex].length();
        return Integer.parseInt(attr.substring(beginIndex));
    }

    public void show(Component invoker, int x, int y, QElement popupElement) {
        this.popupElement = popupElement;
        this.nodeLayer = ((PCanvas)invoker).getCamera().getLayer(1);
        this.edgeLayer = ((PCanvas)invoker).getCamera().getLayer(0);
        super.show(invoker, x, y);
    }

    private String editAttr(String oldattr) {
        Object[] message = new Object[3];
        final JTextField textField = new JTextField(25);
        JRadioButton inexButton = new JRadioButton("Unlabeled.");
        inexButton.setAlignmentX(0.0f);
        inexButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JRadioButton o = (JRadioButton)e.getSource();
                if (o.isSelected()) {
                    textField.setEnabled(false);
                }
            }
        });
        JRadioButton exButton = new JRadioButton("Labeled: ");
        exButton.setAlignmentX(0.0f);
        exButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JRadioButton o = (JRadioButton)e.getSource();
                if (o.isSelected()) {
                    textField.setEnabled(true);
                }
            }
        });
        if (oldattr.charAt(0) == '?') {
            inexButton.setSelected(true);
            textField.setEnabled(false);
        } else {
            exButton.setSelected(true);
            textField.setEnabled(true);
            textField.setText(oldattr);
        }
        ButtonGroup group = new ButtonGroup();
        group.add(inexButton);
        group.add(exButton);
        JPanel p = new JPanel(new BorderLayout(5, 5));
        p.add((Component)exButton, "West");
        p.add((Component)textField, "Center");
        message[0] = "Please enter attribute:";
        message[1] = inexButton;
        message[2] = p;
        Object[] options = new String[]{"Ok", "Cancel"};
        int result = JOptionPane.showOptionDialog(this.frame, message, "Edit Attribute", -1, 1, this.frame.menu[16], options, options[0]);
        switch (result) {
            case 0: {
                if (inexButton.isSelected()) {
                    return "?";
                }
                if (textField.getText().equals("")) {
                    return "?";
                }
                return textField.getText();
            }
        }
        return null;
    }

    private String editPath(String oldattr) {
        Object[] message = new Object[2];
        JComboBox<String> list = new JComboBox<String>(this.constrains);
        int ci = this.parseConstrain(oldattr);
        list.setSelectedIndex(ci);
        JSpinner spinner = new JSpinner(new SpinnerNumberModel(this.parseNumber(ci, oldattr), 0, Integer.MAX_VALUE, 1));
        spinner.setValue(new Integer(this.parseNumber(ci, oldattr)));
        JPanel p = new JPanel(new BorderLayout(5, 5));
        p.add(list, "West");
        p.add((Component)spinner, "Center");
        message[0] = "Please set the path length:";
        message[1] = p;
        Object[] options = new String[]{"Ok", "Cancel"};
        int result = JOptionPane.showOptionDialog(this.frame, message, "Approximate Path Attribute", -1, 1, this.frame.menu[16], options, options[0]);
        switch (result) {
            case 0: {
                return "?" + this.constrains[list.getSelectedIndex()] + (Integer)spinner.getValue();
            }
        }
        return null;
    }
}

