/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csapps.socialnetwork;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.baderlab.csapps.socialnetwork.NotificationThread;
import org.baderlab.csapps.socialnetwork.PropsReader;
import org.baderlab.csapps.socialnetwork.model.Collaboration;
import org.baderlab.csapps.socialnetwork.model.academia.Author;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CytoscapeUtilities {
    private static final Logger logger = Logger.getLogger(CytoscapeUtilities.class.getName());
    private static HashSet<String> locationSet = null;
    public static String buildId = "";
    public static String pluginReleaseSuffix = "";
    public static String pluginUrl = "";
    public static String pluginVersion = "";
    public static String userManualUrl = "";
    public Properties build_props = new Properties();
    public Properties plugin_props = new Properties();
    public String pluginName = "";
    private static PropsReader propsReader = null;

    public static HashSet<String> getLocationSet() {
        if (locationSet == null) {
            String[] locations;
            locationSet = new HashSet();
            for (String location : locations = new String[]{"univ toronto", "ontario", "canada", "united states", "international", "other"}) {
                locationSet.add(location);
            }
        }
        return locationSet;
    }

    public static VisualStyle getVisualStyle(String name, VisualMappingManager visualMappingManager) {
        Iterator it = visualMappingManager.getAllVisualStyles().iterator();
        VisualStyle visualStyle = null;
        while (it.hasNext() && !(visualStyle = (VisualStyle)it.next()).getTitle().equalsIgnoreCase(name)) {
            visualStyle = null;
        }
        return visualStyle;
    }

    public static void notifyUser(String message) {
        NotificationThread notify = new NotificationThread(message);
        notify.start();
    }

    public static int createDialogBox(String title, String defaultInstitution, CyNetwork cyNetwork, Long SUID) {
        JTextField institutionTextField = new JTextField(5);
        if (defaultInstitution != null) {
            institutionTextField.setText(defaultInstitution);
            institutionTextField.setEditable(false);
        }
        JTextField locationTextField = new JTextField(5);
        JPanel myPanel = new JPanel();
        myPanel.setLayout(new BoxLayout(myPanel, 1));
        myPanel.add(new JLabel("Institution"));
        myPanel.add(institutionTextField);
        myPanel.add(new JLabel("Location"));
        myPanel.add(locationTextField);
        int outcome = 0;
        String institution = "N/A";
        String location = "N/A";
        while (outcome == 0) {
            outcome = JOptionPane.showConfirmDialog(null, myPanel, title, 2);
            if (outcome != 0) continue;
            institution = institutionTextField.getText().trim();
            location = locationTextField.getText().trim();
            if (institution.isEmpty() && location.isEmpty()) {
                CytoscapeUtilities.notifyUser("Please specify both an institution and a location");
                continue;
            }
            if (institution.isEmpty()) {
                CytoscapeUtilities.notifyUser("Please specify an institution");
                continue;
            }
            if (location.isEmpty()) {
                CytoscapeUtilities.notifyUser("Please specify a location");
                continue;
            }
            if (!CytoscapeUtilities.getLocationSet().contains(location.toLowerCase())) {
                CytoscapeUtilities.notifyUser("Location does not exist. Please enter a valid location.");
                continue;
            }
            institution = institution.toUpperCase();
            String[] words = location.split("\\s");
            location = "";
            for (String word : words) {
                location = location + word.replaceAll("^\\w", word.substring(0, 1).toUpperCase()) + " ";
            }
            location = location.trim();
            outcome = 2;
            if (institution.trim().isEmpty() || location.trim().isEmpty()) continue;
            propsReader.getProperties().put(institution, location);
            if (defaultInstitution == null) continue;
            CyTable cyTable = cyNetwork.getDefaultNodeTable();
            CytoscapeUtilities.setCyTableAttribute(cyTable, SUID, "Location", location);
        }
        return outcome;
    }

    public static Author getAuthor(String label, Collaboration[] collabArray) {
        Collaboration collab = null;
        Author author1 = null;
        Author author2 = null;
        for (int i = 0; i < collabArray.length; ++i) {
            collab = collabArray[i];
            author1 = (Author)collab.getNode1();
            author2 = (Author)collab.getNode2();
            if (author1.getLabel().equals(label)) {
                return author1;
            }
            if (!author2.getLabel().equals(label)) continue;
            return author2;
        }
        return null;
    }

    public static void setCyTableAttribute(CyTable cyTable, Long SUID, String attributeName, Object value) {
        CyRow cyRow = cyTable.getRow((Object)SUID);
        cyRow.set(attributeName, value);
    }

    public static Object getCyTableAttribute(CyTable cyTable, Long SUID, String attributeName) {
        CyRow cyRow = cyTable.getRow((Object)SUID);
        return cyRow.getAllValues().get(attributeName);
    }

    public CytoscapeUtilities() {
        try {
            this.plugin_props = this.getPropertiesFromClasspath("plugin.props", false);
        }
        catch (IOException ei) {
            System.out.println("Neither of the configuration files could be found");
        }
        pluginUrl = this.plugin_props.getProperty("pluginURL", "http://baderlab.org/Software/SocialNetworkApp");
        userManualUrl = pluginUrl + "/UserManual";
        pluginVersion = this.plugin_props.getProperty("pluginVersion", "0.1");
        pluginReleaseSuffix = this.plugin_props.getProperty("pluginReleaseSuffix", "");
        this.pluginName = this.plugin_props.getProperty("pluginName", "SocialNetworkApp");
        try {
            this.build_props = this.getPropertiesFromClasspath("revision.txt", true);
        }
        catch (IOException e) {
            this.build_props.setProperty("build.number", "0");
            this.build_props.setProperty("git.commit.id", "0");
            this.build_props.setProperty("build.user", "user");
            this.build_props.setProperty("git.build.time", "1900/01/01 00:00:00 +0000 (GMT)");
        }
        buildId = "Build: " + this.build_props.getProperty("build.number") + " from GIT: " + this.build_props.getProperty("git.commit.id") + " by: " + this.build_props.getProperty("build.user");
    }

    private Properties getPropertiesFromClasspath(String propFileName, boolean inMaindir) throws IOException {
        Properties props = new Properties();
        InputStream inputStream = null;
        inputStream = inMaindir ? this.getClass().getClassLoader().getResourceAsStream(propFileName) : this.getClass().getResourceAsStream(propFileName);
        if (inputStream == null) {
            throw new FileNotFoundException("property file '" + propFileName + "' not found in the classpath");
        }
        props.load(inputStream);
        return props;
    }

    public static void setPropsReader(PropsReader propsReader) {
        CytoscapeUtilities.propsReader = propsReader;
        if (CytoscapeUtilities.propsReader.getProperties().isEmpty()) {
            try {
                InputStream in = CytoscapeUtilities.class.getResourceAsStream("model/academia/locationsmap.txt");
                BufferedReader br = new BufferedReader(new InputStreamReader(in));
                String sCurrentLine = null;
                while ((sCurrentLine = br.readLine()) != null) {
                    String[] tokens = sCurrentLine.split("\t");
                    if (tokens.length == 2) {
                        CytoscapeUtilities.propsReader.getProperties().put(tokens[0], tokens[1]);
                        continue;
                    }
                    logger.log(Level.WARNING, "Misformed line in locationmap file\n \"" + sCurrentLine + "\n");
                }
            }
            catch (FileNotFoundException e) {
                logger.log(Level.SEVERE, "Exception occurred", e);
                CytoscapeUtilities.notifyUser("Failed to load location map. FileNotFoundException.");
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Exception occurred", e);
                CytoscapeUtilities.notifyUser("Failed to load location map. IOException.");
            }
        }
    }

    public static PropsReader getPropsReader() {
        return propsReader;
    }
}

