/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csapps.socialnetwork.listeners;

import java.awt.Component;
import java.awt.Cursor;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.baderlab.csapps.socialnetwork.CytoscapeUtilities;
import org.baderlab.csapps.socialnetwork.model.SocialNetwork;
import org.baderlab.csapps.socialnetwork.model.SocialNetworkAppManager;
import org.baderlab.csapps.socialnetwork.model.academia.visualstyles.BaseAcademiaVisualStyle;
import org.baderlab.csapps.socialnetwork.model.academia.visualstyles.IncitesVisualStyle;
import org.baderlab.csapps.socialnetwork.model.academia.visualstyles.NodeAttribute;
import org.baderlab.csapps.socialnetwork.panels.InfoPanel;
import org.baderlab.csapps.socialnetwork.tasks.CreateChartTaskFactory;
import org.baderlab.csapps.socialnetwork.tasks.HideAuthorsTaskFactory;
import org.baderlab.csapps.socialnetwork.tasks.ShowAllNodesTaskFactory;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.application.swing.CytoPanel;
import org.cytoscape.application.swing.CytoPanelComponent;
import org.cytoscape.application.swing.CytoPanelName;
import org.cytoscape.application.swing.CytoPanelState;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.events.NetworkAddedEvent;
import org.cytoscape.model.events.NetworkAddedListener;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.vizmap.VisualMappingFunctionFactory;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyleFactory;
import org.cytoscape.work.TaskManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SocialNetworkAddedListener
implements NetworkAddedListener {
    private static final Logger logger = Logger.getLogger(SocialNetworkAddedListener.class.getName());
    private SocialNetworkAppManager appManager = null;
    private CyNetworkManager cyNetworkManagerServiceRef = null;
    private VisualMappingManager vmmServiceRef = null;
    private VisualStyleFactory visualStyleFactoryServiceRef;
    private VisualMappingFunctionFactory passthroughMappingFactoryServiceRef;
    private VisualMappingFunctionFactory continuousMappingFactoryServiceRef;
    private VisualMappingFunctionFactory discreteMappingFactoryServiceRef;
    private CyNetwork network = null;
    private SocialNetwork socialNetwork = null;
    private CytoPanel cytoPanelEast = null;
    private InfoPanel infoPanel = null;
    private CyServiceRegistrar cyServiceRegistrarRef = null;
    private CySwingApplication cySwingApplicationServiceRef = null;
    private TaskManager<?, ?> taskManager = null;
    private HideAuthorsTaskFactory updateVisualStyleTaskFactory = null;
    private CyApplicationManager cyApplicationManagerServiceRef = null;
    private ShowAllNodesTaskFactory showAllNodesTaskFactory = null;
    private CreateChartTaskFactory createChartTaskFactory = null;

    public SocialNetworkAddedListener(SocialNetworkAppManager appManager, CyNetworkManager cyNetworkManagerServiceRef, VisualMappingManager vmmServiceRef, VisualStyleFactory visualStyleFactoryServiceRef, VisualMappingFunctionFactory passthroughMappingFactoryServiceRef, VisualMappingFunctionFactory continuousMappingFactoryServiceRef, VisualMappingFunctionFactory discreteMappingFactoryServiceRef, CyServiceRegistrar cyServiceRegistrarRef, CySwingApplication cySwingApplicationServiceRef, TaskManager<?, ?> taskManager, HideAuthorsTaskFactory updateVisualStyleTaskFactory, CyApplicationManager cyApplicationManagerServiceRef, ShowAllNodesTaskFactory showAllNodesTaskFactory, CreateChartTaskFactory createChartTaskFactory) {
        this.appManager = appManager;
        this.cyNetworkManagerServiceRef = cyNetworkManagerServiceRef;
        this.vmmServiceRef = vmmServiceRef;
        this.visualStyleFactoryServiceRef = visualStyleFactoryServiceRef;
        this.passthroughMappingFactoryServiceRef = passthroughMappingFactoryServiceRef;
        this.continuousMappingFactoryServiceRef = continuousMappingFactoryServiceRef;
        this.discreteMappingFactoryServiceRef = discreteMappingFactoryServiceRef;
        this.cyServiceRegistrarRef = cyServiceRegistrarRef;
        this.cytoPanelEast = cySwingApplicationServiceRef.getCytoPanel(CytoPanelName.EAST);
        this.taskManager = taskManager;
        this.updateVisualStyleTaskFactory = updateVisualStyleTaskFactory;
        this.cyApplicationManagerServiceRef = cyApplicationManagerServiceRef;
        this.showAllNodesTaskFactory = showAllNodesTaskFactory;
        this.createChartTaskFactory = createChartTaskFactory;
    }

    private void initializeInfoPanel() {
        this.infoPanel = new InfoPanel(this.taskManager, this.updateVisualStyleTaskFactory, this.socialNetwork, this.cyServiceRegistrarRef, this.showAllNodesTaskFactory, this.createChartTaskFactory);
    }

    private void handleNetwork(CyNetwork cyNetwork) {
        this.appManager.getUserPanelRef().setCursor(new Cursor(0));
        String name = SocialNetworkAppManager.getNetworkName(cyNetwork);
        if (this.appManager.getSocialNetworkMap().containsKey(name)) {
            this.socialNetwork = this.appManager.getSocialNetworkMap().get(name);
            String startYearTxt = SocialNetworkAppManager.getStartDateTextFieldRef().getText().trim();
            String endYearTxt = SocialNetworkAppManager.getEndDateTextFieldRef().getText().trim();
            int startYear = -1;
            int endYear = -1;
            if (Pattern.matches("[0-9]+", startYearTxt) && Pattern.matches("[0-9]+", endYearTxt)) {
                startYear = Integer.parseInt(startYearTxt);
                endYear = Integer.parseInt(endYearTxt);
            }
            this.socialNetwork.setStartYear(startYear);
            this.socialNetwork.setEndYear(endYear);
            this.socialNetwork.setCyNetwork(cyNetwork);
            this.appManager.getUserPanelRef().addNetworkToNetworkPanel(this.socialNetwork);
            if (cyNetwork.getDefaultNodeTable().getColumn(NodeAttribute.PUBS_PER_YEAR.toString()) != null) {
                int index;
                if (SocialNetworkAppManager.getInfoPanel() == null) {
                    this.initializeInfoPanel();
                    this.cyServiceRegistrarRef.registerService((Object)this.infoPanel, CytoPanelComponent.class, new Properties());
                    SocialNetworkAppManager.setInfoPanel(this.infoPanel);
                } else {
                    this.infoPanel.update(this.socialNetwork);
                }
                if (this.cytoPanelEast.getState() == CytoPanelState.HIDE) {
                    this.cytoPanelEast.setState(CytoPanelState.DOCK);
                }
                if ((index = this.cytoPanelEast.indexOfComponent((Component)this.infoPanel)) == -1) {
                    return;
                }
                this.cytoPanelEast.setSelectedIndex(index);
            } else {
                logger.log(Level.WARNING, String.format("Display Options panel disabled because %s does not contain the pubs per year attribute.", this.socialNetwork.getNetworkName()));
            }
            int networkID = this.socialNetwork.getNetworkType();
            switch (networkID) {
                case 1410511959: {
                    if (CytoscapeUtilities.getVisualStyle(String.format("%s_InCites", this.socialNetwork.getNetworkName()), this.vmmServiceRef) != null) break;
                    IncitesVisualStyle incitesVisualStyle = new IncitesVisualStyle(this.cyApplicationManagerServiceRef, cyNetwork, this.socialNetwork, this.visualStyleFactoryServiceRef, this.passthroughMappingFactoryServiceRef, this.continuousMappingFactoryServiceRef, this.discreteMappingFactoryServiceRef, false);
                    this.vmmServiceRef.addVisualStyle(incitesVisualStyle.getVisualStyle());
                    break;
                }
                case -960949447: {
                    if (CytoscapeUtilities.getVisualStyle(String.format("%s_Scopus", this.socialNetwork.getNetworkName()), this.vmmServiceRef) != null) break;
                    BaseAcademiaVisualStyle scopusVisualStyle = new BaseAcademiaVisualStyle(this.cyApplicationManagerServiceRef, cyNetwork, this.socialNetwork, this.visualStyleFactoryServiceRef, this.passthroughMappingFactoryServiceRef, this.continuousMappingFactoryServiceRef, this.discreteMappingFactoryServiceRef, false);
                    this.vmmServiceRef.addVisualStyle(scopusVisualStyle.getVisualStyle());
                    break;
                }
                case -2113004178: {
                    if (CytoscapeUtilities.getVisualStyle(String.format("%s_PubMed", this.socialNetwork.getNetworkName()), this.vmmServiceRef) != null) break;
                    BaseAcademiaVisualStyle pubmedVisualStyle = new BaseAcademiaVisualStyle(this.cyApplicationManagerServiceRef, cyNetwork, this.socialNetwork, this.visualStyleFactoryServiceRef, this.passthroughMappingFactoryServiceRef, this.continuousMappingFactoryServiceRef, this.discreteMappingFactoryServiceRef, false);
                    this.vmmServiceRef.addVisualStyle(pubmedVisualStyle.getVisualStyle());
                    break;
                }
            }
            this.appManager.setCurrentlySelectedSocialNetwork(this.socialNetwork);
        }
    }

    public void handleEvent(NetworkAddedEvent event) {
        this.network = event.getNetwork();
        this.handleNetwork(this.network);
    }
}

