/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csapps.socialnetwork.model.academia;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.baderlab.csapps.socialnetwork.model.AbstractEdge;
import org.baderlab.csapps.socialnetwork.model.AbstractNode;
import org.baderlab.csapps.socialnetwork.model.Collaboration;
import org.baderlab.csapps.socialnetwork.model.SocialNetworkAppManager;
import org.baderlab.csapps.socialnetwork.model.academia.Publication;
import org.baderlab.csapps.socialnetwork.model.academia.UnableToParseYearException;
import org.baderlab.csapps.socialnetwork.model.academia.visualstyles.EdgeAttribute;
import org.cytoscape.model.CyEdge;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Copublication
extends AbstractEdge {
    private static final Logger logger = Logger.getLogger(Copublication.class.getName());
    private ArrayList<Publication> pubList = null;
    private Map<String, Object> edgeAttrMap = null;

    public Copublication(Collaboration collaboration, Publication publication) {
        this.setPubList(new ArrayList<Publication>());
        this.getPubList().add(publication);
        this.constructEdgeAttrMap();
    }

    public void addPublication(Publication publication) {
        this.getPubList().add(publication);
        this.getEdgeAttrMap().put(EdgeAttribute.COPUBLICATION_COUNT.toString(), this.getPubList().size());
        ((ArrayList)this.getEdgeAttrMap().get(EdgeAttribute.PUBLICATIONS.toString())).add(publication.getTitle());
        this.updateYearlyIntervalAttr();
    }

    @Override
    public void constructEdgeAttrMap() {
        this.setEdgeAttrMap(new HashMap<String, Object>());
        this.getEdgeAttrMap().put(EdgeAttribute.COPUBLICATION_COUNT.toString(), this.getPubList().size());
        ArrayList<String> titles = new ArrayList<String>();
        titles.add(this.getPubList().get(0).getTitle());
        this.getEdgeAttrMap().put(EdgeAttribute.PUBLICATIONS.toString(), titles);
        int startYear = SocialNetworkAppManager.getStartYear();
        int endYear = SocialNetworkAppManager.getEndYear();
        int size = endYear - startYear + 1;
        ArrayList<Integer> boolList = new ArrayList<Integer>(size);
        Publication pub = this.pubList.get(0);
        int pubYear = -1;
        try {
            pubYear = pub.getPubYear();
        }
        catch (UnableToParseYearException e) {
            logger.log(Level.WARNING, String.format("Year could not be parsed from raw text: %s", pub.getRawPubDateTxt()));
        }
        for (int year = startYear; year <= endYear; ++year) {
            boolList.add(pubYear == year ? 1 : 0);
        }
        this.edgeAttrMap.put(EdgeAttribute.PUBS_PER_YEAR.toString(), boolList);
    }

    private void updateYearlyIntervalAttr() {
        int startYear = SocialNetworkAppManager.getStartYear();
        int endYear = SocialNetworkAppManager.getEndYear();
        ArrayList boolList = (ArrayList)this.getEdgeAttrMap().get(EdgeAttribute.PUBS_PER_YEAR.toString());
        Publication pub = this.getPubList().get(this.getPubList().size() - 1);
        int pubYear = -1;
        try {
            pubYear = pub.getPubYear();
        }
        catch (UnableToParseYearException e) {
            logger.log(Level.WARNING, String.format("Year could not be parsed from raw text: %s", pub.getRawPubDateTxt()));
        }
        for (int year = startYear; year <= endYear; ++year) {
            if (pubYear != year) continue;
            int index = year - startYear;
            boolList.set(index, (Integer)boolList.get(index) + 1);
        }
        this.edgeAttrMap.put(EdgeAttribute.PUBS_PER_YEAR.toString(), boolList);
    }

    @Override
    public CyEdge getCyEdge() {
        return this.cyEdge;
    }

    @Override
    public Map<String, Object> getEdgeAttrMap() {
        return this.edgeAttrMap;
    }

    @Override
    public List<? extends AbstractNode> getNodes() {
        return null;
    }

    private ArrayList<Publication> getPubList() {
        return this.pubList;
    }

    public int getTotalPubs() {
        return this.getPubList().size();
    }

    @Override
    public void setCyEdge(CyEdge cyEdge) {
        this.cyEdge = cyEdge;
    }

    public void setEdgeAttrMap(Map<String, Object> edgeAttrMap) {
        this.edgeAttrMap = edgeAttrMap;
    }

    private void setPubList(ArrayList<Publication> pubList) {
        this.pubList = pubList;
    }
}

