/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csapps.socialnetwork.model.academia.parsers.pubmed;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.baderlab.csapps.socialnetwork.CytoscapeUtilities;
import org.baderlab.csapps.socialnetwork.model.SocialNetwork;
import org.baderlab.csapps.socialnetwork.model.academia.Publication;
import org.baderlab.csapps.socialnetwork.model.academia.Tag;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EutilsTimesCitedTask
extends AbstractTask {
    private static final Logger logger = Logger.getLogger(EutilsTimesCitedParser.class.getName());
    private ArrayList<Publication> pubList = new ArrayList();
    private StringBuilder pmid = null;
    private StringBuilder timesCited = null;
    private int numSaxConflicts = 0;
    private HashMap<String, Publication> pubMap = null;
    private SocialNetwork socialNetwork = null;

    private void createPubMap(ArrayList<Publication> pubList) {
        this.pubMap = new HashMap();
        Iterator<Publication> it = pubList.iterator();
        Publication pub = null;
        while (it.hasNext()) {
            pub = it.next();
            this.pubMap.put(pub.getPMID(), pub);
        }
    }

    public EutilsTimesCitedTask(SocialNetwork socialNetwork) {
        this.socialNetwork = socialNetwork;
        this.pmid = new StringBuilder();
        this.timesCited = new StringBuilder();
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        try {
            EutilsTimesCitedParser parser = new EutilsTimesCitedParser();
            SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
            String url = null;
            this.createPubMap(this.socialNetwork.getPublications());
            this.pubList = this.socialNetwork.getPublications();
            int totalPubs = this.pubList.size();
            String queryKey = this.socialNetwork.getEutilsResults().getQueryKey();
            String webEnv = this.socialNetwork.getEutilsResults().getWebEnv();
            int retStart = this.socialNetwork.getEutilsResults().getRetStart();
            int retMax = this.socialNetwork.getEutilsResults().getRetMax();
            while (retStart < totalPubs) {
                Tag tag = new Tag(queryKey, webEnv, retStart, retMax);
                url = String.format("http://eutils.ncbi.nlm.nih.gov/entrez/eutils/esummary.fcgi?db=pubmed%s", tag);
                saxParser.parse(url, (DefaultHandler)parser);
                int percentComplete = (int)((double)(retStart += retMax) / (double)totalPubs * 100.0);
                if (taskMonitor == null) continue;
                taskMonitor.setProgress((double)percentComplete);
            }
            this.socialNetwork.setPublications(parser.getPubList());
        }
        catch (ParserConfigurationException e) {
            logger.log(Level.SEVERE, "Exception occurred", e);
            CytoscapeUtilities.notifyUser("Encountered temporary server issues. Please try again some other time.");
        }
        catch (SAXException e) {
            logger.log(Level.SEVERE, "Exception occurred", e);
            CytoscapeUtilities.notifyUser("Encountered temporary server issues. Please try again some other time.");
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Exception occurred", e);
            CytoscapeUtilities.notifyUser("Unable to connect to PubMed. Please check your internet connection.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EutilsTimesCitedParser
    extends DefaultHandler {
        boolean isTimesCited = false;
        boolean isPMID = false;

        private EutilsTimesCitedParser() {
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.isPMID) {
                EutilsTimesCitedTask.this.pmid.append(ch, start, length);
            }
            if (this.isTimesCited) {
                EutilsTimesCitedTask.this.timesCited.append(ch, start, length);
            }
        }

        public boolean contains(Attributes attributes, String text) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (!attributes.getValue(i).equalsIgnoreCase(text)) continue;
                return true;
            }
            return false;
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equalsIgnoreCase("Id")) {
                this.isPMID = false;
            }
            if (qName.equalsIgnoreCase("Item") && this.isTimesCited) {
                this.isTimesCited = false;
            }
            if (qName.equalsIgnoreCase("DocSum")) {
                Publication pub = (Publication)EutilsTimesCitedTask.this.pubMap.get(EutilsTimesCitedTask.this.pmid.toString());
                if (pub != null) {
                    pub.setTimesCited(EutilsTimesCitedTask.this.timesCited.toString());
                } else {
                    logger.log(Level.SEVERE, String.format("Times cited could not be retrieved for publication with the following pmid: %s", EutilsTimesCitedTask.this.pmid));
                }
            }
        }

        public ArrayList<Publication> getPubList() {
            return EutilsTimesCitedTask.this.pubList;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (this.contains(attributes, "PmcRefCount")) {
                this.isTimesCited = true;
                EutilsTimesCitedTask.this.timesCited.setLength(0);
            }
            if (qName.equals("Id")) {
                this.isPMID = true;
                EutilsTimesCitedTask.this.pmid.setLength(0);
            }
        }

        public int getNumSaxConflicts() {
            return EutilsTimesCitedTask.this.numSaxConflicts;
        }
    }
}

