/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csapps.socialnetwork.panels;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.baderlab.csapps.socialnetwork.CytoscapeUtilities;
import org.baderlab.csapps.socialnetwork.model.SocialNetworkAppManager;
import org.baderlab.csapps.socialnetwork.model.academia.parsers.ParseScopus;
import org.baderlab.csapps.socialnetwork.panels.UserPanel;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.util.swing.BasicCollapsiblePanel;
import org.cytoscape.util.swing.FileChooserFilter;
import org.cytoscape.util.swing.FileUtil;

public class AcademiaPanel {
    private JPanel academiaInfoPanelRef = null;
    private JTextField facultyTextFieldRef = new JTextField();
    private JTextField pathTextFieldRef = new JTextField();
    private JTextField thresholdTextFieldRef = null;
    private JRadioButton incitesRadioButtonRef = null;
    private JRadioButton pubmedRadioButtonRef = null;
    private JRadioButton scopusRadioButtonRef = null;
    private JRadioButton thresholdRadioButtonRef = null;
    private JTextField startDateTextFieldRef = null;
    private JTextField endDateTextFieldRef = null;
    private JTextField searchBox = null;
    private File selectedFileRef = null;
    private SocialNetworkAppManager appManager = null;
    private FileUtil fileUtil = null;
    private JLabel pubMedSearchLabel = null;
    protected CySwingApplication cySwingAppRef = null;
    private JPanel bottomPanel = null;
    private JPanel buildPubMedQueryPanel = null;
    private JTextField buildPubMedQueryTextField = null;
    private static final Logger logger = Logger.getLogger(ParseScopus.class.getName());
    private JRadioButton selectPubMedSearchRadioButton = null;
    private JRadioButton selectFileInputRadioButton = null;

    public AcademiaPanel(SocialNetworkAppManager appManager, FileUtil fileUtil, CySwingApplication cySwingAppRef) {
        this.appManager = appManager;
        this.fileUtil = fileUtil;
        this.cySwingAppRef = cySwingAppRef;
    }

    private JLabel createPubMedSearchLabel() {
        final JLabel pubMedSearchLabel = new JLabel("PubMed Search");
        pubMedSearchLabel.setCursor(new Cursor(12));
        pubMedSearchLabel.setToolTipText("Click to go to PubMed search tutorial");
        pubMedSearchLabel.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent e) {
                pubMedSearchLabel.setForeground(Color.BLUE);
            }

            public void mouseExited(MouseEvent e) {
                pubMedSearchLabel.setForeground(Color.BLACK);
            }

            public void mouseClicked(MouseEvent e) {
                try {
                    Desktop.getDesktop().browse(new URI("http://www.nlm.nih.gov/bsd/mms/medlineelements.html"));
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                catch (URISyntaxException e2) {
                    e2.printStackTrace();
                }
            }
        });
        return pubMedSearchLabel;
    }

    private JPanel createSelectionPanel() {
        JPanel selectionPanel = new JPanel();
        selectionPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 40));
        selectionPanel.setLayout(new BoxLayout(selectionPanel, 1));
        this.selectPubMedSearchRadioButton = new JRadioButton("", true);
        this.selectPubMedSearchRadioButton.setFocusable(true);
        this.selectPubMedSearchRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JRadioButton selectPubMedSearchRadioButton = (JRadioButton)e.getSource();
                if (selectPubMedSearchRadioButton.isSelected()) {
                    AcademiaPanel.this.searchBox.setEnabled(true);
                    AcademiaPanel.this.buildPubMedQueryPanel.setVisible(true);
                    AcademiaPanel.this.bottomPanel.setVisible(false);
                    AcademiaPanel.this.bottomPanel.repaint();
                }
            }
        });
        this.selectFileInputRadioButton = new JRadioButton("File Input", false);
        this.selectFileInputRadioButton.setFocusable(false);
        this.selectFileInputRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JRadioButton selectFileInputRadioButton = (JRadioButton)e.getSource();
                if (selectFileInputRadioButton.isSelected()) {
                    AcademiaPanel.this.searchBox.setEnabled(false);
                    AcademiaPanel.this.buildPubMedQueryPanel.setVisible(false);
                    AcademiaPanel.this.bottomPanel.setVisible(true);
                    AcademiaPanel.this.bottomPanel.repaint();
                }
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.selectPubMedSearchRadioButton);
        buttonGroup.add(this.selectFileInputRadioButton);
        JPanel pubmedOptionPanel = new JPanel();
        pubmedOptionPanel.setLayout(new BoxLayout(pubmedOptionPanel, 0));
        pubmedOptionPanel.add(this.selectPubMedSearchRadioButton);
        this.pubMedSearchLabel = this.createPubMedSearchLabel();
        pubmedOptionPanel.add(this.pubMedSearchLabel);
        pubmedOptionPanel.add(Box.createHorizontalStrut(5));
        this.searchBox = this.createSearchBox();
        pubmedOptionPanel.add(this.searchBox);
        pubmedOptionPanel.add(Box.createHorizontalStrut(5));
        JPanel fileInputOptionPanel = new JPanel(new GridLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = -1;
        gbc.anchor = 17;
        fileInputOptionPanel.add((Component)this.selectFileInputRadioButton, gbc);
        fileInputOptionPanel.add(Box.createHorizontalStrut(5), "Center");
        selectionPanel.add(pubmedOptionPanel);
        selectionPanel.add(fileInputOptionPanel);
        return selectionPanel;
    }

    private boolean isValidInput(String input) {
        Pattern pattern = Pattern.compile("[!@#$%^&*~]+?");
        Matcher matcher = pattern.matcher(input);
        return !matcher.find();
    }

    private JTextField createSearchBox() {
        JTextField searchBox = new JTextField();
        searchBox.setEditable(true);
        searchBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (AcademiaPanel.this.selectPubMedSearchRadioButton.isSelected()) {
                    if (AcademiaPanel.this.searchBox.getText().trim().isEmpty()) {
                        CytoscapeUtilities.notifyUser("Please enter a search term into the search box");
                    } else if (!AcademiaPanel.this.isValidInput(AcademiaPanel.this.searchBox.getText().trim())) {
                        CytoscapeUtilities.notifyUser("Illegal characters present. Please enter a valid search term.");
                    } else {
                        UserPanel.createNetwork(AcademiaPanel.this.appManager, true, AcademiaPanel.this.getThresholdTextAreaRef().getText().trim(), AcademiaPanel.this.searchBox.getText().trim(), 1249763952);
                    }
                }
            }
        });
        return searchBox;
    }

    public JPanel createAcademiaInfoPanel() {
        JPanel academiaInfoPanel = new JPanel();
        academiaInfoPanel.setName("Academia");
        academiaInfoPanel.setLayout(new BoxLayout(academiaInfoPanel, 1));
        academiaInfoPanel.add(Box.createVerticalStrut(5));
        academiaInfoPanel.add(this.createSelectionPanel());
        this.bottomPanel = new JPanel();
        this.bottomPanel.setVisible(false);
        this.bottomPanel.setLayout(new BoxLayout(this.bottomPanel, 1));
        this.bottomPanel.add(this.createDatabaseInfoPanel());
        this.bottomPanel.add(this.createSpecifyNetworkNamePanel());
        academiaInfoPanel.add(this.bottomPanel);
        academiaInfoPanel.add((Component)this.createAdvancedOptionsPanel());
        JPanel buttonWrapper = new JPanel();
        buttonWrapper.add((Component)this.createNetworkButton(), "Center");
        academiaInfoPanel.add(buttonWrapper);
        this.setAcademiaInfoPanelRef(academiaInfoPanel);
        return academiaInfoPanel;
    }

    private BasicCollapsiblePanel createAdvancedOptionsPanel() {
        BasicCollapsiblePanel advancedOptionsPanel = new BasicCollapsiblePanel("Advanced Options");
        advancedOptionsPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 250));
        advancedOptionsPanel.setCollapsed(false);
        this.buildPubMedQueryPanel = new JPanel();
        this.buildPubMedQueryPanel.setLayout(new BoxLayout(this.buildPubMedQueryPanel, 0));
        this.buildPubMedQueryPanel.setBorder(BorderFactory.createTitledBorder("Build PubMed Query"));
        this.buildPubMedQueryTextField = new JTextField();
        JButton buildPubMedQueryButton = new JButton("...");
        buildPubMedQueryButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileChooserFilter filter1 = new FileChooserFilter("text file", "txt");
                FileChooserFilter filter2 = new FileChooserFilter("text file", "TXT");
                HashSet<FileChooserFilter> filters = new HashSet<FileChooserFilter>();
                filters.add(filter1);
                filters.add(filter2);
                File inputFile = AcademiaPanel.this.fileUtil.getFile((Component)AcademiaPanel.this.appManager.getCySwingApp().getJFrame(), "Data File Selection", 0, filters);
                if (inputFile == null) {
                    return;
                }
                try {
                    logger.log(Level.INFO, String.format("Creating PubMed query from %s", inputFile.getAbsolutePath()));
                    Scanner scan = new Scanner(inputFile);
                    String author = null;
                    ArrayList<String> authorList = new ArrayList<String>();
                    while (scan.hasNextLine()) {
                        author = scan.nextLine();
                        authorList.add(author);
                    }
                    StringBuffer query = new StringBuffer();
                    String author1 = null;
                    String author2 = null;
                    for (int i = 0; i < authorList.size(); ++i) {
                        author1 = (String)authorList.get(i);
                        for (int j = i + 1; j < authorList.size(); ++j) {
                            author2 = (String)authorList.get(j);
                            query.append('(').append(author1).append("[au]").append(" OR ").append(author2).append("[au]").append(')');
                            if (j >= authorList.size() - 1) continue;
                            query.append(" AND ");
                        }
                        if (i >= authorList.size() - 2) continue;
                        query.append(" AND ");
                    }
                    AcademiaPanel.this.buildPubMedQueryTextField.setText(query.toString());
                    AcademiaPanel.this.searchBox.setText(query.toString());
                }
                catch (FileNotFoundException e1) {
                    logger.log(Level.SEVERE, e1.getMessage());
                }
                catch (IOException e1) {
                    logger.log(Level.SEVERE, e1.getMessage());
                }
            }
        });
        this.buildPubMedQueryPanel.add(this.buildPubMedQueryTextField);
        this.buildPubMedQueryPanel.add(buildPubMedQueryButton);
        advancedOptionsPanel.add((Component)this.buildPubMedQueryPanel);
        advancedOptionsPanel.add((Component)this.createSpecifyMaxAuthorThresholdPanel(), (Object)"North");
        advancedOptionsPanel.add((Component)this.createSpecifyTimeIntervalPanel(), (Object)"South");
        return advancedOptionsPanel;
    }

    private JPanel createDatabaseInfoPanel() {
        JPanel databaseInfoPanel = new JPanel();
        databaseInfoPanel.setLayout(new BoxLayout(databaseInfoPanel, 1));
        databaseInfoPanel.add(this.createDatabasePanel());
        return databaseInfoPanel;
    }

    private JPanel createDatabasePanel() {
        JPanel databasePanel = new JPanel();
        databasePanel.setBorder(BorderFactory.createTitledBorder("Select Type"));
        databasePanel.setLayout(new BoxLayout(databasePanel, 1));
        this.incitesRadioButtonRef = new JRadioButton("InCites", true);
        this.incitesRadioButtonRef.setFocusable(true);
        this.pubmedRadioButtonRef = new JRadioButton("PubMed", false);
        this.pubmedRadioButtonRef.setFocusable(true);
        this.scopusRadioButtonRef = new JRadioButton("Scopus", false);
        this.scopusRadioButtonRef.setFocusable(false);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.incitesRadioButtonRef);
        buttonGroup.add(this.pubmedRadioButtonRef);
        buttonGroup.add(this.scopusRadioButtonRef);
        JPanel typePanel = new JPanel();
        typePanel.setLayout(new BoxLayout(typePanel, 0));
        typePanel.add(this.incitesRadioButtonRef);
        typePanel.add(this.pubmedRadioButtonRef);
        typePanel.add(this.scopusRadioButtonRef);
        databasePanel.add(typePanel);
        databasePanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 100));
        JPanel loadDataPanel = new JPanel();
        loadDataPanel.setLayout(new BoxLayout(loadDataPanel, 0));
        JTextField loadTextField = new JTextField();
        loadTextField.setMaximumSize(new Dimension(Integer.MAX_VALUE, loadTextField.getPreferredSize().height));
        this.setLoadTextField(loadTextField);
        this.getPathTextFieldRef().setEditable(true);
        loadDataPanel.add(this.getPathTextFieldRef());
        loadDataPanel.add(this.createLoadButton());
        databasePanel.add(loadDataPanel);
        return databasePanel;
    }

    private JButton createLoadButton() {
        JButton loadButton = new JButton("...");
        loadButton.setToolTipText("Load InCites / Scopus data");
        loadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                FileChooserFilter filter1 = new FileChooserFilter("text file", "txt");
                FileChooserFilter filter2 = new FileChooserFilter("excel spreadsheet(xls)", "xls");
                FileChooserFilter filter3 = new FileChooserFilter("excel spreadsheet(xlsx)", "xlsx");
                FileChooserFilter filter4 = new FileChooserFilter("excel spreadsheet(csv)", "csv");
                FileChooserFilter filter5 = new FileChooserFilter("pubmed report(xml)", "xml");
                HashSet<FileChooserFilter> filters = new HashSet<FileChooserFilter>();
                filters.add(filter1);
                filters.add(filter2);
                filters.add(filter3);
                filters.add(filter4);
                filters.add(filter5);
                File textFile = AcademiaPanel.this.fileUtil.getFile((Component)AcademiaPanel.this.cySwingAppRef.getJFrame(), "Data File Selection", 0, filters);
                AcademiaPanel.this.setDataFile(textFile);
                AcademiaPanel.this.getPathTextFieldRef().setText(textFile.getAbsolutePath());
                AcademiaPanel.this.getFacultyTextFieldRef().setText(AcademiaPanel.this.parseFileName(textFile.getAbsolutePath()));
            }
        });
        return loadButton;
    }

    private JPanel createLoadDataPanel() {
        JPanel loadDataPanel = new JPanel();
        loadDataPanel.setLayout(new BoxLayout(loadDataPanel, 0));
        JTextField loadTextField = new JTextField();
        loadTextField.setMaximumSize(new Dimension(Integer.MAX_VALUE, loadTextField.getPreferredSize().height));
        this.setLoadTextField(loadTextField);
        this.getPathTextFieldRef().setEditable(true);
        loadDataPanel.add(this.getPathTextFieldRef());
        loadDataPanel.add(this.createLoadButton());
        return loadDataPanel;
    }

    private JButton createNetworkButton() {
        JButton createNetworkButton = new JButton("Create Network");
        createNetworkButton.setToolTipText("Create network");
        createNetworkButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (AcademiaPanel.this.selectPubMedSearchRadioButton.isSelected()) {
                    if (AcademiaPanel.this.searchBox.getText().trim().isEmpty()) {
                        CytoscapeUtilities.notifyUser("Please enter a search term into the search box");
                    } else if (!AcademiaPanel.this.isValidInput(AcademiaPanel.this.searchBox.getText().trim())) {
                        CytoscapeUtilities.notifyUser("Illegal characters present. Please enter a valid search term.");
                    } else {
                        UserPanel.createNetwork(AcademiaPanel.this.appManager, true, AcademiaPanel.this.getThresholdTextAreaRef().getText().trim(), AcademiaPanel.this.searchBox.getText().trim(), 1249763952);
                    }
                } else {
                    if (AcademiaPanel.this.incitesRadioButtonRef.isSelected()) {
                        AcademiaPanel.this.appManager.setAnalysis_type(1410511959);
                    }
                    if (AcademiaPanel.this.pubmedRadioButtonRef.isSelected()) {
                        AcademiaPanel.this.appManager.setAnalysis_type(-2113004178);
                    }
                    if (AcademiaPanel.this.scopusRadioButtonRef.isSelected()) {
                        AcademiaPanel.this.appManager.setAnalysis_type(-960949447);
                    }
                    if (AcademiaPanel.this.getSelectedFileRef() == null || AcademiaPanel.this.getFacultyTextFieldRef().getText() == null) {
                        CytoscapeUtilities.notifyUser("Please select a file and/or specify network name.");
                    } else if (!AcademiaPanel.this.getSelectedFileRef().getAbsolutePath().trim().equalsIgnoreCase(AcademiaPanel.this.getPathTextFieldRef().getText().trim())) {
                        CytoscapeUtilities.notifyUser("Please select a file.");
                    } else if (AcademiaPanel.this.getFacultyTextFieldRef().getText().trim().isEmpty()) {
                        CytoscapeUtilities.notifyUser("Please specify network name.");
                    } else {
                        try {
                            int maxAuthorThreshold = UserPanel.getValidThreshold(true, AcademiaPanel.this.getThresholdTextAreaRef().getText());
                            AcademiaPanel.this.appManager.createNetwork(AcademiaPanel.this.getSelectedFileRef(), maxAuthorThreshold);
                        }
                        catch (FileNotFoundException e) {
                            CytoscapeUtilities.notifyUser(AcademiaPanel.this.getPathTextFieldRef().getText() + " does not exist");
                        }
                    }
                }
            }
        });
        return createNetworkButton;
    }

    private JPanel createSpecifyNetworkNamePanel() {
        JPanel specifyNetworkNamePanel = new JPanel();
        specifyNetworkNamePanel.setBorder(BorderFactory.createTitledBorder("Specify Network Name"));
        specifyNetworkNamePanel.setLayout(new BoxLayout(specifyNetworkNamePanel, 0));
        JTextField facultyTextField = new JTextField();
        facultyTextField.setMaximumSize(new Dimension(Integer.MAX_VALUE, facultyTextField.getPreferredSize().height));
        this.setFacultyTextFieldRef(facultyTextField);
        this.getFacultyTextFieldRef().setEditable(true);
        specifyNetworkNamePanel.add(this.getFacultyTextFieldRef());
        return specifyNetworkNamePanel;
    }

    private JPanel createSpecifyMaxAuthorThresholdPanel() {
        JPanel thresholdPanel = new JPanel();
        thresholdPanel.setBorder(BorderFactory.createTitledBorder("Specify Max Author Per Pub"));
        thresholdPanel.setLayout(new BoxLayout(thresholdPanel, 0));
        this.thresholdRadioButtonRef = new JRadioButton("Set max authors per pub");
        this.thresholdRadioButtonRef.setEnabled(true);
        this.thresholdRadioButtonRef.setToolTipText("Set the maximum # of authors to be considered per publication. Publications that exceed the threshold will be excluded.");
        this.thresholdRadioButtonRef.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 || e.getStateChange() == 2) {
                    // empty if block
                }
            }
        });
        thresholdPanel.add(Box.createHorizontalStrut(5));
        thresholdPanel.add(this.getThresholdTextAreaRef());
        return thresholdPanel;
    }

    private JPanel createSpecifyTimeIntervalPanel() {
        BasicCollapsiblePanel specifyTimeIntervalPanel = new BasicCollapsiblePanel("Time Interval");
        specifyTimeIntervalPanel.setCollapsed(false);
        specifyTimeIntervalPanel.add((Component)this.getStartDatePanel(), (Object)"North");
        specifyTimeIntervalPanel.add((Component)this.getEndDatePanel(), (Object)"South");
        return specifyTimeIntervalPanel;
    }

    private JPanel getStartDatePanel() {
        JPanel startDatePanel = new JPanel();
        startDatePanel.setLayout(new BoxLayout(startDatePanel, 0));
        startDatePanel.add(Box.createHorizontalStrut(5));
        startDatePanel.add(new JLabel("Start Date"));
        startDatePanel.add(Box.createHorizontalStrut(5));
        startDatePanel.add(SocialNetworkAppManager.getStartDateTextFieldRef());
        return startDatePanel;
    }

    private JPanel getEndDatePanel() {
        JPanel endDatePanel = new JPanel();
        endDatePanel.setLayout(new BoxLayout(endDatePanel, 0));
        endDatePanel.add(Box.createHorizontalStrut(5));
        endDatePanel.add(new JLabel("End Date"));
        endDatePanel.add(Box.createHorizontalStrut(5));
        endDatePanel.add(SocialNetworkAppManager.getEndDateTextFieldRef());
        return endDatePanel;
    }

    public JPanel getAcademiaInfoPanelRef() {
        return this.academiaInfoPanelRef;
    }

    public JTextField getFacultyTextFieldRef() {
        return this.facultyTextFieldRef;
    }

    private JTextField getPathTextFieldRef() {
        return this.pathTextFieldRef;
    }

    private File getSelectedFileRef() {
        return this.selectedFileRef;
    }

    public JTextField getThresholdTextAreaRef() {
        if (this.thresholdTextFieldRef == null) {
            JTextField thresholdTextField = new JTextField("500");
            thresholdTextField.setMaximumSize(new Dimension(Integer.MAX_VALUE, thresholdTextField.getPreferredSize().height));
            this.setThresholdTextAreaRef(thresholdTextField);
        }
        return this.thresholdTextFieldRef;
    }

    private String parseFileName(String path) {
        Pattern pattern = Pattern.compile("([^\\\\/]+?)(\\.xlsx|\\.txt|\\.csv||\\.xml)$");
        Matcher matcher = pattern.matcher(path);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "N/A";
    }

    public void setAcademiaInfoPanelRef(JPanel academiaInfoPanelRef) {
        this.academiaInfoPanelRef = academiaInfoPanelRef;
    }

    private void setDataFile(File selectedFile) {
        this.selectedFileRef = selectedFile;
    }

    private void setFacultyTextFieldRef(JTextField facultyTextField) {
        this.facultyTextFieldRef = facultyTextField;
    }

    private void setLoadTextField(JTextField pathTextField) {
        this.pathTextFieldRef = pathTextField;
    }

    private void setThresholdTextAreaRef(JTextField thresholdTextFieldRef) {
        this.thresholdTextFieldRef = thresholdTextFieldRef;
    }

    public boolean thresholdIsSelected() {
        if (this.thresholdRadioButtonRef == null) {
            return false;
        }
        return this.thresholdRadioButtonRef.isSelected();
    }
}

