/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csapps.socialnetwork.tasks;

import java.awt.Cursor;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.baderlab.csapps.socialnetwork.CytoscapeUtilities;
import org.baderlab.csapps.socialnetwork.model.AbstractEdge;
import org.baderlab.csapps.socialnetwork.model.AbstractNode;
import org.baderlab.csapps.socialnetwork.model.Collaboration;
import org.baderlab.csapps.socialnetwork.model.SocialNetwork;
import org.baderlab.csapps.socialnetwork.model.SocialNetworkAppManager;
import org.baderlab.csapps.socialnetwork.model.academia.visualstyles.EdgeAttribute;
import org.baderlab.csapps.socialnetwork.model.academia.visualstyles.NetworkAttribute;
import org.baderlab.csapps.socialnetwork.model.academia.visualstyles.NodeAttribute;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkFactory;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTable;
import org.cytoscape.session.CyNetworkNaming;
import org.cytoscape.view.layout.CyLayoutAlgorithm;
import org.cytoscape.view.layout.CyLayoutAlgorithmManager;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewFactory;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateNetworkTask
extends AbstractTask {
    private int currentSteps = 0;
    private CyLayoutAlgorithmManager cyLayoutManagerServiceRef;
    private CyNetworkFactory cyNetworkFactoryServiceRef;
    private CyNetworkManager cyNetworkManagerServiceRef;
    private CyNetworkNaming cyNetworkNamingServiceRef;
    private CyNetworkViewFactory cyNetworkViewFactoryServiceRef;
    private CyNetworkViewManager cyNetworkViewManagerServiceRef;
    private SocialNetworkAppManager appManager;
    private double progress = 0.0;
    private int totalSteps = 0;

    public CreateNetworkTask(CyNetworkNaming cyNetworkNamingServiceRef, CyNetworkFactory cyNetworkFactoryServiceRef, CyNetworkManager cyNetworkManagerServiceRef, CyNetworkViewFactory cyNetworkViewFactoryServiceRef, CyNetworkViewManager cyNetworkViewManagerServiceRef, CyLayoutAlgorithmManager cyLayoutManagerServiceRef, SocialNetworkAppManager appManager) {
        this.cyNetworkNamingServiceRef = cyNetworkNamingServiceRef;
        this.cyNetworkFactoryServiceRef = cyNetworkFactoryServiceRef;
        this.cyNetworkManagerServiceRef = cyNetworkManagerServiceRef;
        this.cyNetworkViewFactoryServiceRef = cyNetworkViewFactoryServiceRef;
        this.cyNetworkViewManagerServiceRef = cyNetworkViewManagerServiceRef;
        this.cyLayoutManagerServiceRef = cyLayoutManagerServiceRef;
        this.appManager = appManager;
    }

    public CyNetwork loadNetwork(Map<Collaboration, ArrayList<AbstractEdge>> map, TaskMonitor taskMonitor) {
        try {
            CyNetwork myNet = this.cyNetworkFactoryServiceRef.createNetwork();
            CyTable nodeTable = null;
            CyTable edgeTable = null;
            CyTable networkTable = null;
            nodeTable = myNet.getDefaultNodeTable();
            Object[] keys = map.keySet().toArray();
            AbstractNode key = ((Collaboration)keys[0]).getNode1();
            for (Map.Entry<String, Object> attr : key.getNodeAttrMap().entrySet()) {
                String attrName = attr.getKey();
                Iterator<Map.Entry<String, Object>> attrType = attr.getValue();
                if (attrType instanceof String) {
                    nodeTable.createColumn(attrName, String.class, false);
                    continue;
                }
                if (attrType instanceof Integer) {
                    nodeTable.createColumn(attrName, Integer.class, false);
                    continue;
                }
                if (attrType instanceof Double) {
                    nodeTable.createColumn(attrName, Double.class, false);
                    continue;
                }
                if (attrType instanceof Boolean) {
                    nodeTable.createColumn(attrName, Boolean.class, false);
                    continue;
                }
                if (!(attrType instanceof List)) continue;
                if (attrName.equals(NodeAttribute.PUBS_PER_YEAR.toString()) || attrName.equals(NodeAttribute.YEARS_ACTIVE.toString()) || attrName.equals(NodeAttribute.CITATIONS_PER_YEAR.toString())) {
                    nodeTable.createListColumn(attrName, Integer.class, false);
                    continue;
                }
                nodeTable.createListColumn(attrName, String.class, false);
            }
            edgeTable = myNet.getDefaultEdgeTable();
            Object[] values = map.values().toArray();
            ArrayList values2 = (ArrayList)values[0];
            AbstractEdge value = (AbstractEdge)values2.get(0);
            for (Map.Entry<String, Object> attr : value.getEdgeAttrMap().entrySet()) {
                String attrName = attr.getKey();
                Object attrType = attr.getValue();
                if (attrType instanceof String) {
                    edgeTable.createColumn(attrName, String.class, false);
                    continue;
                }
                if (attrType instanceof Integer) {
                    edgeTable.createColumn(attrName, Integer.class, false);
                    continue;
                }
                if (attrType instanceof Double) {
                    nodeTable.createColumn(attrName, Double.class, false);
                    continue;
                }
                if (attrType instanceof Boolean) {
                    edgeTable.createColumn(attrName, Boolean.class, false);
                    continue;
                }
                if (!(attrType instanceof List)) continue;
                if (attrName.equals(EdgeAttribute.PUBS_PER_YEAR.toString())) {
                    edgeTable.createListColumn(attrName, Integer.class, false);
                    continue;
                }
                edgeTable.createListColumn(attrName, String.class, false);
            }
            networkTable = myNet.getDefaultNetworkTable();
            networkTable.createColumn(NetworkAttribute.TOTAL_PUBLICATIONS.toString(), Integer.class, false);
            networkTable.createColumn(NetworkAttribute.TOTAL_FACULTY.toString(), Integer.class, false);
            networkTable.createColumn(NetworkAttribute.TOTAL_UNIDENTIFIED_FACULTY.toString(), Integer.class, false);
            networkTable.createColumn(NetworkAttribute.UNIDENTIFIED_FACULTY_LIST.toString(), String.class, false);
            myNet.getDefaultNetworkTable().getRow((Object)myNet.getSUID()).set("name", (Object)this.cyNetworkNamingServiceRef.getSuggestedNetworkTitle(this.appManager.getNetworkName()));
            myNet.getDefaultNetworkTable().getRow((Object)myNet.getSUID()).set(NetworkAttribute.TOTAL_PUBLICATIONS.toString(), (Object)this.appManager.getSocialNetwork(this.appManager.getNetworkName()).getNum_publications());
            myNet.getDefaultNetworkTable().getRow((Object)myNet.getSUID()).set(NetworkAttribute.TOTAL_FACULTY.toString(), (Object)this.appManager.getSocialNetwork(this.appManager.getNetworkName()).getNum_faculty());
            myNet.getDefaultNetworkTable().getRow((Object)myNet.getSUID()).set(NetworkAttribute.TOTAL_UNIDENTIFIED_FACULTY.toString(), (Object)this.appManager.getSocialNetwork(this.appManager.getNetworkName()).getNum_uniden_faculty());
            myNet.getDefaultNetworkTable().getRow((Object)myNet.getSUID()).set(NetworkAttribute.TOTAL_PUBLICATIONS.toString(), (Object)this.appManager.getSocialNetwork(this.appManager.getNetworkName()).getNum_publications());
            Collaboration collaboration = null;
            AbstractNode node1 = null;
            AbstractNode node2 = null;
            List edgeArray = null;
            CyEdge edgeRef = null;
            CyNode nodeRef = null;
            HashMap<AbstractNode, CyNode> nodeMap = new HashMap<AbstractNode, CyNode>();
            this.setProgressMonitor(taskMonitor, "Loading Network View ...", map.size());
            for (Map.Entry<Collaboration, ArrayList<AbstractEdge>> entry : map.entrySet()) {
                collaboration = entry.getKey();
                edgeArray = entry.getValue();
                node1 = collaboration.getNode1();
                node2 = collaboration.getNode2();
                if (!nodeMap.containsKey(node1)) {
                    nodeRef = myNet.addNode();
                    node1.setCyNode(nodeRef);
                    for (Map.Entry entry2 : node1.getNodeAttrMap().entrySet()) {
                        nodeTable.getRow((Object)nodeRef.getSUID()).set((String)entry2.getKey(), entry2.getValue());
                    }
                    nodeTable.getRow((Object)nodeRef.getSUID()).set("name", (Object)node1.getLabel());
                    nodeTable.getRow((Object)nodeRef.getSUID()).set("shared name", (Object)node1.getLabel());
                    nodeMap.put(node1, nodeRef);
                }
                if (!nodeMap.containsKey(node2)) {
                    nodeRef = myNet.addNode();
                    node2.setCyNode(nodeRef);
                    for (Map.Entry entry3 : node2.getNodeAttrMap().entrySet()) {
                        nodeTable.getRow((Object)nodeRef.getSUID()).set((String)entry3.getKey(), entry3.getValue());
                    }
                    nodeTable.getRow((Object)nodeRef.getSUID()).set("name", (Object)node2.getLabel());
                    nodeTable.getRow((Object)nodeRef.getSUID()).set("shared name", (Object)node2.getLabel());
                    nodeMap.put(node2, nodeRef);
                }
                for (AbstractEdge abstractEdge : edgeArray) {
                    edgeRef = myNet.addEdge((CyNode)nodeMap.get(node1), (CyNode)nodeMap.get(node2), false);
                    abstractEdge.setCyEdge(edgeRef);
                    for (Map.Entry<String, Object> attr : abstractEdge.getEdgeAttrMap().entrySet()) {
                        edgeTable.getRow((Object)edgeRef.getSUID()).set(attr.getKey(), attr.getValue());
                    }
                    edgeTable.getRow((Object)edgeRef.getSUID()).set("name", (Object)(node1.getLabel() + "_" + node2.getLabel()));
                }
                this.updateProgress(taskMonitor);
            }
            return myNet;
        }
        catch (ArrayIndexOutOfBoundsException exception) {
            exception.printStackTrace();
            this.appManager.getUserPanelRef().setCursor(new Cursor(0));
            CytoscapeUtilities.notifyUser("Network could not be loaded. Array Index Out Of Bounds.");
            this.appManager.getSocialNetworkMap().remove(this.appManager.getNetworkName());
            this.appManager.setNetworkName(null);
            taskMonitor = null;
            return null;
        }
    }

    public void run(TaskMonitor monitor) throws Exception {
        CyNetworkManager networkManager = this.cyNetworkManagerServiceRef;
        CyNetworkViewManager networkViewManager = this.cyNetworkViewManagerServiceRef;
        Map<Collaboration, ArrayList<AbstractEdge>> map = this.appManager.getMap();
        if (map == null) {
            CytoscapeUtilities.notifyUser("Network could not be loaded. Cytoscape network map could not be accessed.");
        } else {
            CyNetwork network = this.loadNetwork(map, monitor);
            if (network == null) {
                return;
            }
            this.setProgressMonitor(monitor, "Loading Network ...", -1);
            networkManager.addNetwork(network);
            Collection views = networkViewManager.getNetworkViews(network);
            CyNetworkView networkView = null;
            if (views.size() != 0) {
                networkView = (CyNetworkView)views.iterator().next();
            }
            if (networkView == null) {
                networkView = this.cyNetworkViewFactoryServiceRef.createNetworkView(network);
                networkViewManager.addNetworkView(networkView);
            } else {
                CytoscapeUtilities.notifyUser("Network already present");
            }
            boolean destroyView = false;
            if (destroyView) {
                networkViewManager.destroyNetworkView(networkView);
            }
            SocialNetwork socialNetwork = this.appManager.getSocialNetworkMap().get(this.appManager.getNetworkName());
            socialNetwork.setNetworkView(networkView);
            CyLayoutAlgorithm layout = this.cyLayoutManagerServiceRef.getLayout("force-directed");
            String layoutAttribute = null;
            TaskIterator layoutTaskIterator = layout.createTaskIterator(networkView, layout.createLayoutContext(), CyLayoutAlgorithm.ALL_NODE_VIEWS, layoutAttribute);
            TaskIterator taskIterator = new TaskIterator(new Task[0]);
            taskIterator.append(layoutTaskIterator);
            int visualStyleID = socialNetwork.getDefaultVisualStyle();
            this.appManager.setVisualStyleID(visualStyleID);
            this.appManager.getUserPanelRef().setSelectedVisualStyle(visualStyleID);
            CreateNetworkTask createNetworkTask = this;
            taskIterator.append(createNetworkTask.appManager.getApplyVisualStyleTaskFactoryRef().createTaskIterator());
            this.insertTasksAfterCurrentTask(taskIterator);
        }
    }

    private void setProgressMonitor(TaskMonitor taskMonitor, String taskName, int totalSteps) {
        taskMonitor.setTitle(taskName);
        taskMonitor.setProgress(0.0);
        this.currentSteps = 0;
        this.totalSteps = totalSteps;
    }

    private String toPercent(double progress) {
        DecimalFormat df = new DecimalFormat("00");
        return df.format(progress *= 100.0) + "%";
    }

    private void updateProgress(TaskMonitor taskMonitor) {
        ++this.currentSteps;
        this.progress = (double)this.currentSteps / (double)this.totalSteps;
        taskMonitor.setStatusMessage("Complete: " + this.toPercent(this.progress));
        taskMonitor.setProgress(this.progress);
    }
}

