/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csapps.socialnetwork.tasks;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.baderlab.csapps.socialnetwork.CytoscapeUtilities;
import org.baderlab.csapps.socialnetwork.model.SocialNetworkAppManager;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;

public class ExportNthDegreeNeighborsTask
extends AbstractTask {
    private static final Logger logger = Logger.getLogger(ExportNthDegreeNeighborsTask.class.getName());
    private SocialNetworkAppManager appManager = null;
    private TaskMonitor taskMonitor = null;
    private int currentSteps = 0;
    private int totalSteps = 0;
    private double progress = 0.0;

    public ExportNthDegreeNeighborsTask(SocialNetworkAppManager appManager) {
        this.appManager = appManager;
    }

    public static String getOrdinalFor(int value) {
        int hundredRemainder = value % 100;
        int tenRemainder = value % 10;
        if (hundredRemainder - tenRemainder == 10) {
            return "th";
        }
        switch (tenRemainder) {
            case 1: {
                return "st";
            }
            case 2: {
                return "nd";
            }
            case 3: {
                return "rd";
            }
        }
        return "th";
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        this.taskMonitor = taskMonitor;
        CyNetwork cyNetwork = this.appManager.getNeighborListNetwork();
        int degree = this.appManager.getNeighborListDegree();
        String message = String.format("Exporting %d%s degree neighbors ...", degree, ExportNthDegreeNeighborsTask.getOrdinalFor(degree));
        this.setProgressMonitor(message, cyNetwork.getNodeCount());
        File selectedFolder = this.appManager.getNeighborListFolder();
        String attr = this.appManager.getNeighborListAttribute();
        this.exportNeighborsToCSV(cyNetwork, degree, selectedFolder, attr);
    }

    private void exportNeighborsToCSV(CyNetwork cyNetwork, int degree, File selectedFolder, String attr) {
        try {
            String fileName = "/neighbor_list.csv";
            String attrValue = null;
            FileWriter writer = new FileWriter(selectedFolder.getAbsolutePath() + fileName);
            writer.append("Author");
            writer.append(',');
            writer.append("Neighbors");
            writer.append('\n');
            if (!attr.equalsIgnoreCase("N/A")) {
                for (CyNode node : cyNetwork.getNodeList()) {
                    attrValue = (String)cyNetwork.getDefaultNodeTable().getRow((Object)node.getSUID()).get(attr, String.class);
                    if (attrValue == null) continue;
                    writer.append(attrValue);
                    writer.append(',');
                    this.writeNthDegreeNode(node, cyNetwork, writer, attr, degree);
                    writer.append('\n');
                    this.updateProgress();
                }
            }
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Exception occurred", e);
            CytoscapeUtilities.notifyUser("IOException. Unable to save csv file");
        }
    }

    private void writeNthDegreeNode(CyNode node, CyNetwork network, FileWriter writer, String attr, int depth) {
        if (depth == 0) {
            try {
                writer.append("(" + (String)network.getDefaultNodeTable().getRow((Object)node.getSUID()).get(attr, String.class) + ") ");
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Exception occurred", e);
                CytoscapeUtilities.notifyUser("IOException. Unable to save csv file");
            }
            return;
        }
        for (CyNode neighbour : network.getNeighborList(node, CyEdge.Type.ANY)) {
            this.writeNthDegreeNode(neighbour, network, writer, attr, depth - 1);
        }
    }

    private void setProgressMonitor(String taskName, int totalSteps) {
        this.taskMonitor.setTitle(taskName);
        this.taskMonitor.setProgress(0.0);
        this.currentSteps = 0;
        this.totalSteps = totalSteps;
    }

    private String toPercent(double progress) {
        DecimalFormat df = new DecimalFormat("00");
        return df.format(progress *= 100.0) + "%";
    }

    private void updateProgress() {
        ++this.currentSteps;
        this.progress = (double)this.currentSteps / (double)this.totalSteps;
        this.taskMonitor.setStatusMessage("Complete: " + this.toPercent(this.progress));
        this.taskMonitor.setProgress(this.progress);
    }
}

