/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csapps.socialnetwork.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.baderlab.csapps.socialnetwork.CytoscapeUtilities;
import org.baderlab.csapps.socialnetwork.PropsReader;
import org.baderlab.csapps.socialnetwork.model.academia.visualstyles.NodeAttribute;
import org.baderlab.csapps.socialnetwork.tasks.ApplyVisualStyleTaskFactory;
import org.cytoscape.application.swing.CyMenuItem;
import org.cytoscape.application.swing.CyNodeViewContextMenuFactory;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTable;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.work.TaskManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeAuthorInstitutionAction
implements CyNodeViewContextMenuFactory,
ActionListener {
    private CyNode cyNode = null;
    private CyNetwork cyNetwork = null;
    private TaskManager<?, ?> taskManager = null;
    private ApplyVisualStyleTaskFactory applyVisualStyleTaskFactoryRef = null;
    private PropsReader propsReader = null;

    public ChangeAuthorInstitutionAction(TaskManager<?, ?> taskManager, ApplyVisualStyleTaskFactory applyVisualStyleTaskFactoryRef, PropsReader propsReader) {
        this.taskManager = taskManager;
        this.applyVisualStyleTaskFactoryRef = applyVisualStyleTaskFactoryRef;
        this.propsReader = propsReader;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Long SUID = this.cyNode.getSUID();
        CyTable nodeTable = this.cyNetwork.getDefaultNodeTable();
        String authorName = (String)CytoscapeUtilities.getCyTableAttribute(nodeTable, SUID, NodeAttribute.LABEL.toString());
        List listOfInstitutions = (List)CytoscapeUtilities.getCyTableAttribute(nodeTable, SUID, NodeAttribute.INSTITUTIONS.toString());
        if (listOfInstitutions != null && listOfInstitutions.size() > 0) {
            String title = String.format("Change main institution of %s", authorName);
            String[] listOfInstitArray = new String[listOfInstitutions.size()];
            JComboBox<String> institutionComboBox = new JComboBox<String>(listOfInstitutions.toArray(listOfInstitArray));
            JPanel dialogPanel = new JPanel();
            JPanel wrapperPanel = new JPanel();
            wrapperPanel.setLayout(new BoxLayout(wrapperPanel, 0));
            wrapperPanel.add(new JLabel("Set author's main institution"));
            wrapperPanel.add(Box.createHorizontalStrut(5));
            wrapperPanel.add(institutionComboBox);
            dialogPanel.add((Component)wrapperPanel, "North");
            int outcome = 0;
            String mainInstitution = "N/A";
            while (outcome == 0) {
                outcome = JOptionPane.showConfirmDialog(null, dialogPanel, title, 2);
                if (outcome != 0) continue;
                mainInstitution = ((String)institutionComboBox.getSelectedItem()).trim();
                if (mainInstitution.isEmpty()) {
                    CytoscapeUtilities.notifyUser("Please specify both an institution and a location");
                    continue;
                }
                if (mainInstitution.equalsIgnoreCase("n/a")) continue;
                mainInstitution = mainInstitution.toUpperCase();
                CytoscapeUtilities.setCyTableAttribute(nodeTable, SUID, NodeAttribute.MAIN_INSTITUTION.toString(), mainInstitution);
                String location = (String)this.propsReader.getProperties().get(mainInstitution);
                if (location == null) {
                    location = "Other";
                }
                this.propsReader.getProperties().put(mainInstitution, location);
                CytoscapeUtilities.setCyTableAttribute(nodeTable, SUID, NodeAttribute.LOCATION.toString(), location);
                outcome = 2;
            }
            if (outcome == 0) {
                this.taskManager.execute(this.applyVisualStyleTaskFactoryRef.createTaskIterator());
            }
        } else {
            CytoscapeUtilities.notifyUser(String.format("%s is not assigned to an institution.", authorName));
        }
    }

    public CyMenuItem createMenuItem(CyNetworkView netView, View<CyNode> nodeView) {
        this.cyNetwork = (CyNetwork)netView.getModel();
        this.cyNode = (CyNode)nodeView.getModel();
        JMenuItem addInstitutionMenuItem = new JMenuItem("Set Author's Main Institution");
        addInstitutionMenuItem.addActionListener(this);
        CyMenuItem cyMenuItem = new CyMenuItem(addInstitutionMenuItem, 0.0f);
        return cyMenuItem;
    }
}

