/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csapps.socialnetwork.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.baderlab.csapps.socialnetwork.CytoscapeUtilities;
import org.baderlab.csapps.socialnetwork.model.SocialNetworkAppManager;
import org.baderlab.csapps.socialnetwork.tasks.ExportNthDegreeNeighborsTaskFactory;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.AbstractCyAction;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.work.TaskManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportNthDegreeNeighborsAction
extends AbstractCyAction {
    private CyNetworkManager cyNetworkManagerServiceRef = null;
    private CySwingApplication cySwingApplicationServiceRef = null;
    private JPanel exportNeighborsPanelRef = null;
    private JTextField neighborDegreeRef = null;
    private JComboBox<String> nodeAttrComboBoxRef = null;
    private JComboBox<String> networkNameComboBoxRef = null;
    private HashMap<String, CyNetwork> cyNetworkMap = null;
    private TaskManager<?, ?> taskManagerServiceRef = null;
    private ExportNthDegreeNeighborsTaskFactory exportNthDegreeNeighborsTaskFactoryRef = null;
    private SocialNetworkAppManager appManager = null;

    public ExportNthDegreeNeighborsAction(Map<String, String> configProps, CyApplicationManager applicationManager, CyNetworkViewManager networkViewManager, CyNetworkManager cyNetworkManagerServiceRef, CySwingApplication cySwingApplicationServiceRef, TaskManager<?, ?> taskManager, ExportNthDegreeNeighborsTaskFactory exportNthDegreeNeighborsTaskFactoryRef, SocialNetworkAppManager appManager) {
        super(configProps, applicationManager, networkViewManager);
        this.putValue("Name", "Export Neighbors");
        this.cyNetworkManagerServiceRef = cyNetworkManagerServiceRef;
        this.cySwingApplicationServiceRef = cySwingApplicationServiceRef;
        this.nodeAttrComboBoxRef = new JComboBox();
        this.cyNetworkMap = new HashMap();
        this.networkNameComboBoxRef = this.createNetworkNameComboBoxRef();
        this.taskManagerServiceRef = taskManager;
        this.exportNthDegreeNeighborsTaskFactoryRef = exportNthDegreeNeighborsTaskFactoryRef;
        this.appManager = appManager;
    }

    public void actionPerformed(ActionEvent e) {
        int outcome = 0;
        while (outcome == 0) {
            this.updateNetworkNameComboBoxRef();
            outcome = JOptionPane.showConfirmDialog(null, this.getExportNeighborsPanelRef(), "Export neighbor list options", 2);
            if (outcome != 0) continue;
            String networkName = (String)this.networkNameComboBoxRef.getSelectedItem();
            CyNetwork network = this.cyNetworkMap.get(networkName);
            if (network == null) {
                CytoscapeUtilities.notifyUser("Unable to export. No network is available");
                return;
            }
            String text = this.neighborDegreeRef.getText().trim();
            if (!Pattern.matches("[0-9]+", text)) {
                CytoscapeUtilities.notifyUser("Invalid input. Please enter an integer value.");
                continue;
            }
            int degree = Integer.parseInt(text);
            if (degree == 0) {
                return;
            }
            JFileChooser fc = new JFileChooser();
            fc.setFileSelectionMode(1);
            fc.setDialogTitle("Select a folder");
            fc.setApproveButtonText("Select");
            if (fc.showOpenDialog(this.cySwingApplicationServiceRef.getJFrame()) == 0) {
                this.appManager.setNeighborListDegree(degree);
                this.appManager.setNeighborListNetwork(network);
                this.appManager.setNeighborListFolder(fc.getSelectedFile());
                this.appManager.setNeighborListAttribute((String)this.nodeAttrComboBoxRef.getSelectedItem());
                this.getTaskManager().execute(this.exportNthDegreeNeighborsTaskFactoryRef.createTaskIterator());
            }
            outcome = 2;
        }
    }

    private JPanel createExportNeighborsPanel() {
        JPanel exportNeighborsPanel = new JPanel();
        exportNeighborsPanel.setLayout(new BoxLayout(exportNeighborsPanel, 1));
        JPanel networkNamePanel = new JPanel();
        networkNamePanel.setLayout(new BoxLayout(networkNamePanel, 0));
        networkNamePanel.add(new JLabel("Select network: "));
        networkNamePanel.add(this.networkNameComboBoxRef);
        this.updateNetworkNameComboBoxRef();
        JPanel degreeInputPanel = new JPanel();
        degreeInputPanel.setLayout(new BoxLayout(degreeInputPanel, 0));
        this.neighborDegreeRef = new JTextField(5);
        this.neighborDegreeRef.setText("1");
        degreeInputPanel.add(new JLabel("Please specify the degree: "));
        degreeInputPanel.add(this.neighborDegreeRef);
        JPanel nodeAttrPanel = new JPanel();
        nodeAttrPanel.setLayout(new BoxLayout(nodeAttrPanel, 0));
        nodeAttrPanel.add(new JLabel("Select node attribute: "));
        this.updateNodeAttrComboBoxRef();
        nodeAttrPanel.add(this.nodeAttrComboBoxRef);
        exportNeighborsPanel.add(networkNamePanel);
        exportNeighborsPanel.add(nodeAttrPanel);
        exportNeighborsPanel.add(degreeInputPanel);
        return exportNeighborsPanel;
    }

    private JComboBox<String> createNetworkNameComboBoxRef() {
        JComboBox<String> comboBox = new JComboBox<String>();
        comboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ExportNthDegreeNeighborsAction.this.updateNodeAttrComboBoxRef();
            }
        });
        return comboBox;
    }

    private JPanel getExportNeighborsPanelRef() {
        if (this.exportNeighborsPanelRef == null) {
            this.setExportNeighborsPanelRef(this.createExportNeighborsPanel());
        }
        return this.exportNeighborsPanelRef;
    }

    private void setExportNeighborsPanelRef(JPanel exportNeighborsPanelRef) {
        this.exportNeighborsPanelRef = exportNeighborsPanelRef;
    }

    private void updateNetworkNameComboBoxRef() {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        Set networkSet = this.cyNetworkManagerServiceRef.getNetworkSet();
        String networkName = null;
        this.cyNetworkMap.clear();
        if (networkSet.isEmpty()) {
            networkName = "N/A";
            model.addElement(networkName);
        } else {
            Iterator it = networkSet.iterator();
            CyNetwork cyNetwork = null;
            while (it.hasNext()) {
                cyNetwork = (CyNetwork)it.next();
                networkName = SocialNetworkAppManager.getNetworkName(cyNetwork);
                model.addElement(networkName);
                this.cyNetworkMap.put(networkName, cyNetwork);
            }
        }
        this.networkNameComboBoxRef.setModel(model);
        this.networkNameComboBoxRef.setSelectedItem(networkName);
    }

    private void updateNodeAttrComboBoxRef() {
        String selectedItem = (String)this.networkNameComboBoxRef.getSelectedItem();
        CyNetwork cyNetwork = this.cyNetworkMap.get(selectedItem);
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        if (cyNetwork == null) {
            model.addElement("N/A");
        } else {
            for (CyColumn col : cyNetwork.getDefaultNodeTable().getColumns()) {
                if (col.getType() != String.class) continue;
                model.addElement(col.getName());
            }
        }
        this.nodeAttrComboBoxRef.setModel(model);
    }

    public TaskManager<?, ?> getTaskManager() {
        return this.taskManagerServiceRef;
    }

    public void setTaskManager(TaskManager<?, ?> taskManager) {
        this.taskManagerServiceRef = taskManager;
    }
}

