/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csapps.socialnetwork.listeners;

import java.util.Iterator;
import java.util.Map;
import javax.swing.table.DefaultTableModel;
import org.baderlab.csapps.socialnetwork.model.SocialNetwork;
import org.baderlab.csapps.socialnetwork.model.SocialNetworkAppManager;
import org.baderlab.csapps.socialnetwork.panels.UserPanel;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.events.RowsSetEvent;
import org.cytoscape.model.events.RowsSetListener;

public class SocialNetworkNameChangedListener
implements RowsSetListener {
    private SocialNetworkAppManager appManager = null;
    private CyNetworkManager cyNetworkManagerServiceRef = null;
    private UserPanel userPanel = null;

    public SocialNetworkNameChangedListener(SocialNetworkAppManager appManager, CyNetworkManager cyNetworkManagerServiceRef) {
        this.appManager = appManager;
        this.userPanel = appManager.getUserPanelRef();
        this.cyNetworkManagerServiceRef = cyNetworkManagerServiceRef;
    }

    private int getRow(DefaultTableModel model, String name) {
        for (int row = 0; row < model.getRowCount(); ++row) {
            if (!((String)model.getValueAt(row, 0)).equalsIgnoreCase(name)) continue;
            return row;
        }
        return -1;
    }

    public void handleEvent(RowsSetEvent rowsSetEvent) {
        if (!rowsSetEvent.containsColumn("name")) {
            return;
        }
        CyRow row = (CyRow)((CyTable)rowsSetEvent.getSource()).getAllRows().get(0);
        String updatedName = (String)row.getAllValues().get("name");
        Long s = null;
        Long suid = (Long)row.getAllValues().get("SUID");
        SocialNetwork network = null;
        CyNetwork cyNetwork = null;
        Iterator<Map.Entry<String, SocialNetwork>> it = this.appManager.getSocialNetworkMap().entrySet().iterator();
        Map.Entry<String, SocialNetwork> pair = null;
        while (it.hasNext()) {
            pair = it.next();
            network = pair.getValue();
            cyNetwork = network.getCyNetwork();
            if (cyNetwork == null || !suid.equals(s = cyNetwork.getSUID())) continue;
            String oldName = network.getNetworkName();
            network.setNetworkName(updatedName);
            this.appManager.getSocialNetworkMap().remove(pair.getKey());
            this.appManager.getSocialNetworkMap().put(updatedName, network);
            DefaultTableModel model = (DefaultTableModel)this.userPanel.getNetworkTableRef().getModel();
            int rowIndex = this.getRow(model, oldName);
            if (rowIndex <= -1) continue;
            model.setValueAt(updatedName, rowIndex, 0);
        }
    }
}

