/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csapps.socialnetwork.model.academia;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Pattern;
import org.baderlab.csapps.socialnetwork.model.SocialNetworkAppManager;
import org.baderlab.csapps.socialnetwork.model.academia.Publication;
import org.baderlab.csapps.socialnetwork.model.academia.visualstyles.NodeAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PubMed {
    private ArrayList<Publication> pubList = null;
    private String queryTranslation = "";

    public static HashMap<String, Object> constructPubMedAttrMap() {
        HashMap<String, Object> nodeAttrMap = new HashMap<String, Object>();
        nodeAttrMap.put(NodeAttribute.LABEL.toString(), "N/A");
        nodeAttrMap.put(NodeAttribute.FIRST_NAME.toString(), "N/A");
        nodeAttrMap.put(NodeAttribute.LAST_NAME.toString(), "N/A");
        nodeAttrMap.put(NodeAttribute.MAIN_INSTITUTION.toString(), "N/A");
        nodeAttrMap.put(NodeAttribute.TIMES_CITED.toString(), 0);
        nodeAttrMap.put(NodeAttribute.PUBLICATION_COUNT.toString(), 0);
        nodeAttrMap.put(NodeAttribute.PUBLICATIONS.toString(), new ArrayList());
        nodeAttrMap.put(NodeAttribute.INSTITUTIONS.toString(), new ArrayList());
        ArrayList<Integer> pubsPerYearList = new ArrayList<Integer>();
        pubsPerYearList.add(0);
        nodeAttrMap.put(NodeAttribute.PUBS_PER_YEAR.toString(), pubsPerYearList);
        String startYearTxt = SocialNetworkAppManager.getStartDateTextFieldRef().getText().trim();
        String endYearTxt = SocialNetworkAppManager.getEndDateTextFieldRef().getText().trim();
        if (Pattern.matches("[0-9]+", startYearTxt) && Pattern.matches("[0-9]+", endYearTxt)) {
            int startYear = Integer.parseInt(startYearTxt);
            int endYear = Integer.parseInt(endYearTxt);
            ArrayList<Integer> years = new ArrayList<Integer>();
            for (int i = startYear; i <= endYear; ++i) {
                years.add(i);
            }
            nodeAttrMap.put(NodeAttribute.YEARS_ACTIVE.toString(), years);
        }
        return nodeAttrMap;
    }

    public PubMed(ArrayList<Publication> pubList) {
        this.pubList = pubList;
    }

    public ArrayList<Publication> getPubList() {
        return this.pubList;
    }

    public int getTotalHits() {
        return this.pubList != null ? this.pubList.size() : 0;
    }

    public String getQueryTranslation() {
        return this.queryTranslation;
    }
}

