/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csapps.socialnetwork.model.academia.parsers.pubmed;

import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.baderlab.csapps.socialnetwork.CytoscapeUtilities;
import org.baderlab.csapps.socialnetwork.model.SocialNetwork;
import org.baderlab.csapps.socialnetwork.model.academia.Author;
import org.baderlab.csapps.socialnetwork.model.academia.Publication;
import org.baderlab.csapps.socialnetwork.model.academia.Tag;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class EutilsRetrievalParser
extends AbstractTask {
    private static final Logger logger = Logger.getLogger(EutilsRetrievalParser.class.getName());
    private int publication_counter = 0;
    private TaskMonitor taskMonitor = null;
    private Author author = null;
    private StringBuilder rawAuthorText = null;
    private StringBuilder journal = null;
    private ArrayList<Author> pubAuthorList = new ArrayList();
    private StringBuilder pubDate = null;
    private ArrayList<Publication> pubList = new ArrayList();
    private StringBuilder pmid = null;
    private StringBuilder timesCited = null;
    private StringBuilder title = null;
    private String queryKey = "";
    private String webEnv = "";
    private int retStart = 0;
    private int retMax = 0;
    private int totalPubs = 0;
    private SocialNetwork socialNetwork = null;

    public EutilsRetrievalParser(SocialNetwork socialNetwork) {
        this.rawAuthorText = new StringBuilder();
        this.journal = new StringBuilder();
        this.pubDate = new StringBuilder();
        this.pmid = new StringBuilder();
        this.timesCited = new StringBuilder();
        this.title = new StringBuilder();
        this.socialNetwork = socialNetwork;
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        try {
            taskMonitor.setStatusMessage("Retrieving records from PubMed ...");
            if (this.socialNetwork.getEutilsResults() != null) {
                this.queryKey = this.socialNetwork.getEutilsResults().getQueryKey();
                this.webEnv = this.socialNetwork.getEutilsResults().getWebEnv();
                this.retStart = this.socialNetwork.getEutilsResults().getRetStart();
                this.retMax = this.socialNetwork.getEutilsResults().getRetMax();
                this.totalPubs = this.socialNetwork.getEutilsResults().getTotalPubs();
            }
            taskMonitor.setProgress(0.0);
            SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
            EutilsParser parser = new EutilsParser();
            this.taskMonitor = taskMonitor;
            while (this.retStart < this.totalPubs) {
                Tag tag = new Tag(this.queryKey, this.webEnv, this.retStart, this.retMax);
                String url = String.format("http://eutils.ncbi.nlm.nih.gov/entrez/eutils/esummary.fcgi?db=pubmed%s", tag);
                saxParser.parse(url, (DefaultHandler)parser);
                this.retStart += this.retMax;
                taskMonitor.setProgress((double)((int)((double)this.retStart / (double)this.totalPubs * 100.0)));
            }
            this.socialNetwork.setPublications(parser.getPubList());
        }
        catch (ParserConfigurationException e) {
            logger.log(Level.SEVERE, "Exception occurred", e);
            CytoscapeUtilities.notifyUser("Encountered temporary server issues. Please try again some other time.");
        }
        catch (SAXException e) {
            logger.log(Level.SEVERE, "Exception occurred", e);
            CytoscapeUtilities.notifyUser("Encountered temporary server issues. Please try again some other time.");
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Exception occurred", e);
            CytoscapeUtilities.notifyUser("Unable to connect to PubMed. Please check your internet connection.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EutilsParser
    extends DefaultHandler {
        boolean isAuthor = false;
        boolean isJournal = false;
        boolean isPMID = false;
        boolean isPubDate = false;
        boolean isTimesCited = false;
        boolean isTitle = false;

        private EutilsParser() {
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.isPubDate) {
                EutilsRetrievalParser.this.pubDate.append(ch, start, length);
            }
            if (this.isAuthor) {
                EutilsRetrievalParser.this.rawAuthorText.append(ch, start, length);
            }
            if (this.isJournal) {
                EutilsRetrievalParser.this.journal.append(ch, start, length);
            }
            if (this.isTitle) {
                EutilsRetrievalParser.this.title.append(ch, start, length);
            }
            if (this.isTimesCited) {
                EutilsRetrievalParser.this.timesCited.append(ch, start, length);
            }
            if (this.isPMID) {
                EutilsRetrievalParser.this.pmid.append(ch, start, length);
            }
        }

        public boolean contains(Attributes attributes, String text) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (!attributes.getValue(i).equalsIgnoreCase(text)) continue;
                return true;
            }
            return false;
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equals("Item") && this.isAuthor) {
                this.isAuthor = false;
                EutilsRetrievalParser.this.author = new Author(EutilsRetrievalParser.this.rawAuthorText.toString(), -2113004178);
                if (!EutilsRetrievalParser.this.pubAuthorList.contains(EutilsRetrievalParser.this.author)) {
                    EutilsRetrievalParser.this.pubAuthorList.add(EutilsRetrievalParser.this.author);
                }
            }
            if (qName.equals("Item") && this.isJournal) {
                this.isJournal = false;
            }
            if (qName.equals("Item") && this.isPubDate) {
                this.isPubDate = false;
            }
            if (qName.equals("Item") && this.isTitle) {
                this.isTitle = false;
            }
            if (qName.equals("Item") && this.isTimesCited) {
                this.isTimesCited = false;
            }
            if (qName.equals("Id")) {
                this.isPMID = false;
            }
            if (qName.equalsIgnoreCase("DocSum")) {
                Publication publication = new Publication(EutilsRetrievalParser.this.title.toString(), EutilsRetrievalParser.this.pubDate.toString(), EutilsRetrievalParser.this.journal.toString(), EutilsRetrievalParser.this.timesCited.toString(), null, EutilsRetrievalParser.this.pubAuthorList);
                publication.setPMID(EutilsRetrievalParser.this.pmid.toString());
                EutilsRetrievalParser.this.pubList.add(publication);
                EutilsRetrievalParser.this.pubAuthorList.clear();
                EutilsRetrievalParser.this.publication_counter++;
                int percentComplete = (int)((double)EutilsRetrievalParser.this.publication_counter / (double)EutilsRetrievalParser.this.totalPubs * 100.0);
                if (EutilsRetrievalParser.this.taskMonitor != null) {
                    EutilsRetrievalParser.this.taskMonitor.setProgress((double)percentComplete);
                }
            }
        }

        public ArrayList<Publication> getPubList() {
            return EutilsRetrievalParser.this.pubList;
        }

        public int getTotalPubs() {
            return EutilsRetrievalParser.this.pubList.size();
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (this.contains(attributes, "Author")) {
                this.isAuthor = true;
                EutilsRetrievalParser.this.rawAuthorText.setLength(0);
            }
            if (this.contains(attributes, "FullJournalName")) {
                this.isJournal = true;
                EutilsRetrievalParser.this.journal.setLength(0);
            }
            if (this.contains(attributes, "PubDate")) {
                this.isPubDate = true;
                EutilsRetrievalParser.this.pubDate.setLength(0);
            }
            if (this.contains(attributes, "Title")) {
                this.isTitle = true;
                EutilsRetrievalParser.this.title.setLength(0);
            }
            if (this.contains(attributes, "PmcRefCount")) {
                this.isTimesCited = true;
                EutilsRetrievalParser.this.timesCited.setLength(0);
            }
            if (qName.equals("Id")) {
                this.isPMID = true;
                EutilsRetrievalParser.this.pmid.setLength(0);
            }
        }
    }
}

