/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csapps.socialnetwork.model.academia.parsers;

import java.awt.Cursor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.baderlab.csapps.socialnetwork.CytoscapeUtilities;
import org.baderlab.csapps.socialnetwork.model.SocialNetwork;
import org.baderlab.csapps.socialnetwork.model.SocialNetworkAppManager;
import org.baderlab.csapps.socialnetwork.model.academia.Author;
import org.baderlab.csapps.socialnetwork.model.academia.Publication;
import org.baderlab.csapps.socialnetwork.model.academia.visualstyles.NodeAttribute;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParseScopus
extends AbstractTask {
    private static final Logger logger = Logger.getLogger(ParseScopus.class.getName());
    private int currentSteps = 0;
    private int totalSteps = 0;
    private double progress = 0.0;
    private TaskMonitor taskMonitor = null;
    private File csv = null;
    private SocialNetwork socialNetwork = null;
    private SocialNetworkAppManager appManager = null;
    private ArrayList<Publication> pubList = null;

    public static HashMap<String, Object> constructScopusAttrMap() {
        HashMap<String, Object> nodeAttrMap = new HashMap<String, Object>();
        nodeAttrMap.put(NodeAttribute.LABEL.toString(), "N/A");
        nodeAttrMap.put(NodeAttribute.FIRST_NAME.toString(), "N/A");
        nodeAttrMap.put(NodeAttribute.LAST_NAME.toString(), "N/A");
        nodeAttrMap.put(NodeAttribute.MAIN_INSTITUTION.toString(), "N/A");
        nodeAttrMap.put(NodeAttribute.TIMES_CITED.toString(), 0);
        nodeAttrMap.put(NodeAttribute.PUBLICATION_COUNT.toString(), 0);
        nodeAttrMap.put(NodeAttribute.PUBLICATIONS.toString(), new ArrayList());
        nodeAttrMap.put(NodeAttribute.INSTITUTIONS.toString(), new ArrayList());
        ArrayList<Integer> pubsPerYearList = new ArrayList<Integer>();
        pubsPerYearList.add(0);
        nodeAttrMap.put(NodeAttribute.PUBS_PER_YEAR.toString(), pubsPerYearList);
        String startYearTxt = SocialNetworkAppManager.getStartDateTextFieldRef().getText().trim();
        String endYearTxt = SocialNetworkAppManager.getEndDateTextFieldRef().getText().trim();
        if (Pattern.matches("[0-9]+", startYearTxt) && Pattern.matches("[0-9]+", endYearTxt)) {
            int startYear = Integer.parseInt(startYearTxt);
            int endYear = Integer.parseInt(endYearTxt);
            ArrayList<Integer> years = new ArrayList<Integer>();
            for (int i = startYear; i <= endYear; ++i) {
                years.add(i);
            }
            nodeAttrMap.put(NodeAttribute.YEARS_ACTIVE.toString(), years);
        }
        return nodeAttrMap;
    }

    public ParseScopus(File csv, SocialNetwork socialNetwork, SocialNetworkAppManager appManader) {
        this.csv = csv;
        this.socialNetwork = socialNetwork;
        this.appManager = this.appManager;
    }

    public ArrayList<Publication> getPubList() {
        if (this.pubList == null) {
            this.pubList = new ArrayList();
        }
        return this.pubList;
    }

    private void matchAuthors(ArrayList<Author> coauthorList, String affiliations) {
        HashMap<String, Author> coauthorMap = new HashMap<String, Author>();
        for (Author coauthor : coauthorList) {
            coauthorMap.put(String.format("%s, %s", coauthor.getLastName().toLowerCase(), coauthor.getFirstInitial().toLowerCase()), coauthor);
        }
        String[] affilArray = affiliations.split(";");
        String[] content = null;
        String authorName = null;
        StringBuffer institution = new StringBuffer();
        for (int i = 0; i < affilArray.length; ++i) {
            content = affilArray[i].split("\\.,");
            if (content.length <= 1) continue;
            authorName = content[0].trim().toLowerCase();
            Pattern r = Pattern.compile("(^[a-z]+-?[a-z]+, [a-z])(\\..+)?$");
            Matcher m = r.matcher(authorName);
            if (m.find()) {
                authorName = m.group(1);
            }
            institution.setLength(0);
            for (int j = 1; j < content.length; ++j) {
                institution.append(content[j].trim());
            }
            if (coauthorMap.get(authorName) == null) continue;
            ((Author)coauthorMap.get(authorName)).addInstitution(institution.toString());
        }
    }

    private boolean matchYear(String rawText) {
        Pattern pattern = Pattern.compile("^\\d{4}$");
        Matcher matcher = pattern.matcher(rawText.trim());
        return matcher.find();
    }

    private ArrayList<Author> parseAuthors(String authors) {
        String[] contents;
        ArrayList<Author> authorList = new ArrayList<Author>();
        for (String authorInfo : contents = authors.split("\\.,")) {
            authorList.add(new Author(authorInfo.trim(), -960949447));
        }
        return authorList;
    }

    private void parseScopusPubList(File csv) {
        BufferedReader in = null;
        try {
            this.setProgressMonitor("Parsing Scopus CSV ...", this.totalSteps);
            in = new BufferedReader(new FileReader(csv));
            String currentLine = in.readLine();
            if (currentLine == null) {
                return;
            }
            String columnTitlesRawText = currentLine;
            String[] columnTitlesArray = columnTitlesRawText.split(",");
            int numColumns = columnTitlesArray.length;
            String line = null;
            String authors = null;
            String year = null;
            String[] columns = null;
            Publication pub = null;
            ArrayList<Author> coauthorList = new ArrayList();
            String title = null;
            String subjectArea = null;
            String timesCited = null;
            String numericalData = null;
            String affiliations = null;
            while ((line = in.readLine()) != null) {
                columns = this.splitQuoted("\"", ",", line, numColumns);
                authors = columns[0] != null ? columns[0].replace("\"", "") : "";
                coauthorList = this.parseAuthors(authors);
                title = columns[1] != null ? columns[1].replace("\"", "") : "";
                String string = year = columns[2] != null ? columns[2].replace("\"", "") : "";
                if (numColumns > 14) {
                    affiliations = columns[14] != null ? columns[14].replace("\"", "") : "";
                    this.matchAuthors(coauthorList, affiliations);
                }
                if (!this.matchYear(year)) {
                    logger.log(Level.WARNING, String.format("Unable to parse Scopus line: %s", line.toString()));
                    continue;
                }
                subjectArea = columns[3] != null ? columns[3].replace("\"", "") : "";
                numericalData = columns[10] != null ? columns[10].replace("\"", "") : columns[10];
                timesCited = numericalData == null || numericalData.equalsIgnoreCase("") ? "0" : numericalData;
                pub = new Publication(title, year, subjectArea, timesCited, null, coauthorList);
                this.getPubList().add(pub);
            }
            if (in != null) {
                in.close();
            }
        }
        catch (FileNotFoundException e) {
            logger.log(Level.SEVERE, "Exception occurred", e);
            this.taskMonitor.setStatusMessage("File not found");
            CytoscapeUtilities.notifyUser("Unable to locate Scopus data file.\nPlease re-load file and try again.");
        }
        catch (IOException eb) {
            logger.log(Level.SEVERE, "Exception occurred", eb);
            this.taskMonitor.setStatusMessage("Unable to read file");
            CytoscapeUtilities.notifyUser("Unable to locate Scopus data file.\nPlease re-load file and try again.");
        }
    }

    private void setProgressMonitor(String taskName, int totalSteps) {
        this.taskMonitor.setTitle(taskName);
        this.taskMonitor.setProgress(0.0);
        this.currentSteps = 0;
        this.totalSteps = totalSteps;
    }

    private void setPubList(ArrayList<Publication> pubList) {
        this.pubList = pubList;
    }

    private String[] splitQuoted(String quote, String separator, String s, int numColumns) {
        String[] columns = new String[numColumns];
        int current = 0;
        int index = 0;
        int startindex = 0;
        int firstquote = s.indexOf(quote);
        int nextquote = s.indexOf(quote, current + 1);
        int nextcomma = s.indexOf(separator);
        while (current < s.length() && index < numColumns) {
            if (nextcomma > current && (nextcomma < firstquote || nextcomma > nextquote)) {
                columns[index] = s.substring(startindex, nextcomma);
                startindex = nextcomma + 1;
                ++index;
            }
            int n = nextcomma = (nextcomma = s.indexOf(separator, (current = nextcomma) + 1)) == -1 ? s.length() : nextcomma;
            if (current <= nextquote) continue;
            firstquote = s.indexOf(quote, nextquote + 1);
            nextquote = s.indexOf(quote, firstquote + 1);
        }
        return columns;
    }

    private String toPercent(double progress) {
        DecimalFormat df = new DecimalFormat("00");
        return df.format(progress *= 100.0) + "%";
    }

    private void updateProgress() {
        ++this.currentSteps;
        this.progress = (double)this.currentSteps / (double)this.totalSteps;
        this.taskMonitor.setStatusMessage("Complete: " + this.toPercent(this.progress));
        this.taskMonitor.setProgress(this.progress);
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        this.taskMonitor = taskMonitor;
        this.parseScopusPubList(this.csv);
        ArrayList<Publication> pubList = this.getPubList();
        this.socialNetwork.setPublications(this.getPubList());
        if (pubList == null) {
            this.appManager.getUserPanelRef().setCursor(new Cursor(0));
            return;
        }
    }

    public static class UnableToParseYearException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }
}

