/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csapps.socialnetwork.model.academia.parsers.pubmed;

import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.baderlab.csapps.socialnetwork.CytoscapeUtilities;
import org.baderlab.csapps.socialnetwork.model.SocialNetwork;
import org.baderlab.csapps.socialnetwork.model.academia.EutilsKeys;
import org.baderlab.csapps.socialnetwork.model.academia.Publication;
import org.baderlab.csapps.socialnetwork.model.academia.Query;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EutilsSearchParser
extends AbstractTask {
    private StringBuilder queryTranslation = null;
    private StringBuilder queryKey = new StringBuilder();
    private StringBuilder totalPubs = new StringBuilder();
    private StringBuilder webEnv = new StringBuilder();
    private StringBuilder retStart = new StringBuilder();
    private StringBuilder retMax = new StringBuilder();
    private Query query = null;
    private SocialNetwork socialNetwork = null;
    private static final Logger logger = Logger.getLogger(EutilsSearchParser.class.getName());

    public EutilsSearchParser(Query query, SocialNetwork socialNetwork) {
        this.queryTranslation = new StringBuilder();
        this.query = query;
        this.socialNetwork = socialNetwork;
    }

    private String getEutilsPMIDs(ArrayList<Publication> pubList) {
        int totalPubs;
        Publication pub = null;
        int retStart = 0;
        int retMax = totalPubs = pubList.size();
        StringBuilder pmids = new StringBuilder();
        for (int i = retStart; i < retMax; ++i) {
            pub = pubList.get(i);
            pmids.append(pub.getPMID());
            if (i >= retMax - 1) continue;
            pmids.append(",");
        }
        return pmids.toString();
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        CloseableHttpClient httpclient = HttpClients.createDefault();
        CloseableHttpResponse response = null;
        taskMonitor.setStatusMessage("Searching PubMed ...");
        if (this.query == null) {
            this.query = new Query(this.getEutilsPMIDs(this.socialNetwork.getPublications()));
        }
        taskMonitor.setProgress(0.0);
        try {
            SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
            SearchParser parser = new SearchParser();
            HttpPost httpPost = new HttpPost("https://eutils.ncbi.nlm.nih.gov/entrez/eutils/esearch.fcgi");
            ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
            nvps.add(new BasicNameValuePair("db", "pubmed"));
            nvps.add(new BasicNameValuePair("term", this.query.toString()));
            nvps.add(new BasicNameValuePair("usehistory", "y"));
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, "UTF-8"));
            httpPost.addHeader("User-Agent", "elink/1.0");
            response = httpclient.execute((HttpUriRequest)httpPost);
            int responseCode = response.getStatusLine().getStatusCode();
            if (responseCode != 200) {
                logger.log(Level.INFO, String.format("Eutils response code: %d", responseCode));
                return;
            }
            HttpEntity entity = response.getEntity();
            saxParser.parse(new InputSource(entity.getContent()), (DefaultHandler)parser);
            this.socialNetwork.setEutilsResults(new EutilsKeys(parser.getQueryKey(), parser.getWebEnv(), parser.getRetStart(), parser.getRetMax(), parser.getTotalPubs()));
            this.socialNetwork.setQueryTranslation(parser.getQueryTranslation());
            response.close();
        }
        catch (ParserConfigurationException e) {
            logger.log(Level.SEVERE, "Exception occurred", e);
            CytoscapeUtilities.notifyUser("Encountered temporary server issues. Please try again some other time.");
        }
        catch (SAXException e) {
            logger.log(Level.SEVERE, "Exception occurred", e);
            CytoscapeUtilities.notifyUser("Encountered temporary server issues. Please try again some other time.");
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Exception occurred", e);
            CytoscapeUtilities.notifyUser("Unable to connect to PubMed. Please check your internet connection.");
        }
    }

    private class SearchParser
    extends DefaultHandler {
        boolean isQueryKey = false;
        boolean isWebEnv = false;
        boolean isTotalPubs = false;
        boolean isRetStart = false;
        boolean isRetMax = false;
        boolean isQuerytranslation = false;

        private SearchParser() {
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.isTotalPubs) {
                EutilsSearchParser.this.totalPubs.append(ch, start, length);
            }
            if (this.isQueryKey) {
                EutilsSearchParser.this.queryKey.append(ch, start, length);
            }
            if (this.isWebEnv) {
                EutilsSearchParser.this.webEnv.append(ch, start, length);
            }
            if (this.isRetStart) {
                EutilsSearchParser.this.retStart.append(ch, start, length);
            }
            if (this.isRetMax) {
                EutilsSearchParser.this.retMax.append(ch, start, length);
            }
            if (this.isQuerytranslation) {
                EutilsSearchParser.this.queryTranslation.append(ch, start, length);
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equalsIgnoreCase("Count")) {
                this.isTotalPubs = false;
            }
            if (qName.equalsIgnoreCase("QueryKey")) {
                this.isQueryKey = false;
            }
            if (qName.equalsIgnoreCase("WebEnv")) {
                this.isWebEnv = false;
            }
            if (qName.equalsIgnoreCase("RetStart")) {
                this.isRetStart = false;
            }
            if (qName.equalsIgnoreCase("RetMax")) {
                this.isRetMax = false;
            }
            if (qName.equalsIgnoreCase("QueryTranslation")) {
                this.isQuerytranslation = false;
            }
        }

        public String getQueryKey() {
            return EutilsSearchParser.this.queryKey.toString();
        }

        public int getRetMax() {
            String total = EutilsSearchParser.this.retMax.toString();
            if (total != null && Pattern.matches("[0-9]+", total)) {
                return Integer.parseInt(total);
            }
            return 0;
        }

        public int getRetStart() {
            String total = EutilsSearchParser.this.retStart.toString();
            if (total != null && Pattern.matches("[0-9]+", total)) {
                return Integer.parseInt(total);
            }
            return 0;
        }

        public String getQueryTranslation() {
            if (EutilsSearchParser.this.queryTranslation != null) {
                return EutilsSearchParser.this.queryTranslation.toString();
            }
            return "";
        }

        public int getTotalPubs() {
            String total = EutilsSearchParser.this.totalPubs.toString();
            if (total != null && Pattern.matches("[0-9]+", total)) {
                return Integer.parseInt(total);
            }
            return 0;
        }

        public String getWebEnv() {
            return EutilsSearchParser.this.webEnv.toString();
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equalsIgnoreCase("Count") && EutilsSearchParser.this.totalPubs.length() == 0) {
                this.isTotalPubs = true;
                EutilsSearchParser.this.totalPubs.setLength(0);
            }
            if (qName.equalsIgnoreCase("QueryKey")) {
                this.isQueryKey = true;
                EutilsSearchParser.this.queryKey.setLength(0);
            }
            if (qName.equalsIgnoreCase("WebEnv")) {
                this.isWebEnv = true;
                EutilsSearchParser.this.webEnv.setLength(0);
            }
            if (qName.equalsIgnoreCase("RetStart")) {
                this.isRetStart = true;
                EutilsSearchParser.this.retStart.setLength(0);
            }
            if (qName.equalsIgnoreCase("RetMax")) {
                this.isRetMax = true;
                EutilsSearchParser.this.retMax.setLength(0);
            }
            if (qName.equalsIgnoreCase("QueryTranslation")) {
                this.isQuerytranslation = true;
                EutilsSearchParser.this.queryTranslation.setLength(0);
            }
        }
    }
}

