/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csapps.socialnetwork.tasks;

import java.util.Iterator;
import org.baderlab.csapps.socialnetwork.model.SocialNetwork;
import org.baderlab.csapps.socialnetwork.model.SocialNetworkAppManager;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;

public class ApplyVisualStyleTask
extends AbstractTask {
    private VisualMappingManager vmmServiceRef;
    private TaskMonitor taskMonitor;
    SocialNetworkAppManager appManager = null;

    public ApplyVisualStyleTask(VisualMappingManager vmmServiceRef, SocialNetworkAppManager appManager) {
        this.vmmServiceRef = vmmServiceRef;
        this.appManager = appManager;
    }

    private TaskMonitor getTaskMonitor() {
        return this.taskMonitor;
    }

    private VisualStyle getVisualStyle(String name) {
        Iterator it = this.vmmServiceRef.getAllVisualStyles().iterator();
        VisualStyle visualStyle = null;
        while (it.hasNext() && !(visualStyle = (VisualStyle)it.next()).getTitle().equalsIgnoreCase(name)) {
            visualStyle = null;
        }
        return visualStyle;
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        this.setTaskMonitor(taskMonitor);
        VisualStyle visualStyle = null;
        String visualStyleName = null;
        SocialNetwork socialNetwork = this.appManager.getCurrentlySelectedSocialNetwork();
        switch (socialNetwork.getVisualStyleId()) {
            case -1: {
                visualStyleName = "Default";
                break;
            }
            case 1410511959: {
                visualStyleName = String.format("%s_InCites", socialNetwork.getNetworkName());
                break;
            }
            case -2113004178: {
                visualStyleName = String.format("%s_PubMed", socialNetwork.getNetworkName());
                break;
            }
            case -960949447: {
                visualStyleName = String.format("%s_Scopus", socialNetwork.getNetworkName());
            }
        }
        visualStyle = this.getVisualStyle(visualStyleName);
        if (visualStyle != null) {
            this.getTaskMonitor().setTitle(String.format("Loading %s Visual Style ... ", visualStyleName));
            this.getTaskMonitor().setProgress(0.0);
            this.getTaskMonitor().setStatusMessage("");
        }
        this.vmmServiceRef.setCurrentVisualStyle(visualStyle);
    }

    private void setTaskMonitor(TaskMonitor taskMonitor) {
        this.taskMonitor = taskMonitor;
    }
}

