/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csapps.socialnetwork.tasks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.swing.JTextField;
import org.baderlab.csapps.socialnetwork.listeners.SocialNetworkChartListener;
import org.baderlab.csapps.socialnetwork.model.SocialNetwork;
import org.baderlab.csapps.socialnetwork.model.SocialNetworkAppManager;
import org.baderlab.csapps.socialnetwork.model.academia.visualstyles.ChartVisualStyle;
import org.baderlab.csapps.socialnetwork.model.academia.visualstyles.NodeAttribute;
import org.baderlab.csapps.socialnetwork.panels.InfoPanel;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTable;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.presentation.customgraphics.CyCustomGraphics2;
import org.cytoscape.view.presentation.customgraphics.CyCustomGraphics2Factory;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.view.presentation.property.values.CyColumnIdentifier;
import org.cytoscape.view.presentation.property.values.CyColumnIdentifierFactory;
import org.cytoscape.view.vizmap.VisualMappingFunctionFactory;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.VisualStyleFactory;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.TunableValidator;
import org.cytoscape.work.util.ListSingleSelection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateChartTask
extends AbstractTask
implements TunableValidator {
    private CyApplicationManager cyAppManager;
    private SocialNetworkChartListener customChartListener;
    private VisualMappingManager visualMappingManager;
    private CyColumnIdentifierFactory columnIdFactory;
    private Callable<CyColumn> defaultDomain;
    private Callable<CyColumn> defaultRange;
    protected VisualMappingFunctionFactory continuousMappingFactoryServiceRef;
    protected VisualMappingFunctionFactory discreteMappingFactoryServiceRef;
    protected VisualMappingFunctionFactory passthroughMappingFactoryServiceRef;
    private SocialNetwork socialNetwork = null;
    private VisualStyleFactory visualStyleFactoryServiceRef = null;
    @Tunable(description="Set Domain:")
    public ListSingleSelection<Callable<CyColumn>> domainColumnNames;
    @Tunable(description="Set Range:")
    public ListSingleSelection<Callable<CyColumn>> rangeColumnNames;
    @Tunable(description="Visual Property:")
    public ListSingleSelection<Callable<VisualProperty<CyCustomGraphics2<?>>>> visualProperties;

    public CreateChartTask(CyApplicationManager applicationManager, SocialNetworkChartListener customChartManager, VisualMappingManager visualMappingManager, CyColumnIdentifierFactory columnIdFactory, SocialNetworkAppManager socialNetworkAppManager, VisualMappingFunctionFactory passthroughMappingFactoryServiceRef, VisualMappingFunctionFactory continuousMappingFactoryServiceRef, VisualMappingFunctionFactory discreteMappingFactoryServiceRef, VisualStyleFactory visualStyleFactoryServiceRef) {
        this.cyAppManager = applicationManager;
        this.customChartListener = customChartManager;
        this.visualMappingManager = visualMappingManager;
        this.columnIdFactory = columnIdFactory;
        this.continuousMappingFactoryServiceRef = continuousMappingFactoryServiceRef;
        this.discreteMappingFactoryServiceRef = discreteMappingFactoryServiceRef;
        this.passthroughMappingFactoryServiceRef = passthroughMappingFactoryServiceRef;
        this.visualStyleFactoryServiceRef = visualStyleFactoryServiceRef;
        this.socialNetwork = socialNetworkAppManager.getCurrentlySelectedSocialNetwork();
        this.domainColumnNames = this.computeNumericNodeColumns();
        this.domainColumnNames.setSelectedValue(this.defaultDomain);
        this.rangeColumnNames = this.computeNumericNodeColumns();
        this.rangeColumnNames.setSelectedValue(this.defaultRange);
        this.visualProperties = this.computeVisualProperties();
    }

    private ListSingleSelection<Callable<CyColumn>> computeNumericNodeColumns() {
        CyNetwork network = this.cyAppManager.getCurrentNetwork();
        CyTable nodeTable = network.getDefaultNodeTable();
        Collection nodeColumns = nodeTable.getColumns();
        ArrayList<1> numericColumnNames = new ArrayList<1>();
        Callable<CyColumn> callableColumn = null;
        for (final CyColumn column : nodeColumns) {
            if (column.getType() != List.class || !Number.class.isAssignableFrom(column.getListElementType()) || column.isPrimaryKey()) continue;
            callableColumn = new Callable<CyColumn>(){

                @Override
                public CyColumn call() {
                    return column;
                }

                public String toString() {
                    return column.getName();
                }
            };
            if (column.getName().equals(NodeAttribute.YEARS_ACTIVE.toString())) {
                this.defaultDomain = callableColumn;
            }
            if (column.getName().equals(NodeAttribute.PUBS_PER_YEAR.toString())) {
                this.defaultRange = callableColumn;
            }
            numericColumnNames.add(callableColumn);
        }
        return new ListSingleSelection(numericColumnNames);
    }

    private ListSingleSelection<Callable<VisualProperty<CyCustomGraphics2<?>>>> computeVisualProperties() {
        Set lexicons = this.visualMappingManager.getAllVisualLexicon();
        ArrayList<2> visualProperties = new ArrayList<2>();
        for (VisualLexicon lexicon : lexicons) {
            for (int i = 1; i <= 9; ++i) {
                final VisualProperty visualProperty = lexicon.lookup(CyNode.class, "nodeCustomGraphics" + i);
                if (visualProperty == null) continue;
                visualProperties.add(new Callable<VisualProperty<CyCustomGraphics2<?>>>(){

                    @Override
                    public VisualProperty<CyCustomGraphics2<?>> call() {
                        return visualProperty;
                    }

                    public String toString() {
                        return visualProperty.getDisplayName();
                    }
                });
            }
        }
        return new ListSingleSelection(visualProperties);
    }

    public TunableValidator.ValidationState getValidationState(Appendable message) {
        return TunableValidator.ValidationState.OK;
    }

    public void run(TaskMonitor monitor) throws Exception {
        monitor.setTitle("Generating Charts ...");
        CyColumn domainColumn = (CyColumn)((Callable)this.domainColumnNames.getSelectedValue()).call();
        CyColumn rangeColumn = (CyColumn)((Callable)this.rangeColumnNames.getSelectedValue()).call();
        VisualProperty visualProperty = (VisualProperty)((Callable)this.visualProperties.getSelectedValue()).call();
        monitor.setStatusMessage("Using Visual Property '" + visualProperty.getDisplayName() + "'");
        monitor.setStatusMessage("Creating charts");
        CyCustomGraphics2Factory<?> customGraphicsFactory = this.customChartListener.getFactory();
        CyNetwork network = this.socialNetwork.getCyNetwork();
        ChartVisualStyle chartVisualStyle = new ChartVisualStyle(this.cyAppManager, network, this.socialNetwork, this.visualStyleFactoryServiceRef, this.passthroughMappingFactoryServiceRef, this.continuousMappingFactoryServiceRef, this.discreteMappingFactoryServiceRef, true);
        this.visualMappingManager.addVisualStyle(chartVisualStyle.getVisualStyle());
        this.visualMappingManager.setCurrentVisualStyle(chartVisualStyle.getVisualStyle());
        CyNetworkView networkView = this.socialNetwork.getNetworkView();
        if (networkView == null) {
            monitor.showMessage(TaskMonitor.Level.ERROR, "No network view");
            return;
        }
        for (CyNode node : network.getNodeList()) {
            networkView.getNodeView(node).setLockedValue(BasicVisualLexicon.NODE_VISIBLE, (Object)true);
        }
        for (CyEdge edge : network.getEdgeList()) {
            networkView.getEdgeView(edge).setLockedValue(BasicVisualLexicon.EDGE_VISIBLE, (Object)true);
        }
        InfoPanel infoPanel = SocialNetworkAppManager.getInfoPanel();
        if (infoPanel != null) {
            JTextField infoPanelTextField = infoPanel.getTextField();
            infoPanelTextField.setText("ALL");
            infoPanelTextField.repaint();
        }
        CyColumnIdentifier domainColumnId = this.columnIdFactory.createColumnIdentifier(domainColumn.getName());
        CyColumnIdentifier rangeColumnId = this.columnIdFactory.createColumnIdentifier(rangeColumn.getName());
        HashMap<String, Object> chartProps = new HashMap<String, Object>();
        chartProps.put("cy_dataColumns", Arrays.asList(rangeColumnId));
        chartProps.put("cy_domainLabelsColumn", domainColumnId);
        chartProps.put("cy_globalRange", "true");
        chartProps.put("cy_showDomainAxis", "true");
        chartProps.put("cy_showRangeAxis", "true");
        chartProps.put("cy_orientation", "VERTICAL");
        chartProps.put("cy_domainLabelPosition", "UP_45");
        chartProps.put("cy_separation", 0.2);
        chartProps.put("cy_type", "GROUPED");
        chartProps.put("cy_colorScheme", "MODULATED");
        CyCustomGraphics2 customGraphics = customGraphicsFactory.getInstance(chartProps);
        VisualStyle visualStyle = this.visualMappingManager.getCurrentVisualStyle();
        visualStyle.setDefaultValue(visualProperty, (Object)customGraphics);
        networkView.updateView();
    }
}

