/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csapps.socialnetwork.model.academia.parsers.pubmed;

import java.awt.Cursor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.baderlab.csapps.socialnetwork.CytoscapeUtilities;
import org.baderlab.csapps.socialnetwork.model.SocialNetwork;
import org.baderlab.csapps.socialnetwork.model.SocialNetworkAppManager;
import org.baderlab.csapps.socialnetwork.model.academia.Author;
import org.baderlab.csapps.socialnetwork.model.academia.PubMed;
import org.baderlab.csapps.socialnetwork.model.academia.Publication;
import org.baderlab.csapps.socialnetwork.model.academia.parsers.MonitoredFileInputStream;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PubMedXmlParserTask
extends AbstractTask {
    private static final Logger logger = Logger.getLogger(PubMedXmlParserTask.class.getName());
    private Author author = null;
    private StringBuilder lastName = null;
    private StringBuilder firstName = null;
    private StringBuilder middleInitials = null;
    private StringBuilder institution = null;
    private StringBuilder journal = null;
    private ArrayList<Author> pubAuthorList = new ArrayList();
    private StringBuilder pubDate = null;
    private ArrayList<Publication> pubList = new ArrayList();
    private StringBuilder pmid = null;
    private StringBuilder timesCited = null;
    private StringBuilder title = null;
    private File xmlFile = null;
    private SocialNetwork socialNetwork = null;
    private SocialNetworkAppManager appManager = null;

    public PubMedXmlParserTask(SocialNetworkAppManager appManager, SocialNetwork socialNetwork) {
        this.appManager = appManager;
        this.socialNetwork = socialNetwork;
        this.xmlFile = this.appManager.getNetworkFile();
        this.lastName = new StringBuilder();
        this.firstName = new StringBuilder();
        this.middleInitials = new StringBuilder();
        this.institution = new StringBuilder();
        this.journal = new StringBuilder();
        this.pubDate = new StringBuilder();
        this.pmid = new StringBuilder();
        this.timesCited = new StringBuilder();
        this.title = new StringBuilder();
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        try {
            MonitoredFileInputStream fileInputStream = new MonitoredFileInputStream(this.xmlFile, taskMonitor, "Parsing PubMed XML ...");
            SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
            Parser xmlparser = new Parser();
            saxParser.parse((InputStream)fileInputStream, (DefaultHandler)xmlparser);
            ArrayList<Publication> pubList = xmlparser.getPubList();
            if (pubList.size() < 1) {
                return;
            }
            PubMed pubmed = new PubMed(pubList);
            this.socialNetwork.setPublications(pubmed.getPubList());
            if (pubList == null) {
                this.appManager.getUserPanelRef().setCursor(new Cursor(0));
            }
        }
        catch (ParserConfigurationException e) {
            logger.log(Level.SEVERE, "Exception occurred", e);
            CytoscapeUtilities.notifyUser("Encountered temporary server issues. Please try again some other time.");
        }
        catch (SAXException e) {
            logger.log(Level.SEVERE, "Exception occurred", e);
            CytoscapeUtilities.notifyUser("Encountered temporary server issues. Please try again some other time.");
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Exception occurred", e);
            CytoscapeUtilities.notifyUser("Unable to connect to PubMed. Please check your internet connection.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Parser
    extends DefaultHandler {
        boolean isAuthor = false;
        boolean isFirstName = false;
        boolean isInstitution = false;
        boolean isJournal = false;
        boolean isLastName = false;
        boolean isMiddleInitial = false;
        boolean isPMID = false;
        boolean isPubDate = false;
        boolean isTimesCited = false;
        boolean isTitle = false;

        private Parser() {
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.isPubDate) {
                PubMedXmlParserTask.this.pubDate.append(ch, start, length);
            }
            if (this.isAuthor) {
                PubMedXmlParserTask.this.author = new Author(new String(ch, start, length), -2113004178);
            }
            if (this.isInstitution) {
                PubMedXmlParserTask.this.institution.append(ch, start, length);
            }
            if (this.isFirstName) {
                PubMedXmlParserTask.this.firstName.append(ch, start, length);
            }
            if (this.isLastName) {
                PubMedXmlParserTask.this.lastName.append(ch, start, length);
            }
            if (this.isMiddleInitial) {
                PubMedXmlParserTask.this.middleInitials.append(ch, start, length);
            }
            if (this.isJournal) {
                PubMedXmlParserTask.this.journal.append(ch, start, length);
            }
            if (this.isTitle) {
                PubMedXmlParserTask.this.title.append(ch, start, length);
            }
            if (this.isTimesCited) {
                PubMedXmlParserTask.this.timesCited.append(ch, start, length);
            }
            if (this.isPMID) {
                PubMedXmlParserTask.this.pmid.append(ch, start, length);
            }
        }

        public boolean contains(Attributes attributes, String text) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (!attributes.getValue(i).equalsIgnoreCase(text)) continue;
                return true;
            }
            return false;
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equals("PubDate")) {
                this.isPubDate = false;
            }
            if (qName.equals("Author")) {
                this.isAuthor = false;
            }
            if (qName.equals("Affiliation")) {
                this.isInstitution = false;
            }
            if (qName.equals("ForeName")) {
                this.isFirstName = false;
            }
            if (qName.equals("LastName")) {
                this.isLastName = false;
            }
            if (qName.equals("Initials")) {
                this.isMiddleInitial = false;
            }
            if (qName.equals("Title")) {
                this.isJournal = false;
            }
            if (qName.equals("ArticleTitle")) {
                this.isTitle = false;
            }
            if (qName.equals("PmcRefCount")) {
                this.isTimesCited = false;
            }
            if (qName.equals("ArticleId") && this.isPMID) {
                this.isPMID = false;
            }
            if (qName.equalsIgnoreCase("PubmedArticle")) {
                Publication pub = new Publication(PubMedXmlParserTask.this.title.toString(), PubMedXmlParserTask.this.pubDate.toString(), PubMedXmlParserTask.this.journal.toString(), PubMedXmlParserTask.this.timesCited.toString(), null, PubMedXmlParserTask.this.pubAuthorList);
                pub.setPMID(PubMedXmlParserTask.this.pmid.toString());
                PubMedXmlParserTask.this.pubList.add(pub);
                PubMedXmlParserTask.this.pubAuthorList.clear();
            }
            if (qName.equals("Author")) {
                PubMedXmlParserTask.this.author.setFirstName(PubMedXmlParserTask.this.firstName.toString());
                PubMedXmlParserTask.this.author.setLastName(PubMedXmlParserTask.this.lastName.toString());
                PubMedXmlParserTask.this.author.setMiddleInitial(PubMedXmlParserTask.this.middleInitials.toString());
                PubMedXmlParserTask.this.author.setFirstInitial(PubMedXmlParserTask.this.firstName.substring(0, 1));
                PubMedXmlParserTask.this.author.setLabel(PubMedXmlParserTask.this.author.getFirstInitial() + " " + PubMedXmlParserTask.this.author.getLastName());
                PubMedXmlParserTask.this.author.addInstitution(PubMedXmlParserTask.this.institution.toString());
                if (!PubMedXmlParserTask.this.pubAuthorList.contains(PubMedXmlParserTask.this.author)) {
                    PubMedXmlParserTask.this.pubAuthorList.add(PubMedXmlParserTask.this.author);
                }
            }
        }

        public ArrayList<Publication> getPubList() {
            return PubMedXmlParserTask.this.pubList;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals("Author")) {
                this.isAuthor = true;
            }
            if (qName.equals("Affiliation")) {
                this.isInstitution = true;
                PubMedXmlParserTask.this.institution.setLength(0);
            }
            if (qName.equals("LastName")) {
                this.isLastName = true;
                PubMedXmlParserTask.this.lastName.setLength(0);
            }
            if (qName.equals("ForeName")) {
                this.isFirstName = true;
                PubMedXmlParserTask.this.firstName.setLength(0);
            }
            if (qName.equals("Initials")) {
                this.isMiddleInitial = true;
                PubMedXmlParserTask.this.middleInitials.setLength(0);
            }
            if (qName.equals("Title")) {
                this.isJournal = true;
                PubMedXmlParserTask.this.journal.setLength(0);
            }
            if (qName.equals("PubDate")) {
                this.isPubDate = true;
                PubMedXmlParserTask.this.pubDate.setLength(0);
            }
            if (qName.equals("ArticleTitle")) {
                this.isTitle = true;
                PubMedXmlParserTask.this.title.setLength(0);
            }
            if (qName.equals("PmcRefCount")) {
                this.isTimesCited = true;
                PubMedXmlParserTask.this.timesCited.setLength(0);
            }
            if (qName.equals("ArticleId") && this.contains(attributes, "pubmed")) {
                this.isPMID = true;
                PubMedXmlParserTask.this.pmid.setLength(0);
            }
        }
    }
}

