/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csapps.socialnetwork.model.academia.visualstyles;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.math.stat.descriptive.DescriptiveStatistics;
import org.baderlab.csapps.socialnetwork.model.AbstractVisualStyle;
import org.baderlab.csapps.socialnetwork.model.SocialNetwork;
import org.baderlab.csapps.socialnetwork.model.academia.visualstyles.EdgeAttribute;
import org.baderlab.csapps.socialnetwork.model.academia.visualstyles.NodeAttribute;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyTable;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.view.vizmap.VisualMappingFunction;
import org.cytoscape.view.vizmap.VisualMappingFunctionFactory;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.VisualStyleFactory;
import org.cytoscape.view.vizmap.mappings.BoundaryRangeValues;
import org.cytoscape.view.vizmap.mappings.ContinuousMapping;
import org.cytoscape.view.vizmap.mappings.PassthroughMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseAcademiaVisualStyle
extends AbstractVisualStyle {
    protected VisualMappingFunctionFactory continuousMappingFactoryServiceRef;
    protected CyApplicationManager cyApplicationManagerServiceRef = null;
    protected VisualMappingFunctionFactory discreteMappingFactoryServiceRef;
    protected CyNetwork network = null;
    protected VisualMappingFunctionFactory passthroughMappingFactoryServiceRef;
    protected SocialNetwork socialNetwork = null;
    protected VisualStyle visualStyle = null;

    public BaseAcademiaVisualStyle(CyApplicationManager cyApplicationManagerServiceRef, CyNetwork network, SocialNetwork socialNetwork, VisualStyleFactory visualStyleFactoryServiceRef, VisualMappingFunctionFactory passthroughMappingFactoryServiceRef, VisualMappingFunctionFactory continuousMappingFactoryServiceRef, VisualMappingFunctionFactory discreteMappingFactoryServiceRef, boolean isChart) {
        this.network = network;
        this.socialNetwork = socialNetwork;
        this.cyApplicationManagerServiceRef = cyApplicationManagerServiceRef;
        this.passthroughMappingFactoryServiceRef = passthroughMappingFactoryServiceRef;
        this.continuousMappingFactoryServiceRef = continuousMappingFactoryServiceRef;
        this.discreteMappingFactoryServiceRef = discreteMappingFactoryServiceRef;
        String networkName = null;
        switch (this.socialNetwork.getNetworkType()) {
            case -2113004178: {
                networkName = String.format("%s_PubMed", socialNetwork.getNetworkName());
                break;
            }
            case 1410511959: {
                networkName = String.format("%s_InCites", socialNetwork.getNetworkName());
                break;
            }
            case -960949447: {
                networkName = String.format("%s_Scopus", socialNetwork.getNetworkName());
            }
        }
        if (isChart) {
            networkName = String.format("%s Chart", socialNetwork.getNetworkName());
        }
        this.visualStyle = visualStyleFactoryServiceRef.createVisualStyle(networkName);
        this.applyVisualStyle(this.visualStyle);
    }

    @Override
    protected void applyEdgeStyle(VisualStyle visualStyle) {
        this.applyEdgeWidth(visualStyle);
        this.applyEdgeTransparency(visualStyle);
        this.applyEdgeVisibility(visualStyle);
    }

    @Override
    protected void applyEdgeTransparency(VisualStyle visualStyle) {
        CyTable edgeTable = this.network.getDefaultEdgeTable();
        int min = 0;
        int max = 0;
        edgeTable = this.network.getDefaultEdgeTable();
        CyColumn copubColumn = edgeTable.getColumn(EdgeAttribute.COPUBLICATION_COUNT.toString());
        ArrayList copubList = (ArrayList)copubColumn.getValues(Integer.class);
        copubList = (ArrayList)copubColumn.getValues(Integer.class);
        min = this.getSmallestInCutoff(copubList, 5.0);
        max = this.getLargestInCutoff(copubList, 100.0);
        ContinuousMapping mapping = (ContinuousMapping)this.continuousMappingFactoryServiceRef.createVisualMappingFunction(EdgeAttribute.COPUBLICATION_COUNT.toString(), Integer.class, BasicVisualLexicon.EDGE_TRANSPARENCY);
        BoundaryRangeValues bv0 = new BoundaryRangeValues((Object)100.0, (Object)100.0, (Object)100.0);
        BoundaryRangeValues bv1 = new BoundaryRangeValues((Object)300.0, (Object)300.0, (Object)300.0);
        mapping.addPoint((Object)1, bv0);
        mapping.addPoint((Object)(max / 2), bv1);
        visualStyle.addVisualMappingFunction((VisualMappingFunction)mapping);
    }

    @Override
    protected void applyEdgeVisibility(VisualStyle visualStyle) {
    }

    @Override
    protected void applyEdgeWidth(VisualStyle visualStyle) {
        CyTable edgeTable = this.network.getDefaultEdgeTable();
        int min = 0;
        int max = 0;
        edgeTable = this.network.getDefaultEdgeTable();
        CyColumn copubColumn = edgeTable.getColumn(EdgeAttribute.COPUBLICATION_COUNT.toString());
        ArrayList copubList = (ArrayList)copubColumn.getValues(Integer.class);
        copubList = (ArrayList)copubColumn.getValues(Integer.class);
        min = this.getSmallestInCutoff(copubList, 5.0);
        max = this.getLargestInCutoff(copubList, 100.0);
        ContinuousMapping edgeWidthContinuousMapping = (ContinuousMapping)this.continuousMappingFactoryServiceRef.createVisualMappingFunction(EdgeAttribute.COPUBLICATION_COUNT.toString(), Integer.class, BasicVisualLexicon.EDGE_WIDTH);
        BoundaryRangeValues bv0 = new BoundaryRangeValues((Object)1.0, (Object)1.0, (Object)1.0);
        BoundaryRangeValues bv1 = new BoundaryRangeValues((Object)10.0, (Object)10.0, (Object)10.0);
        edgeWidthContinuousMapping.addPoint((Object)(min + 1), bv0);
        edgeWidthContinuousMapping.addPoint((Object)max, bv1);
        visualStyle.addVisualMappingFunction((VisualMappingFunction)edgeWidthContinuousMapping);
    }

    @Override
    protected void applyNodeBorderPaint(VisualStyle visualStyle) {
    }

    @Override
    protected void applyNodeBorderWidth(VisualStyle visualStyle) {
    }

    @Override
    protected void applyNodeFillColor(VisualStyle visualStyle) {
    }

    @Override
    protected void applyNodeLabel(VisualStyle visualStyle) {
        PassthroughMapping labelPassthroughMapping = (PassthroughMapping)this.passthroughMappingFactoryServiceRef.createVisualMappingFunction(NodeAttribute.LABEL.toString(), Integer.class, BasicVisualLexicon.NODE_LABEL);
        visualStyle.addVisualMappingFunction((VisualMappingFunction)labelPassthroughMapping);
    }

    @Override
    protected void applyNodeLabelFontFace(VisualStyle visualStyle) {
    }

    @Override
    protected void applyNodeLabelPosition(VisualStyle visualStyle) {
    }

    @Override
    protected void applyNodeShape(VisualStyle visualStyle) {
    }

    @Override
    protected void applyNodeSize(VisualStyle visualStyle) {
        CyTable nodeTable = this.network.getDefaultNodeTable();
        CyColumn timesCitedColumn = nodeTable.getColumn(NodeAttribute.TIMES_CITED.toString());
        ArrayList timesCitedList = (ArrayList)timesCitedColumn.getValues(Integer.class);
        int minNodeSize = this.getSmallestInCutoff(timesCitedList, 10.0);
        int maxNodeSize = this.getLargestInCutoff(timesCitedList, 95.0);
        ContinuousMapping timesCitesContinuousMapping = (ContinuousMapping)this.continuousMappingFactoryServiceRef.createVisualMappingFunction(NodeAttribute.TIMES_CITED.toString(), Integer.class, BasicVisualLexicon.NODE_SIZE);
        BoundaryRangeValues bv0 = new BoundaryRangeValues((Object)10.0, (Object)10.0, (Object)10.0);
        BoundaryRangeValues bv1 = new BoundaryRangeValues((Object)50.0, (Object)50.0, (Object)50.0);
        timesCitesContinuousMapping.addPoint((Object)minNodeSize, bv0);
        timesCitesContinuousMapping.addPoint((Object)maxNodeSize, bv1);
        visualStyle.addVisualMappingFunction((VisualMappingFunction)timesCitesContinuousMapping);
    }

    @Override
    protected void applyNodeStyle(VisualStyle visualStyle) {
        this.applyNodeLabel(visualStyle);
        this.applyNodeLabelPosition(visualStyle);
        this.applyNodeSize(visualStyle);
        this.applyNodeFillColor(visualStyle);
        this.applyNodeShape(visualStyle);
        this.applyNodeBorderPaint(visualStyle);
        this.applyNodeBorderWidth(visualStyle);
        this.applyNodeLabelFontFace(visualStyle);
        this.applyNodeVisibility(visualStyle);
    }

    @Override
    protected void applyNodeVisibility(VisualStyle visualStyle) {
    }

    @Override
    protected void applyVisualStyle(VisualStyle visualStyle) {
        this.applyNodeStyle(visualStyle);
        this.applyEdgeStyle(visualStyle);
    }

    public boolean equals(Object obj) {
        BaseAcademiaVisualStyle other = (BaseAcademiaVisualStyle)obj;
        return this.visualStyle.getTitle().equals(other.getVisualStyle().getTitle());
    }

    protected int getLargestInCutoff(ArrayList<Integer> list, Double cutoff) {
        Collections.sort(list);
        DescriptiveStatistics stats = new DescriptiveStatistics();
        for (int value : list) {
            stats.addValue((double)value);
        }
        Double percentile = stats.getPercentile(cutoff.doubleValue());
        for (int i = list.size() - 1; i > -1; --i) {
            if (!((double)list.get(i).intValue() <= percentile)) continue;
            return list.get(i);
        }
        return list.get(list.size() - 1);
    }

    protected int getSmallestInCutoff(ArrayList<Integer> list, Double cutoff) {
        Collections.sort(list);
        DescriptiveStatistics stats = new DescriptiveStatistics();
        for (int value : list) {
            stats.addValue((double)value);
        }
        Double percentile = stats.getPercentile(cutoff.doubleValue());
        for (int i = 0; i < list.size(); ++i) {
            if (!((double)list.get(i).intValue() >= percentile)) continue;
            return list.get(i);
        }
        return list.get(0);
    }

    @Override
    public VisualStyle getVisualStyle() {
        return this.visualStyle;
    }

    public int hashCode() {
        return this.visualStyle.getTitle().hashCode();
    }
}

