/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csapps.socialnetwork.tasks;

import java.awt.Cursor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.baderlab.csapps.socialnetwork.CytoscapeUtilities;
import org.baderlab.csapps.socialnetwork.model.AbstractEdge;
import org.baderlab.csapps.socialnetwork.model.AbstractNode;
import org.baderlab.csapps.socialnetwork.model.Collaboration;
import org.baderlab.csapps.socialnetwork.model.Interaction;
import org.baderlab.csapps.socialnetwork.model.SocialNetwork;
import org.baderlab.csapps.socialnetwork.model.SocialNetworkAppManager;
import org.baderlab.csapps.socialnetwork.model.academia.Author;
import org.baderlab.csapps.socialnetwork.model.academia.Copublication;
import org.baderlab.csapps.socialnetwork.model.academia.Publication;
import org.baderlab.csapps.socialnetwork.tasks.SearchPubMedTaskFactory;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreatePublicationNetworkFromPublications
extends AbstractTask {
    private static final Logger logger = Logger.getLogger(SearchPubMedTaskFactory.class.getName());
    private SocialNetworkAppManager appManager = null;
    private SocialNetwork socialNetwork = null;
    private String name = null;
    private ArrayList<Publication> excludedPublications = null;
    private TaskMonitor taskMonitor = null;

    public CreatePublicationNetworkFromPublications(SocialNetworkAppManager appManager, SocialNetwork socialNetwork, String searchTerm) {
        this.appManager = appManager;
        this.socialNetwork = socialNetwork;
        this.name = searchTerm;
        this.excludedPublications = new ArrayList();
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        this.taskMonitor = taskMonitor;
        taskMonitor.setStatusMessage("Creating Co-publication network from retrieved Pubmed results");
        int maxAuthorThreshold = this.appManager.getMaxAuthorThreshold();
        ArrayList<Publication> results = this.socialNetwork.getPublications();
        if (results == null) {
            this.appManager.getUserPanelRef().setCursor(new Cursor(0));
            String message = "No results found";
            logger.log(Level.WARNING, message);
            CytoscapeUtilities.notifyUser(message);
            return;
        }
        if (results.size() == 0) {
            this.appManager.getUserPanelRef().setCursor(new Cursor(0));
            String message = "Search did not yield any results";
            logger.log(Level.WARNING, message);
            CytoscapeUtilities.notifyUser(message);
            return;
        }
        Map<Collaboration, ArrayList<AbstractEdge>> map = null;
        Map<Collaboration, ArrayList<AbstractEdge>> academiamap = this.loadAcademiaMap(results, maxAuthorThreshold);
        Interaction interaction = new Interaction(academiamap, -2113004178);
        map = interaction.getAbstractMap();
        if (map.size() == 0) {
            this.appManager.getUserPanelRef().setCursor(new Cursor(0));
            CytoscapeUtilities.notifyUser("Network couldn't be loaded. Adjust max author threshold.");
            return;
        }
        ArrayList<Publication> pubList = results;
        this.socialNetwork.setPublications(pubList);
        this.socialNetwork.setExcludedPubs(interaction.getExcludedPublications());
        this.appManager.setNetworkName(this.name);
        this.appManager.getSocialNetworkMap().put(this.name, this.socialNetwork);
        this.appManager.setMap(map);
    }

    private Map<Collaboration, ArrayList<AbstractEdge>> loadAcademiaMap(List<? extends AbstractEdge> results, int maxThreshold) {
        HashMap<Collaboration, ArrayList<AbstractEdge>> academiaMap = new HashMap<Collaboration, ArrayList<AbstractEdge>>();
        HashMap<Author, Author> authorMap = new HashMap<Author, Author>();
        int h = 0;
        int i = 0;
        int j = 0;
        Collaboration collaboration = null;
        Author author1 = null;
        Author author2 = null;
        Copublication copublications = null;
        Publication publication = null;
        List<? extends AbstractNode> listOfNodes = null;
        HashSet<Publication> pubSet = new HashSet<Publication>();
        while (h <= results.size() - 1) {
            publication = (Publication)results.get(h);
            if (pubSet.contains(publication)) {
                ++h;
                continue;
            }
            if (maxThreshold < 0 || publication.getNodes().size() <= maxThreshold) {
                j = 0;
                collaboration = null;
                author1 = null;
                author2 = null;
                copublications = null;
                listOfNodes = null;
                listOfNodes = publication.getNodes();
                for (i = 0; i < listOfNodes.size(); ++i) {
                    author1 = (Author)listOfNodes.get(i);
                    if (authorMap.get(author1) == null) {
                        authorMap.put(author1, author1);
                    }
                    ((Author)authorMap.get(author1)).addPublication(publication);
                    for (j = i + 1; j < listOfNodes.size(); ++j) {
                        author2 = (Author)listOfNodes.get(j);
                        if (authorMap.get(author2) == null) {
                            authorMap.put(author2, author2);
                        }
                        if (!academiaMap.containsKey(collaboration = new Collaboration((AbstractNode)authorMap.get(author1), (AbstractNode)authorMap.get(author2)))) {
                            copublications = new Copublication(collaboration, publication);
                            ArrayList<Copublication> edgeList = new ArrayList<Copublication>();
                            edgeList.add(copublications);
                            academiaMap.put(collaboration, edgeList);
                            continue;
                        }
                        ArrayList array = (ArrayList)academiaMap.get(collaboration);
                        copublications = (Copublication)array.get(0);
                        copublications.addPublication(publication);
                    }
                }
            } else {
                this.excludedPublications.add(publication);
            }
            pubSet.add(publication);
            this.taskMonitor.setProgress((double)((int)((double)(++h) / (double)results.size() * 100.0)));
        }
        return academiaMap;
    }
}

