/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csapps.socialnetwork.tasks;

import java.awt.Cursor;
import java.util.logging.Logger;
import org.baderlab.csapps.socialnetwork.CytoscapeUtilities;
import org.baderlab.csapps.socialnetwork.model.SocialNetwork;
import org.baderlab.csapps.socialnetwork.model.SocialNetworkAppManager;
import org.baderlab.csapps.socialnetwork.model.academia.Query;
import org.baderlab.csapps.socialnetwork.model.academia.parsers.pubmed.EutilsRetrievalParser;
import org.baderlab.csapps.socialnetwork.model.academia.parsers.pubmed.EutilsSearchParser;
import org.baderlab.csapps.socialnetwork.tasks.CreatePublicationNetworkFromPublications;
import org.cytoscape.work.AbstractTaskFactory;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;

public class SearchPubMedTaskFactory
extends AbstractTaskFactory {
    private static final Logger logger = Logger.getLogger(SearchPubMedTaskFactory.class.getName());
    private SocialNetworkAppManager appManager = null;

    public SearchPubMedTaskFactory(SocialNetworkAppManager appManager) {
        this.appManager = appManager;
    }

    public TaskIterator createTaskIterator() {
        TaskIterator taskIterator = new TaskIterator(new Task[0]);
        String searchTerm = this.appManager.getSearchTerm();
        if (!this.appManager.isNameValid(searchTerm).booleanValue()) {
            String message = String.format("Network %s already exists in Cytoscape. Please enter a new name.", searchTerm);
            CytoscapeUtilities.notifyUser(message);
            return taskIterator;
        }
        SocialNetwork socialNetwork = new SocialNetwork(searchTerm, -2113004178);
        this.appManager.getUserPanelRef().setCursor(new Cursor(3));
        Query query = new Query(searchTerm);
        EutilsSearchParser eUtilsSearchParser = new EutilsSearchParser(query, socialNetwork);
        taskIterator.append((Task)eUtilsSearchParser);
        EutilsRetrievalParser eUtilsRetParser = new EutilsRetrievalParser(socialNetwork);
        taskIterator.append((Task)eUtilsRetParser);
        CreatePublicationNetworkFromPublications createnetwork = new CreatePublicationNetworkFromPublications(this.appManager, socialNetwork, searchTerm);
        taskIterator.append((Task)createnetwork);
        taskIterator.append(this.appManager.getNetworkTaskFactoryRef().createTaskIterator());
        return taskIterator;
    }

    public boolean isReady() {
        return false;
    }
}

