/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csapps.socialnetwork.listeners;

import java.awt.Cursor;
import org.baderlab.csapps.socialnetwork.model.SocialNetwork;
import org.baderlab.csapps.socialnetwork.model.SocialNetworkAppManager;
import org.baderlab.csapps.socialnetwork.model.visualstyles.BasicSocialNetworkVisualstyle;
import org.baderlab.csapps.socialnetwork.model.visualstyles.IncitesVisualStyle;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.events.NetworkAddedEvent;
import org.cytoscape.model.events.NetworkAddedListener;

public class SocialNetworkAddedListener
implements NetworkAddedListener {
    private SocialNetworkAppManager appManager = null;
    private CyNetworkManager cyNetworkManagerServiceRef = null;

    public SocialNetworkAddedListener(SocialNetworkAppManager appManager, CyNetworkManager cyNetworkManagerServiceRef) {
        this.appManager = appManager;
        this.cyNetworkManagerServiceRef = cyNetworkManagerServiceRef;
    }

    public void handleEvent(NetworkAddedEvent event) {
        this.appManager.getUserPanelRef().setCursor(new Cursor(0));
        String name = SocialNetworkAppManager.getNetworkName(event.getNetwork());
        if (this.appManager.getSocialNetworkMap().containsKey(name)) {
            SocialNetwork socialNetwork = this.appManager.getSocialNetworkMap().get(name);
            socialNetwork.setCyNetwork(event.getNetwork());
            this.appManager.getUserPanelRef().addNetworkToNetworkPanel(socialNetwork);
            int networkID = socialNetwork.getNetworkType();
            switch (networkID) {
                case 1410511959: {
                    IncitesVisualStyle vs = new IncitesVisualStyle();
                    vs.applyVisualStyle(event.getNetwork(), socialNetwork);
                    break;
                }
                case -960949447: {
                    BasicSocialNetworkVisualstyle vs_scopus = new BasicSocialNetworkVisualstyle();
                    vs_scopus.applyVisualStyle(event.getNetwork(), socialNetwork);
                    break;
                }
                case -2113004178: {
                    BasicSocialNetworkVisualstyle vs_pubmed = new BasicSocialNetworkVisualstyle();
                    vs_pubmed.applyVisualStyle(event.getNetwork(), socialNetwork);
                }
            }
            this.appManager.setCurrentlySelectedSocialNetwork(socialNetwork);
        }
    }
}

