/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csapps.socialnetwork.model.academia.parsers.pubmed;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.baderlab.csapps.socialnetwork.CytoscapeUtilities;
import org.baderlab.csapps.socialnetwork.model.academia.Query;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class EutilsSearchParser
extends DefaultHandler {
    boolean isQueryKey = false;
    boolean isWebEnv = false;
    boolean isTotalPubs = false;
    private StringBuilder queryKey = null;
    private StringBuilder totalPubs = null;
    private StringBuilder webEnv = null;
    private int retStart = 0;
    private int retMax = 0;
    private static final Logger logger = Logger.getLogger(EutilsSearchParser.class.getName());

    public EutilsSearchParser(Query query) {
        try {
            SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
            String url = String.format("http://eutils.ncbi.nlm.nih.gov/entrez/eutils/esearch.fcgi?db=pubmed&term=%s", query);
            saxParser.parse(url, (DefaultHandler)this);
        }
        catch (ParserConfigurationException e) {
            logger.log(Level.SEVERE, "Exception occurred", e);
            CytoscapeUtilities.notifyUser("Encountered temporary server issues. Please try again some other time.");
        }
        catch (SAXException e) {
            logger.log(Level.SEVERE, "Exception occurred", e);
            CytoscapeUtilities.notifyUser("Encountered temporary server issues. Please try again some other time.");
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Exception occurred", e);
            CytoscapeUtilities.notifyUser("Unable to connect to PubMed. Please check your internet connection.");
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.isTotalPubs) {
            this.totalPubs.append(ch, start, length);
            this.isTotalPubs = false;
        }
        if (this.isQueryKey) {
            this.queryKey.append(ch, start, length);
            this.isQueryKey = false;
        }
        if (this.isWebEnv) {
            this.webEnv.append(new String(ch, start, length));
            this.isWebEnv = false;
        }
    }

    public String getQueryKey() {
        return this.queryKey.toString();
    }

    public int getRetMax() {
        int total = this.getTotalPubs();
        this.retMax = total > 400 ? 400 : total;
        return this.retMax;
    }

    public int getRetStart() {
        return this.retStart;
    }

    public int getTotalPubs() {
        String total = this.totalPubs.toString();
        if (total != null && Pattern.matches("[0-9]+", total)) {
            return Integer.parseInt(total);
        }
        return 0;
    }

    public String getWebEnv() {
        return this.webEnv.toString();
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equalsIgnoreCase("Count") && this.totalPubs == null) {
            this.isTotalPubs = true;
            this.totalPubs = new StringBuilder();
        }
        if (qName.equalsIgnoreCase("QueryKey")) {
            this.isQueryKey = true;
            this.queryKey = new StringBuilder();
        }
        if (qName.equalsIgnoreCase("WebEnv")) {
            this.isWebEnv = true;
            this.webEnv = new StringBuilder();
        }
    }
}

