/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csapps.socialnetwork.tasks;

import java.awt.Cursor;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.baderlab.csapps.socialnetwork.CytoscapeUtilities;
import org.baderlab.csapps.socialnetwork.model.AbstractEdge;
import org.baderlab.csapps.socialnetwork.model.Collaboration;
import org.baderlab.csapps.socialnetwork.model.Interaction;
import org.baderlab.csapps.socialnetwork.model.SocialNetwork;
import org.baderlab.csapps.socialnetwork.model.SocialNetworkAppManager;
import org.baderlab.csapps.socialnetwork.model.academia.PubMed;
import org.baderlab.csapps.socialnetwork.model.academia.Publication;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskMonitor;

public class ParsePubMedXMLTask
extends AbstractTask {
    private static final Logger logger = Logger.getLogger(ParsePubMedXMLTask.class.getName());
    private SocialNetworkAppManager appManager = null;

    public ParsePubMedXMLTask(SocialNetworkAppManager appManager) {
        this.appManager = appManager;
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        taskMonitor.setTitle("Loading Network");
        String networkName = this.appManager.getNetworkName();
        SocialNetwork socialNetwork = new SocialNetwork(networkName, -2113004178);
        PubMed pubmed = new PubMed(this.appManager.getNetworkFile(), taskMonitor);
        ArrayList<Publication> pubList = pubmed.getPubList();
        socialNetwork.setPublications(pubmed.getPubList());
        if (pubList == null) {
            this.appManager.getUserPanelRef().setCursor(new Cursor(0));
            return;
        }
        Interaction interaction = new Interaction(pubList, 1249763952, this.appManager.getMaxAuthorThreshold());
        if (interaction.getExcludedPublications().size() == pubList.size()) {
            this.appManager.getUserPanelRef().setCursor(new Cursor(0));
            String message = "Network couldn't be loaded. Adjust max author threshold";
            logger.log(Level.SEVERE, message);
            CytoscapeUtilities.notifyUser(message);
            return;
        }
        socialNetwork.setExcludedPubs(interaction.getExcludedPublications());
        Map<Collaboration, ArrayList<AbstractEdge>> map = interaction.getAbstractMap();
        if (map.size() == 0) {
            this.appManager.getUserPanelRef().setCursor(new Cursor(0));
            String message = "Network couldn't be loaded. File is corrupt.";
            logger.log(Level.SEVERE, message);
            CytoscapeUtilities.notifyUser(message);
            return;
        }
        this.appManager.setMap(map);
        this.appManager.getSocialNetworkMap().put(networkName, socialNetwork);
        TaskIterator taskIterator = new TaskIterator(new Task[0]);
        taskIterator.append(this.appManager.getNetworkTaskFactoryRef().createTaskIterator());
        this.insertTasksAfterCurrentTask(taskIterator);
    }
}

