/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csapps.socialnetwork.model.academia;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.baderlab.csapps.socialnetwork.model.academia.Author;
import org.baderlab.csapps.socialnetwork.model.academia.Publication;
import org.baderlab.csapps.socialnetwork.model.academia.Query;
import org.baderlab.csapps.socialnetwork.model.academia.parsers.pubmed.EutilsRetrievalParser;
import org.baderlab.csapps.socialnetwork.model.academia.parsers.pubmed.EutilsSearchParser;
import org.baderlab.csapps.socialnetwork.model.academia.parsers.pubmed.EutilsTimesCitedParser;
import org.baderlab.csapps.socialnetwork.model.academia.parsers.pubmed.PubMedXmlParser;
import org.cytoscape.work.TaskMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PubMed {
    private ArrayList<Publication> pubList = null;

    public static HashMap<String, Object> constructPubMedAttrMap(Author author) {
        HashMap<String, Object> nodeAttrMap = new HashMap<String, Object>();
        String[] columns = new String[]{"Label", "Last Name", "First Name", "Times Cited", "Institution", "# of Publications", "Publications"};
        int i = 0;
        for (i = 0; i < 5; ++i) {
            nodeAttrMap.put(columns[i], "");
        }
        nodeAttrMap.put(columns[i], 0);
        nodeAttrMap.put(columns[++i], new ArrayList());
        return nodeAttrMap;
    }

    public PubMed(File xmlFile, TaskMonitor taskMonitor) {
        PubMedXmlParser xmlParser = new PubMedXmlParser(xmlFile, taskMonitor);
        ArrayList<Publication> pubList = xmlParser.getPubList();
        if (pubList.size() < 1) {
            return;
        }
        this.setPubList(pubList);
        this.setPmcRefCount(this.getPubList());
    }

    public PubMed(String searchTerm) {
        Query query = new Query(searchTerm);
        EutilsSearchParser eUtilsSearchParser = new EutilsSearchParser(query);
        int totalPubs = eUtilsSearchParser.getTotalPubs();
        if (totalPubs < 1) {
            return;
        }
        int retStart = eUtilsSearchParser.getRetStart();
        int retMax = eUtilsSearchParser.getRetMax();
        String queryKey = eUtilsSearchParser.getQueryKey();
        String webEnv = eUtilsSearchParser.getWebEnv();
        EutilsRetrievalParser eUtilsRetParser = new EutilsRetrievalParser(queryKey, webEnv, retStart, retMax, totalPubs);
        this.setPubList(eUtilsRetParser.getPubList());
    }

    private String getEutilsPMIDs(ArrayList<Publication> pubList) {
        Publication pub = null;
        int retStart = 0;
        int totalPubs = pubList.size();
        int retMax = totalPubs > 400 ? 400 : totalPubs;
        StringBuilder pmids = new StringBuilder();
        for (int i = retStart; i < retMax; ++i) {
            pub = pubList.get(i);
            pmids.append(pub.getPMID());
            pmids.append("[UID]");
            if (i >= retMax - 1) continue;
            pmids.append(" OR ");
        }
        return pmids.toString();
    }

    public ArrayList<Publication> getPubList() {
        return this.pubList;
    }

    private void setPmcRefCount(ArrayList<Publication> pubList) {
        Query query = new Query(this.getEutilsPMIDs(pubList));
        EutilsSearchParser eUtilsSearchParser = new EutilsSearchParser(query);
        int retStart = eUtilsSearchParser.getRetStart();
        int retMax = eUtilsSearchParser.getRetMax();
        String queryKey = eUtilsSearchParser.getQueryKey();
        String webEnv = eUtilsSearchParser.getWebEnv();
        EutilsTimesCitedParser eUtilsTimesCitedParser = new EutilsTimesCitedParser(pubList, queryKey, webEnv, retStart, retMax);
        this.setPubList(eUtilsTimesCitedParser.getPubList());
    }

    private void setPubList(ArrayList<Publication> pubList) {
        this.pubList = pubList;
    }
}

