/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csapps.socialnetwork.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyledDocument;
import org.baderlab.csapps.socialnetwork.CytoscapeUtilities;
import org.baderlab.csapps.socialnetwork.model.Category;
import org.baderlab.csapps.socialnetwork.model.SocialNetwork;
import org.baderlab.csapps.socialnetwork.model.SocialNetworkAppManager;
import org.baderlab.csapps.socialnetwork.model.visualstyles.VisualStyles;
import org.baderlab.csapps.socialnetwork.panels.AcademiaPanel;
import org.baderlab.csapps.socialnetwork.util.GenerateReports;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.application.swing.CytoPanelComponent;
import org.cytoscape.application.swing.CytoPanelName;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.util.swing.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserPanel
extends JPanel
implements CytoPanelComponent {
    private static final Logger logger = Logger.getLogger(UserPanel.class.getName());
    private JPanel controlPanelRef = null;
    private JPanel infoPanelRef = null;
    private JPanel networkPanelRef = null;
    private JTable networkTableRef = null;
    private JTextField searchBoxRef = null;
    private JComboBox<String> searchFilter = null;
    private int selectedCategory = -1;
    private String selectedNetwork = null;
    private int selectedVisualStyle = -1;
    private JPanel topPanelRef = null;
    private JButton helpButton = null;
    private JPanel visualStylePanel = null;
    private JComboBox<String> visualStyleSelector = null;
    private int visualStyleSelectorType = -1;
    private JPanel networkSummaryPanelRef = null;
    private JTextPane networkSummaryPaneRef = null;
    private JTextPane fileSummaryPaneRef = null;
    private SocialNetworkAppManager appManager = null;
    private FileUtil fileUtil = null;
    private CySwingApplication cySwingAppRef = null;
    private AcademiaPanel academiaPanel = null;

    /*
     * Enabled aggressive block sorting
     */
    public static void createNetwork(SocialNetworkAppManager appManager, boolean isSelected, String thresholdText, String searchTerm, int categoryType) {
        int threshold = -1;
        if (!isSelected) {
            appManager.createNetwork(searchTerm, categoryType, threshold);
            return;
        }
        if (!thresholdText.isEmpty() && Pattern.matches("[0-9]+", thresholdText)) {
            threshold = Integer.parseInt(thresholdText);
            if (threshold > 500) {
                CytoscapeUtilities.notifyUser("Warning! The max author threshold has been set to a value greater than 500. This may lead to computer slowdown.");
            }
            appManager.createNetwork(searchTerm, categoryType, threshold);
            return;
        }
        CytoscapeUtilities.notifyUser("Illegal input for max threshold. Please specify a valid threshold value. Threshold must be a positive integer.");
    }

    public static int getValidThreshold(boolean isSelected, String text) {
        int threshold = -1;
        if (isSelected) {
            String thresholdText = text;
            if (!thresholdText.isEmpty() && Pattern.matches("[0-9]+", thresholdText)) {
                threshold = Integer.parseInt(text);
                if (threshold > 500) {
                    CytoscapeUtilities.notifyUser("Warning! The max author threshold has been set to a value greater than 500. This may lead to computer slowdown.");
                }
            } else {
                CytoscapeUtilities.notifyUser("Illegal input for max threshold. Please specify a valid threshold value. Threshold must be a positive integer.");
            }
        }
        return threshold;
    }

    public UserPanel(SocialNetworkAppManager appManager, FileUtil fileUtil, CySwingApplication cySwingAppRef) {
        this.appManager = appManager;
        this.fileUtil = fileUtil;
        this.cySwingAppRef = cySwingAppRef;
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(400, 200));
        this.setSelectedCategory(1249763952);
        this.topPanelRef = this.createTopPanel();
        this.add((Component)this.topPanelRef, "North");
        this.academiaPanel = new AcademiaPanel(appManager, this.fileUtil, this.cySwingAppRef);
        this.setSelectedInfoPanel(this.academiaPanel.createAcademiaInfoPanel());
        this.add((Component)this.infoPanelRef, "Center");
        this.add((Component)this.createBottomPanel(), "South");
    }

    public void addNetworkToNetworkPanel(SocialNetwork socialNetwork) {
        try {
            CyNetwork network = socialNetwork.getCyNetwork();
            String networkName = socialNetwork.getNetworkName();
            int networkType = socialNetwork.getNetworkType();
            if (this.getNetworkTableRef() == null) {
                DefaultTableModel model = new DefaultTableModel();
                JTable networkTable = new JTable(model);
                networkTable.setEnabled(true);
                for (String columnName : this.appManager.getNetworkTableColumnNames()) {
                    model.addColumn(columnName);
                }
                model.addRow(new Object[]{networkName, network.getNodeCount(), network.getEdgeCount(), Category.toString(networkType)});
                this.setNetworkTableRef(networkTable);
                final JPopupMenu destroyNetworkContextMenu = new JPopupMenu();
                destroyNetworkContextMenu.add(this.createDestroyNetworkMenuItem());
                networkTable.addMouseListener(new MouseAdapter(){

                    public void mousePressed(MouseEvent e) {
                        if (e.getClickCount() == 1) {
                            JTable target = (JTable)e.getSource();
                            int row = target.getSelectedRow();
                            String networkName = (String)UserPanel.this.getNetworkTableRef().getModel().getValueAt(row, 0);
                            UserPanel.this.setSelectedNetwork(networkName);
                            UserPanel.this.changeNetworkVisualStyle(networkName);
                            UserPanel.this.appManager.setCurrentNetworkView(networkName);
                        }
                        if (e.getButton() == 3) {
                            destroyNetworkContextMenu.show(UserPanel.this.getNetworkTableRef(), e.getX(), e.getY());
                        }
                    }
                });
                JScrollPane networkTablePane = new JScrollPane(this.getNetworkTableRef());
                networkTablePane.setPreferredSize(new Dimension(200, 100));
                this.getNetworkPanelRef().add((Component)networkTablePane, "North");
                this.setNetworkSummaryPanelRef(this.createNetworkSummaryPanel(socialNetwork));
                this.getNetworkPanelRef().add((Component)this.getNetworkSummaryPanelRef(), "Center");
            } else {
                DefaultTableModel networkTableModel = (DefaultTableModel)this.getNetworkTableRef().getModel();
                networkTableModel.addRow(new Object[]{networkName, network.getNodeCount(), network.getEdgeCount(), Category.toString(networkType)});
            }
            this.updateNetworkSummaryPanel(socialNetwork);
            this.addNetworkVisualStyle(socialNetwork);
            this.getNetworkPanelRef().revalidate();
            this.getNetworkPanelRef().repaint();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception occurred", e);
            CytoscapeUtilities.notifyUser(String.format("An error occurred while adding %s to the network table", socialNetwork.getNetworkName()));
        }
    }

    public void addNetworkVisualStyle(SocialNetwork socialNetwork) {
        int visualStyleType = -1;
        String networkName = "DEFAULT";
        if (socialNetwork != null) {
            visualStyleType = socialNetwork.getDefaultVisualStyle();
            networkName = socialNetwork.getNetworkName();
        }
        if (this.getVisualStylePanel() == null) {
            this.setVisualStylePanel(this.createVisualStylePanel(networkName));
            this.setVisualStyleSelectorType(visualStyleType);
            this.setVisualStyleSelector(this.createVisualStyleSelector(visualStyleType));
            this.getVisualStylePanel().add(this.getVisualStyleSelector());
            this.setVisualStyleHelpButton(this.createHelpButton());
            this.getVisualStylePanel().add(this.getVisualStyleHelpButton());
            this.getNetworkPanelRef().add((Component)this.getVisualStylePanel(), "South");
        } else {
            this.changeNetworkVisualStyle(networkName);
        }
    }

    public void changeNetworkVisualStyle(String networkName) {
        int visualStyleType = this.appManager.getSocialNetworkMap().get(networkName).getDefaultVisualStyle();
        TitledBorder visualStylePanelBorder = (TitledBorder)this.getVisualStylePanel().getBorder();
        if (networkName.length() >= 35) {
            networkName = networkName.substring(0, 34) + "...";
        }
        visualStylePanelBorder.setTitle(networkName + " Visual Styles");
        this.swapVisualStyleSelector(visualStyleType);
        this.getVisualStylePanel().revalidate();
        this.getVisualStylePanel().repaint();
    }

    private JPanel createBottomPanel() {
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BorderLayout());
        this.setNetworkPanelRef(this.createNetworkPanel());
        bottomPanel.add((Component)this.getNetworkPanelRef(), "North");
        this.setControlPanelRef(this.createControlPanel());
        bottomPanel.add((Component)this.getControlPanelRef(), "South");
        return bottomPanel;
    }

    private JComboBox<String> createCategoryOptionSelector() {
        JComboBox<String> categoryOptionSelector = new JComboBox<String>(Category.getCategoryList());
        categoryOptionSelector.setEditable(false);
        categoryOptionSelector.setAlignmentX(0.0f);
        categoryOptionSelector.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JComboBox jcmbType = (JComboBox)e.getSource();
                String category = (String)jcmbType.getSelectedItem();
                UserPanel.this.setSelectedCategory(Category.getCategoryID(category));
                if (!category.trim().equalsIgnoreCase(UserPanel.this.appManager.getUserPanelRef().getSelectedInfoPanel().getName())) {
                    UserPanel.this.appManager.getUserPanelRef().performInfoPanelSwitch();
                }
                UserPanel.this.getSearchFilter().setModel(new DefaultComboBoxModel<String>(Category.getSearchFilterList(UserPanel.this.getSelectedCategory())));
            }
        });
        return categoryOptionSelector;
    }

    private JButton createCloseButton() {
        JButton closeButton = new JButton("Close");
        closeButton.setToolTipText("Close Social Network Panel");
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                UserPanel.this.appManager.closeUserPanel();
            }
        });
        return closeButton;
    }

    private JPanel createControlPanel() {
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new FlowLayout());
        controlPanel.add(this.createResetButton());
        controlPanel.add(this.createCloseButton());
        return controlPanel;
    }

    public JMenuItem createDestroyNetworkMenuItem() {
        JMenuItem destroyNetworkMenuItem = new JMenuItem("Destroy Network");
        destroyNetworkMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                String selectedNetwork = UserPanel.this.getSelectedNetwork();
                UserPanel.this.appManager.destroyNetwork(UserPanel.this.appManager.getSocialNetworkMap().get(selectedNetwork).getCyNetwork());
            }
        });
        return destroyNetworkMenuItem;
    }

    private JButton createHelpButton() {
        URL iconURL = this.getClass().getClassLoader().getResource("help.png");
        ImageIcon iconSearch = new ImageIcon(iconURL);
        JButton helpButton = new JButton(iconSearch);
        helpButton.setBorder(null);
        helpButton.setContentAreaFilled(false);
        helpButton.setToolTipText("Visual Style Help");
        helpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                switch (UserPanel.this.getVisualStyleSelectorType()) {
                    case -1: {
                        UserPanel.this.help("Default visual style", VisualStyles.getHelpMessage(-1));
                        break;
                    }
                    case 1410511959: {
                        UserPanel.this.help("InCites Visual Style", VisualStyles.getHelpMessage(1410511959));
                        break;
                    }
                    case -2113004178: {
                        UserPanel.this.help("PubMed Visual Style", VisualStyles.getHelpMessage(-2113004178));
                        break;
                    }
                    case -960949447: {
                        UserPanel.this.help("Scopus Visual Style", VisualStyles.getHelpMessage(-960949447));
                    }
                }
            }
        });
        return helpButton;
    }

    private JPanel createNetworkPanel() {
        JPanel networkPanel = new JPanel();
        networkPanel.setBorder(BorderFactory.createTitledBorder("Social Network"));
        networkPanel.setLayout(new BorderLayout());
        return networkPanel;
    }

    public JPanel createNetworkSummaryPanel(SocialNetwork socialNetwork) {
        JPanel networkSummaryPanel = new JPanel();
        networkSummaryPanel.setLayout(new BorderLayout());
        JTextPane networkSummaryPane = new JTextPane();
        networkSummaryPane.setContentType("text/html");
        networkSummaryPane.setEditable(false);
        networkSummaryPane.setAutoscrolls(true);
        this.setNetworkSummaryPaneRef(networkSummaryPane);
        JTextPane fileSummaryPane = new JTextPane();
        fileSummaryPane.setContentType("text/html");
        fileSummaryPane.setEditable(false);
        fileSummaryPane.setAutoscrolls(true);
        this.setFileSummaryPaneRef(fileSummaryPane);
        JPanel summaryPanel = new JPanel();
        summaryPanel.setLayout(new BorderLayout());
        summaryPanel.add((Component)networkSummaryPane, "North");
        summaryPanel.add((Component)fileSummaryPane, "South");
        JScrollPane wrapperPane = new JScrollPane();
        wrapperPane.getViewport().add(summaryPanel);
        wrapperPane.setPreferredSize(new Dimension(50, 100));
        networkSummaryPanel.add((Component)wrapperPane, "North");
        return networkSummaryPanel;
    }

    private JButton createResetButton() {
        JButton resetButton = new JButton("Reset");
        resetButton.setToolTipText("Reset");
        resetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                UserPanel.this.appManager.getUserPanelRef().performInfoPanelSwitch();
            }
        });
        return resetButton;
    }

    private JTextField createSearchBox() {
        JTextField searchBox = new JTextField();
        searchBox.setEditable(true);
        searchBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (UserPanel.this.getSearchBox().getText().trim().isEmpty()) {
                    CytoscapeUtilities.notifyUser("Please enter a search term into the search box");
                } else if (!UserPanel.this.isValidInput(UserPanel.this.getSearchBox().getText().trim())) {
                    CytoscapeUtilities.notifyUser("Illegal characters present. Please enter a valid search term.");
                } else {
                    UserPanel.createNetwork(UserPanel.this.appManager, true, UserPanel.this.getAcademiaPanel().getThresholdTextAreaRef().getText().trim(), UserPanel.this.getSearchBox().getText().trim(), UserPanel.this.getSelectedCategory());
                }
            }
        });
        return searchBox;
    }

    private JButton createSearchButton() {
        URL iconURL = this.getClass().getClassLoader().getResource("search.png");
        ImageIcon iconSearch = new ImageIcon(iconURL);
        JButton searchButton = new JButton(iconSearch);
        searchButton.setToolTipText("Search");
        searchButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (UserPanel.this.getSearchBox().getText().trim().isEmpty()) {
                    CytoscapeUtilities.notifyUser("Please enter a search term");
                } else if (!UserPanel.this.isValidInput(UserPanel.this.getSearchBox().getText().trim())) {
                    CytoscapeUtilities.notifyUser("Illegal characters present. Please enter a valid search term.");
                } else {
                    UserPanel.createNetwork(UserPanel.this.appManager, true, UserPanel.this.getAcademiaPanel().getThresholdTextAreaRef().getText().trim(), UserPanel.this.getSearchBox().getText().trim(), UserPanel.this.getSelectedCategory());
                }
            }
        });
        return searchButton;
    }

    private JComboBox createSearchFilter() {
        JComboBox<String> searchOptionSelector = new JComboBox<String>(Category.getSearchFilterList(this.getSelectedCategory()));
        searchOptionSelector.setEditable(false);
        searchOptionSelector.setAlignmentX(0.0f);
        searchOptionSelector.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
            }
        });
        return searchOptionSelector;
    }

    private JPanel createSearchPanel() {
        JPanel searchPanel = new JPanel();
        searchPanel.setLayout(new BoxLayout(searchPanel, 0));
        searchPanel.setBorder(BorderFactory.createTitledBorder("PubMed Search"));
        this.setSearchBox(this.createSearchBox());
        searchPanel.add(this.getSearchBox());
        searchPanel.add(this.createSearchButton());
        return searchPanel;
    }

    private JPanel createTopPanel() {
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BorderLayout());
        topPanel.add((Component)this.createSearchPanel(), "South");
        return topPanel;
    }

    public JPanel createVisualStylePanel(String networkName) {
        JPanel visualStylePanel = new JPanel();
        visualStylePanel.setBorder(BorderFactory.createTitledBorder(networkName + " Visual Styles"));
        visualStylePanel.setLayout(new BoxLayout(visualStylePanel, 0));
        return visualStylePanel;
    }

    public JComboBox<String> createVisualStyleSelector(int visualStyleSelectorType) {
        JComboBox<String> visualStyleSelector = new JComboBox<String>(new VisualStyles().getVisualStyleList(visualStyleSelectorType));
        visualStyleSelector.setEditable(false);
        visualStyleSelector.setAlignmentX(0.0f);
        visualStyleSelector.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JComboBox jcmbType = (JComboBox)e.getSource();
                String visualStyle = (String)jcmbType.getSelectedItem();
                int visualStyleID = new VisualStyles().getVisualStyleID(visualStyle);
                UserPanel.this.setSelectedVisualStyle(visualStyleID);
                UserPanel.this.appManager.applyVisualStyle(visualStyle);
            }
        });
        return visualStyleSelector;
    }

    public AcademiaPanel getAcademiaPanel() {
        return this.academiaPanel;
    }

    public Component getComponent() {
        return this;
    }

    private JPanel getControlPanelRef() {
        return this.controlPanelRef;
    }

    public CytoPanelName getCytoPanelName() {
        return CytoPanelName.WEST;
    }

    public JTextPane getFileSummaryPaneRef() {
        return this.fileSummaryPaneRef;
    }

    public Icon getIcon() {
        URL iconURL = this.getClass().getResource("socialNetwork_logo_small.png");
        ImageIcon EMIcon = null;
        if (iconURL != null) {
            EMIcon = new ImageIcon(iconURL);
        }
        return EMIcon;
    }

    public JPanel getNetworkPanelRef() {
        return this.networkPanelRef;
    }

    private JPanel getNetworkSummaryPanelRef() {
        return this.networkSummaryPanelRef;
    }

    public JTextPane getNetworkSummaryPaneRef() {
        return this.networkSummaryPaneRef;
    }

    public JTable getNetworkTableRef() {
        return this.networkTableRef;
    }

    public JTextField getSearchBox() {
        return this.searchBoxRef;
    }

    private JComboBox<String> getSearchFilter() {
        return this.searchFilter;
    }

    public int getSelectedCategory() {
        return this.selectedCategory;
    }

    private JPanel getSelectedInfoPanel() {
        return this.infoPanelRef;
    }

    public String getSelectedNetwork() {
        return this.selectedNetwork;
    }

    private int getSelectedVisualStyle() {
        return this.selectedVisualStyle;
    }

    public String getTitle() {
        return "Social Network";
    }

    public JButton getVisualStyleHelpButton() {
        return this.helpButton;
    }

    public JPanel getVisualStylePanel() {
        return this.visualStylePanel;
    }

    public JComboBox<String> getVisualStyleSelector() {
        return this.visualStyleSelector;
    }

    public int getVisualStyleSelectorType() {
        return this.visualStyleSelectorType;
    }

    private void help(String dialogTitle, String helpInfo) {
        String formatting = "<html><body style='width: 300px'>";
        JFrame frame = new JFrame();
        JOptionPane.showMessageDialog(frame, formatting + helpInfo, dialogTitle, 3);
    }

    private boolean isValidInput(String input) {
        Pattern pattern = Pattern.compile("[!@#$%^&*~]+?");
        Matcher matcher = pattern.matcher(input);
        return !matcher.find();
    }

    private void performInfoPanelSwitch() {
        this.remove(this.getSelectedInfoPanel());
        switch (this.getSelectedCategory()) {
            case -1: {
                this.setSelectedInfoPanel(Category.createDefaultInfoPanel());
                break;
            }
            case 1249763952: {
                this.setSelectedInfoPanel(this.academiaPanel.createAcademiaInfoPanel());
                break;
            }
            case -952396249: {
                this.setSelectedInfoPanel(Category.createTwitterInfoPanel());
                break;
            }
            case -667618736: {
                this.setSelectedInfoPanel(Category.createLinkedInInfoPanel());
                break;
            }
            case 1249763941: {
                this.setSelectedInfoPanel(Category.createYoutubeInfoPanel());
            }
        }
        this.add((Component)this.getSelectedInfoPanel(), "Center");
        this.revalidate();
        this.repaint();
    }

    public void setAcademiaPanel(AcademiaPanel academiaPanel) {
        this.academiaPanel = academiaPanel;
    }

    private void setControlPanelRef(JPanel controlPanelRef) {
        this.controlPanelRef = controlPanelRef;
    }

    public void setFileSummaryPaneRef(JTextPane fileSummaryPaneRef) {
        this.fileSummaryPaneRef = fileSummaryPaneRef;
    }

    private void setNetworkPanelRef(JPanel networkPanelRef) {
        this.networkPanelRef = networkPanelRef;
    }

    private void setNetworkSummaryPanelRef(JPanel networkSummaryPanel) {
        this.networkSummaryPanelRef = networkSummaryPanel;
    }

    public void setNetworkSummaryPaneRef(JTextPane networkSummaryPaneRef) {
        this.networkSummaryPaneRef = networkSummaryPaneRef;
    }

    public void setNetworkTableRef(JTable networkTableRef) {
        this.networkTableRef = networkTableRef;
    }

    public void setSearchBox(JTextField searchBox) {
        this.searchBoxRef = searchBox;
    }

    private void setSearchFilter(JComboBox<String> searchOptionSelector) {
        this.searchFilter = searchOptionSelector;
    }

    private void setSelectedCategory(int category) {
        this.selectedCategory = category;
    }

    private void setSelectedInfoPanel(JPanel infoPanel) {
        this.infoPanelRef = infoPanel;
    }

    public void setSelectedNetwork(String network) {
        this.selectedNetwork = network;
    }

    public void setSelectedVisualStyle(int visualStyle) {
        this.selectedVisualStyle = visualStyle;
    }

    public void setVisualStyleHelpButton(JButton visualStyleHelpButton) {
        this.helpButton = visualStyleHelpButton;
    }

    public void setVisualStylePanel(JPanel visualStylePanel) {
        this.visualStylePanel = visualStylePanel;
    }

    public void setVisualStyleSelector(JComboBox<String> visualStyleSelector) {
        this.visualStyleSelector = visualStyleSelector;
    }

    public void setVisualStyleSelectorType(int visualStyleType) {
        this.visualStyleSelectorType = visualStyleType;
    }

    public void swapVisualStyleSelector(int visualStyleSelectorType) {
        if (this.getVisualStyleSelectorType() != visualStyleSelectorType) {
            this.getVisualStylePanel().remove(this.getVisualStyleSelector());
            this.getVisualStylePanel().remove(this.getVisualStyleHelpButton());
            this.setVisualStyleSelectorType(visualStyleSelectorType);
            this.setVisualStyleSelector(this.createVisualStyleSelector(this.getVisualStyleSelectorType()));
            this.getVisualStylePanel().add(this.getVisualStyleSelector());
            this.getVisualStylePanel().add(this.getVisualStyleHelpButton());
        }
    }

    public void updateNetworkSummaryPanel(SocialNetwork socialNetwork) {
        String networkName = "DEFAULT";
        String networkSummary = "N/A";
        if (socialNetwork != null) {
            networkName = socialNetwork.getNetworkName();
            if (networkName.length() >= 10) {
                networkName = networkName.substring(0, 9) + " ...";
            }
            networkSummary = socialNetwork.getNetworkSummary();
        }
        this.getNetworkSummaryPanelRef().setBorder(BorderFactory.createTitledBorder(networkName + " Summary"));
        this.getNetworkSummaryPaneRef().setText(networkSummary);
        this.getFileSummaryPaneRef().setText("");
        GenerateReports gr = new GenerateReports(socialNetwork);
        HashMap<Object, Object> files = new HashMap();
        switch (socialNetwork.getNetworkType()) {
            case 1410511959: {
                files = gr.createIncitesReports();
                break;
            }
            case -2113004178: {
                if (socialNetwork.getExcludedPubs().size() <= 0) break;
                files = gr.createPubmedReports();
                break;
            }
            case -960949447: {
                if (socialNetwork.getExcludedPubs().size() <= 0) break;
                files = gr.createScopusReports();
                break;
            }
        }
        if (files.size() > 0) {
            Object[] keys = files.keySet().toArray();
            Arrays.sort(keys);
            StyledDocument doc = this.getFileSummaryPaneRef().getStyledDocument();
            SimpleAttributeSet attr = new SimpleAttributeSet();
            JLabel header = new JLabel("List of summary files:");
            this.getFileSummaryPaneRef().insertComponent(header);
            try {
                doc.insertString(doc.getLength(), "\n", attr);
            }
            catch (BadLocationException e2) {
                e2.printStackTrace();
            }
            for (Object key : keys) {
                JLabel websiteLabel = new JLabel();
                final File url = new File((String)files.get(key));
                websiteLabel.setText("<html><a href=\"\">" + key + "</a><br></html>");
                websiteLabel.setCursor(new Cursor(12));
                websiteLabel.addMouseListener(new MouseAdapter(){

                    public void mouseClicked(MouseEvent e) {
                        try {
                            Desktop.getDesktop().open(url);
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                    }
                });
                this.getFileSummaryPaneRef().setCaretPosition(this.getFileSummaryPaneRef().getDocument().getLength());
                this.getFileSummaryPaneRef().insertComponent(websiteLabel);
                try {
                    doc.insertString(doc.getLength(), "\n", attr);
                }
                catch (BadLocationException e1) {
                    e1.printStackTrace();
                }
            }
        }
        this.getNetworkSummaryPanelRef().revalidate();
        this.getNetworkSummaryPanelRef().repaint();
    }
}

