/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csapps.socialnetwork.tasks;

import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.baderlab.csapps.socialnetwork.model.SocialNetworkAppManager;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.view.vizmap.VisualMappingFunction;
import org.cytoscape.view.vizmap.VisualMappingFunctionFactory;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.VisualStyleFactory;
import org.cytoscape.view.vizmap.mappings.BoundaryRangeValues;
import org.cytoscape.view.vizmap.mappings.ContinuousMapping;
import org.cytoscape.view.vizmap.mappings.DiscreteMapping;
import org.cytoscape.view.vizmap.mappings.PassthroughMapping;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;

public class ApplyVisualStyleTask
extends AbstractTask {
    private VisualMappingManager vmmServiceRef;
    private VisualStyleFactory visualStyleFactoryServiceRef;
    private VisualMappingFunctionFactory passthroughMappingFactoryServiceRef;
    private VisualMappingFunctionFactory continuousMappingFactoryServiceRef;
    private VisualMappingFunctionFactory discreteMappingFactoryServiceRef;
    private TaskMonitor taskMonitor;
    SocialNetworkAppManager appManager = null;

    public ApplyVisualStyleTask(VisualStyleFactory visualStyleFactoryServiceRef, VisualMappingManager vmmServiceRef, VisualMappingFunctionFactory passthroughMappingFactoryServiceRef, VisualMappingFunctionFactory continuousMappingFactoryServiceRef, VisualMappingFunctionFactory discreteMappingFactoryServiceRef, SocialNetworkAppManager appManager) {
        this.vmmServiceRef = vmmServiceRef;
        this.visualStyleFactoryServiceRef = visualStyleFactoryServiceRef;
        this.passthroughMappingFactoryServiceRef = passthroughMappingFactoryServiceRef;
        this.discreteMappingFactoryServiceRef = discreteMappingFactoryServiceRef;
        this.continuousMappingFactoryServiceRef = continuousMappingFactoryServiceRef;
        this.appManager = appManager;
    }

    private VisualStyle addEdgeLabels(VisualStyle visualStyle) {
        String colName = (String)this.appManager.getCurrentlySelectedSocialNetwork().getVisualStyleMap().get(BasicVisualLexicon.EDGE_LABEL)[0];
        PassthroughMapping mapping = (PassthroughMapping)this.passthroughMappingFactoryServiceRef.createVisualMappingFunction(colName, Integer.class, BasicVisualLexicon.EDGE_LABEL);
        visualStyle.addVisualMappingFunction((VisualMappingFunction)mapping);
        return visualStyle;
    }

    private VisualStyle addNodeLabels(VisualStyle visualStyle) {
        String colName = (String)this.appManager.getCurrentlySelectedSocialNetwork().getVisualStyleMap().get(BasicVisualLexicon.NODE_LABEL)[0];
        PassthroughMapping mapping = (PassthroughMapping)this.passthroughMappingFactoryServiceRef.createVisualMappingFunction(colName, Integer.class, BasicVisualLexicon.NODE_LABEL);
        visualStyle.addVisualMappingFunction((VisualMappingFunction)mapping);
        return visualStyle;
    }

    private VisualStyle createIncitesVisualStyle() {
        VisualStyle incitesVisualStyle = this.visualStyleFactoryServiceRef.createVisualStyle("InCites");
        this.addNodeLabels(incitesVisualStyle);
        this.modifyEdgeWidth(incitesVisualStyle);
        this.modifyNodeSize(incitesVisualStyle);
        this.modifyEdgeOpacity(incitesVisualStyle);
        this.modifyNodeColor(incitesVisualStyle);
        this.modifyNodeBorder(incitesVisualStyle);
        this.modifyNodeShape(incitesVisualStyle);
        return incitesVisualStyle;
    }

    private VisualStyle createPubmedVisualStyle() {
        VisualStyle pubmedVisualStyle = this.visualStyleFactoryServiceRef.createVisualStyle("PubMed");
        this.addNodeLabels(pubmedVisualStyle);
        this.modifyNodeSize(pubmedVisualStyle);
        this.modifyEdgeWidth(pubmedVisualStyle);
        this.modifyEdgeOpacity(pubmedVisualStyle);
        return pubmedVisualStyle;
    }

    private VisualStyle createScopusVisualStyle() {
        VisualStyle scopusVisualStyle = this.visualStyleFactoryServiceRef.createVisualStyle("Scopus");
        this.addNodeLabels(scopusVisualStyle);
        this.modifyNodeSize(scopusVisualStyle);
        this.modifyEdgeWidth(scopusVisualStyle);
        this.modifyEdgeOpacity(scopusVisualStyle);
        return scopusVisualStyle;
    }

    private VisualStyle getDefaultVisualStyle() {
        VisualStyle defaultVisualStyle = this.getVisualStyle("Default");
        if (defaultVisualStyle == null) {
            defaultVisualStyle = this.visualStyleFactoryServiceRef.createVisualStyle("Default");
            this.vmmServiceRef.addVisualStyle(defaultVisualStyle);
        }
        return defaultVisualStyle;
    }

    private VisualStyle getIncitesStyle() {
        VisualStyle incitesVisualStyle = this.getVisualStyle("InCites");
        if (incitesVisualStyle == null) {
            incitesVisualStyle = this.createIncitesVisualStyle();
            this.vmmServiceRef.addVisualStyle(incitesVisualStyle);
        }
        return incitesVisualStyle;
    }

    private VisualStyle getPubmedVisualStyle() {
        VisualStyle pubmedVisualStyle = this.getVisualStyle("PubMed");
        if (pubmedVisualStyle == null) {
            pubmedVisualStyle = this.createPubmedVisualStyle();
            this.vmmServiceRef.addVisualStyle(pubmedVisualStyle);
        }
        return pubmedVisualStyle;
    }

    private VisualStyle getScopusVisualStyle() {
        VisualStyle scopusVisualStyle = this.getVisualStyle("Scopus");
        if (scopusVisualStyle == null) {
            scopusVisualStyle = this.createScopusVisualStyle();
            this.vmmServiceRef.addVisualStyle(scopusVisualStyle);
        }
        return scopusVisualStyle;
    }

    private TaskMonitor getTaskMonitor() {
        return this.taskMonitor;
    }

    private VisualStyle getVisualStyle(String name) {
        Iterator it = this.vmmServiceRef.getAllVisualStyles().iterator();
        VisualStyle visualStyle = null;
        while (it.hasNext() && !(visualStyle = (VisualStyle)it.next()).getTitle().equalsIgnoreCase(name)) {
            visualStyle = null;
        }
        return visualStyle;
    }

    private VisualStyle modifyEdgeOpacity(VisualStyle visualStyle) {
        String colName = (String)this.appManager.getCurrentlySelectedSocialNetwork().getVisualStyleMap().get(BasicVisualLexicon.EDGE_TRANSPARENCY)[0];
        ContinuousMapping mapping = (ContinuousMapping)this.continuousMappingFactoryServiceRef.createVisualMappingFunction(colName, Integer.class, BasicVisualLexicon.EDGE_TRANSPARENCY);
        Object[] attributes = this.appManager.getCurrentlySelectedSocialNetwork().getVisualStyleMap().get(BasicVisualLexicon.EDGE_WIDTH);
        BoundaryRangeValues bv0 = new BoundaryRangeValues((Object)100.0, (Object)100.0, (Object)100.0);
        BoundaryRangeValues bv1 = new BoundaryRangeValues((Object)300.0, (Object)300.0, (Object)300.0);
        Integer min = (Integer)attributes[1];
        Integer max = (Integer)attributes[2];
        mapping.addPoint((Object)1, bv0);
        mapping.addPoint((Object)(max / 2), bv1);
        visualStyle.addVisualMappingFunction((VisualMappingFunction)mapping);
        return visualStyle;
    }

    private VisualStyle modifyEdgeWidth(VisualStyle visualStyle) {
        Object[] attributes = this.appManager.getCurrentlySelectedSocialNetwork().getVisualStyleMap().get(BasicVisualLexicon.EDGE_WIDTH);
        String colName = (String)attributes[0];
        ContinuousMapping mapping = (ContinuousMapping)this.continuousMappingFactoryServiceRef.createVisualMappingFunction(colName, Integer.class, BasicVisualLexicon.EDGE_WIDTH);
        BoundaryRangeValues bv0 = new BoundaryRangeValues((Object)1.0, (Object)1.0, (Object)1.0);
        BoundaryRangeValues bv1 = new BoundaryRangeValues((Object)10.0, (Object)10.0, (Object)10.0);
        int min = (Integer)attributes[1];
        int max = (Integer)attributes[2];
        mapping.addPoint((Object)min, bv0);
        mapping.addPoint((Object)max, bv1);
        visualStyle.addVisualMappingFunction((VisualMappingFunction)mapping);
        return visualStyle;
    }

    private VisualStyle modifyNodeBorder(VisualStyle visualStyle) {
        DiscreteMapping mapping = null;
        Object[] tempVar = this.appManager.getCurrentlySelectedSocialNetwork().getVisualStyleMap().get(BasicVisualLexicon.NODE_BORDER_PAINT);
        Map colorMap = (Map)tempVar[0];
        for (Map.Entry entry : colorMap.entrySet()) {
            String string = (String)entry.getKey();
            mapping = (DiscreteMapping)this.discreteMappingFactoryServiceRef.createVisualMappingFunction(string, String.class, BasicVisualLexicon.NODE_BORDER_PAINT);
            for (Map.Entry entry2 : ((HashMap)entry.getValue()).entrySet()) {
                mapping.putMapValue(entry2.getKey(), entry2.getValue());
            }
            visualStyle.addVisualMappingFunction((VisualMappingFunction)mapping);
        }
        tempVar = this.appManager.getCurrentlySelectedSocialNetwork().getVisualStyleMap().get(BasicVisualLexicon.NODE_BORDER_WIDTH);
        Map sizeMap = (Map)tempVar[0];
        for (Map.Entry entry : sizeMap.entrySet()) {
            String colName = (String)entry.getKey();
            mapping = (DiscreteMapping)this.discreteMappingFactoryServiceRef.createVisualMappingFunction(colName, String.class, BasicVisualLexicon.NODE_BORDER_WIDTH);
            for (Map.Entry entry3 : ((HashMap)entry.getValue()).entrySet()) {
                mapping.putMapValue(entry3.getKey(), entry3.getValue());
            }
            visualStyle.addVisualMappingFunction((VisualMappingFunction)mapping);
        }
        tempVar = this.appManager.getCurrentlySelectedSocialNetwork().getVisualStyleMap().get(BasicVisualLexicon.NODE_LABEL_FONT_FACE);
        Map map = (Map)tempVar[0];
        for (Map.Entry fontMapEntry : map.entrySet()) {
            String string = (String)fontMapEntry.getKey();
            mapping = (DiscreteMapping)this.discreteMappingFactoryServiceRef.createVisualMappingFunction(string, String.class, BasicVisualLexicon.NODE_LABEL_FONT_FACE);
            for (Map.Entry attrMapEntry : ((HashMap)fontMapEntry.getValue()).entrySet()) {
                mapping.putMapValue(attrMapEntry.getKey(), attrMapEntry.getValue());
            }
            visualStyle.addVisualMappingFunction((VisualMappingFunction)mapping);
        }
        return visualStyle;
    }

    private VisualStyle modifyNodeColor(VisualStyle visualStyle) {
        visualStyle.setDefaultValue(BasicVisualLexicon.NODE_FILL_COLOR, (Object)new Color(0, 204, 204));
        DiscreteMapping mapping = null;
        Object[] tempVar = this.appManager.getCurrentlySelectedSocialNetwork().getVisualStyleMap().get(BasicVisualLexicon.NODE_FILL_COLOR);
        Map colorMap = (Map)tempVar[0];
        for (Map.Entry colorMapEntry : colorMap.entrySet()) {
            String colName = (String)colorMapEntry.getKey();
            mapping = (DiscreteMapping)this.discreteMappingFactoryServiceRef.createVisualMappingFunction(colName, String.class, BasicVisualLexicon.NODE_FILL_COLOR);
            for (Map.Entry attrMapEntry : ((HashMap)colorMapEntry.getValue()).entrySet()) {
                mapping.putMapValue(attrMapEntry.getKey(), attrMapEntry.getValue());
            }
            visualStyle.addVisualMappingFunction((VisualMappingFunction)mapping);
        }
        return visualStyle;
    }

    private VisualStyle modifyNodeShape(VisualStyle visualStyle) {
        DiscreteMapping mapping = null;
        Object[] tempVar = this.appManager.getCurrentlySelectedSocialNetwork().getVisualStyleMap().get(BasicVisualLexicon.NODE_SHAPE);
        Map nodeShapeMap = (Map)tempVar[0];
        for (Map.Entry colorMapEntry : nodeShapeMap.entrySet()) {
            String colName = (String)colorMapEntry.getKey();
            mapping = (DiscreteMapping)this.discreteMappingFactoryServiceRef.createVisualMappingFunction(colName, String.class, BasicVisualLexicon.NODE_SHAPE);
            for (Map.Entry attrMapEntry : ((HashMap)colorMapEntry.getValue()).entrySet()) {
                mapping.putMapValue(attrMapEntry.getKey(), attrMapEntry.getValue());
            }
            visualStyle.addVisualMappingFunction((VisualMappingFunction)mapping);
        }
        return visualStyle;
    }

    private VisualStyle modifyNodeSize(VisualStyle visualStyle) {
        Object[] attributes = this.appManager.getCurrentlySelectedSocialNetwork().getVisualStyleMap().get(BasicVisualLexicon.NODE_SIZE);
        String colName = (String)attributes[0];
        ContinuousMapping mapping = (ContinuousMapping)this.continuousMappingFactoryServiceRef.createVisualMappingFunction(colName, Integer.class, BasicVisualLexicon.NODE_SIZE);
        BoundaryRangeValues bv0 = new BoundaryRangeValues((Object)10.0, (Object)10.0, (Object)10.0);
        BoundaryRangeValues bv1 = new BoundaryRangeValues((Object)50.0, (Object)50.0, (Object)50.0);
        int min = (Integer)attributes[1];
        int max = (Integer)attributes[2];
        mapping.addPoint((Object)min, bv0);
        mapping.addPoint((Object)max, bv1);
        visualStyle.addVisualMappingFunction((VisualMappingFunction)mapping);
        return visualStyle;
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        this.setTaskMonitor(taskMonitor);
        Set visualStyles = this.vmmServiceRef.getAllVisualStyles();
        VisualStyle visualStyle = null;
        switch (this.appManager.getVisualStyleID()) {
            case -1: {
                visualStyle = this.getDefaultVisualStyle();
                break;
            }
            case 1410511959: {
                this.getTaskMonitor().setTitle("Loading InCites Visual Style ... ");
                this.getTaskMonitor().setProgress(0.0);
                this.getTaskMonitor().setStatusMessage("");
                visualStyle = this.getIncitesStyle();
                break;
            }
            case -2113004178: {
                this.getTaskMonitor().setTitle("Loading PubMed Visual Style ... ");
                this.getTaskMonitor().setProgress(0.0);
                this.getTaskMonitor().setStatusMessage("");
                visualStyle = this.getPubmedVisualStyle();
                break;
            }
            case -960949447: {
                this.getTaskMonitor().setTitle("Loading Scopus Visual Style ... ");
                this.getTaskMonitor().setProgress(0.0);
                this.getTaskMonitor().setStatusMessage("");
                visualStyle = this.getScopusVisualStyle();
            }
        }
        this.vmmServiceRef.setCurrentVisualStyle(visualStyle);
    }

    private void setTaskMonitor(TaskMonitor taskMonitor) {
        this.taskMonitor = taskMonitor;
    }
}

