/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csapps.socialnetwork.util;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.baderlab.csapps.socialnetwork.CytoscapeUtilities;
import org.baderlab.csapps.socialnetwork.model.SocialNetwork;
import org.baderlab.csapps.socialnetwork.model.academia.Author;
import org.baderlab.csapps.socialnetwork.model.academia.Publication;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenerateReports {
    private static final Logger logger = Logger.getLogger(GenerateReports.class.getName());
    private ArrayList<Publication> publications = null;
    private ArrayList<Publication> excludedPubs = null;
    private String outputDir = "";
    private String networkName = "";
    private HashMap<String, Integer> pubByLocation = new HashMap();
    private HashMap<String, Integer> pubByLocation_unique = new HashMap();
    private HashMap<String, Integer> pubByLocation_distinct = new HashMap();
    private HashMap<String, Integer> citationsByLocation = new HashMap();
    private HashMap<String, Integer> citationsByLocation_unique = new HashMap();
    private HashMap<String, Integer> citationsByLocation_distinct = new HashMap();

    public GenerateReports(SocialNetwork network) {
        this.publications = network.getPublications();
        this.networkName = network.getNetworkName();
        if (network.getNetworkName().length() > 10) {
            this.networkName = network.getNetworkName().substring(0, 9);
        }
        this.excludedPubs = network.getExcludedPubs();
        this.outputDir = System.getProperty("java.io.tmpdir");
    }

    public GenerateReports(SocialNetwork network, String outputDir) {
        this.publications = network.getPublications();
        this.networkName = network.getNetworkName();
        this.excludedPubs = network.getExcludedPubs();
        this.outputDir = outputDir;
    }

    private void calculateTotals() {
        HashMap<String, Integer> pubs_summary = new HashMap<String, Integer>();
        HashMap<String, Integer> citations_summary = new HashMap<String, Integer>();
        if (this.publications != null) {
            for (Publication pub : this.publications) {
                for (Author author : pub.getAuthorList()) {
                    String current_location = pub.getLocation();
                    if (pubs_summary.containsKey(current_location) && citations_summary.containsKey(current_location)) {
                        Integer pub_count = (Integer)pubs_summary.get(current_location) + 1;
                        pubs_summary.put(current_location, pub_count);
                        Integer cit_count = (Integer)citations_summary.get(current_location) + pub.getTimesCited();
                        citations_summary.put(current_location, cit_count);
                        continue;
                    }
                    pubs_summary.put(current_location, 1);
                    citations_summary.put(current_location, pub.getTimesCited());
                }
            }
        }
        this.citationsByLocation = citations_summary;
        this.pubByLocation = pubs_summary;
    }

    private void calculateTotals_distinct() {
        HashMap<String, Integer> pubs_summary = new HashMap<String, Integer>();
        HashMap<String, Integer> citations_summary = new HashMap<String, Integer>();
        if (this.publications != null) {
            for (Publication pub : this.publications) {
                HashSet<String> all_locations = new HashSet<String>();
                for (Author author : pub.getAuthorList()) {
                    String current_location = author.getLocation();
                    if (all_locations.contains(current_location)) continue;
                    all_locations.add(current_location);
                }
                for (String current : all_locations) {
                    if (pubs_summary.containsKey(current) && citations_summary.containsKey(current)) {
                        Integer pub_count = (Integer)pubs_summary.get(current) + 1;
                        pubs_summary.put(current, pub_count);
                        Integer cit_count = (Integer)citations_summary.get(current) + pub.getTimesCited();
                        citations_summary.put(current, cit_count);
                        continue;
                    }
                    pubs_summary.put(current, 1);
                    citations_summary.put(current, pub.getTimesCited());
                }
            }
        }
        this.citationsByLocation_distinct = citations_summary;
        this.pubByLocation_distinct = pubs_summary;
    }

    private void calculateTotals_unique() {
        HashMap<String, Integer> pubs_summary = new HashMap<String, Integer>();
        HashMap<String, Integer> citations_summary = new HashMap<String, Integer>();
        if (this.publications != null) {
            for (Publication pub : this.publications) {
                String current_location = pub.getLocation();
                if (pubs_summary.containsKey(current_location) && citations_summary.containsKey(current_location)) {
                    Integer pub_count = (Integer)pubs_summary.get(current_location) + 1;
                    pubs_summary.put(current_location, pub_count);
                    Integer cit_count = (Integer)citations_summary.get(current_location) + pub.getTimesCited();
                    citations_summary.put(current_location, cit_count);
                    continue;
                }
                pubs_summary.put(current_location, 1);
                citations_summary.put(current_location, pub.getTimesCited());
            }
        }
        this.pubByLocation_unique = pubs_summary;
        this.citationsByLocation_unique = citations_summary;
    }

    public HashMap<String, String> createIncitesReports() {
        this.calculateTotals();
        this.calculateTotals_unique();
        this.calculateTotals_distinct();
        HashMap<String, String> filenames = new HashMap<String, String>();
        String basename = this.outputDir + System.getProperty("file.separator") + this.networkName;
        this.generateExcludedPubsReport(this.outputDir, this.networkName + "_excluded_pubs");
        filenames.put("0a. Excluded publications", basename + "_excluded_pubs.html");
        this.generateFiles(this.outputDir, this.networkName + "_pubByLocation_distinct", this.pubByLocation_distinct, "Publications by Location - counting publications once for every distinct location");
        filenames.put("1a. Pub by location(txt) - distinct locations publication counts", basename + "_pubByLocation_distinct.txt");
        filenames.put("1b. Pub by location(html) - distinct locations publication counts", basename + "_pubByLocation_distinct.html");
        this.generateFiles(this.outputDir, this.networkName + "_pubByLocation", this.pubByLocation, "Publications by Location");
        filenames.put("2a. Pub by location(txt)", basename + "_pubByLocation.txt");
        filenames.put("2b. Pub by location(html)", basename + "_pubByLocation.html");
        this.generateFiles(this.outputDir, this.networkName + "_pubByLocation_unique", this.pubByLocation_unique, "Publications by Location - counting publications only once");
        filenames.put("3a. Pub by location(txt) - unique publication counts", basename + "_pubByLocation_unique.txt");
        filenames.put("3b. Pub by location(html) - unique publication counts", basename + "_pubByLocation_unique.html");
        this.generateFiles(this.outputDir, this.networkName + "_citationByLocation_distinct", this.citationsByLocation_distinct, "Citations by Location - counting citations once for every distinct location");
        filenames.put("4a. Citation by location(txt) - distinct locations citation count", basename + "_citationByLocation_distinct.txt");
        filenames.put("4b. Citation by location(html) - distinct locations citation counts", basename + "_citationByLocation_distinct.html");
        this.generateFiles(this.outputDir, this.networkName + "_citationByLocation", this.citationsByLocation, "Citations by Location");
        filenames.put("5a. Citation by location(txt)", basename + "_citationByLocation.txt");
        filenames.put("5b. Citation by location(html)", basename + "_citationByLocation.html");
        this.generateFiles(this.outputDir, this.networkName + "_citationByLocation_unique", this.citationsByLocation_unique, "Citations by Location - counting publications only once");
        filenames.put("6a. Citation by location(txt)- unique publication counts", basename + "_citationByLocation_unique.txt");
        filenames.put("6b. Citation by location(html)- unique publication counts", basename + "_citationByLocation_unique.html");
        return filenames;
    }

    public HashMap<String, String> createPubmedReports() {
        HashMap<String, String> filenames = new HashMap<String, String>();
        String basename = this.outputDir + System.getProperty("file.separator") + this.networkName;
        this.generateExcludedPubsReport(this.outputDir, this.networkName + "_excluded_pubs");
        filenames.put("1a. Excluded publications", basename + "_excluded_pubs.html");
        return filenames;
    }

    public HashMap<String, String> createScopusReports() {
        HashMap<String, String> filenames = new HashMap<String, String>();
        String basename = this.outputDir + System.getProperty("file.separator") + this.networkName;
        this.generateExcludedPubsReport(this.outputDir, this.networkName + "_excluded_pubs");
        filenames.put("1a. Excluded publications", basename + "_excluded_pubs.html");
        return filenames;
    }

    private void generateExcludedPubsReport(String directory, String fileName) {
        String base_name = directory + System.getProperty("file.separator") + fileName;
        try {
            PrintWriter html_writer = new PrintWriter(base_name + ".html", "UTF-8");
            String root = "http://www.ncbi.nlm.nih.gov/pubmed/?term=";
            String url = null;
            html_writer.println("<table border=\"1\">");
            html_writer.println("<td><b>Publication</b></td><td><b># of authors</b></td><td><b>Times Cited</b></td>");
            for (Publication pub : this.excludedPubs) {
                html_writer.println("<tr>");
                url = root + pub.getPMID();
                html_writer.println("<td><a href=" + url.replace(" ", "%20") + ">" + pub.getTitle() + "</a></td>");
                html_writer.println("<td>" + pub.getAuthorList().size() + "</td>");
                html_writer.println("<td>" + pub.getTimesCited() + "</td>");
                html_writer.println("</tr");
            }
            html_writer.println("</table>");
            html_writer.close();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Exception occurred", e);
            CytoscapeUtilities.notifyUser("Failed to create file. IOException. - " + base_name);
        }
    }

    private void generateFiles(String directory, String fileName, HashMap<String, Integer> data, String title) {
        String googleChartHeader = "";
        String googleChartFooter = "";
        try {
            InputStream in = this.getClass().getResourceAsStream("googleChartheader.txt");
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            String sCurrentLine = null;
            while ((sCurrentLine = br.readLine()) != null) {
                googleChartHeader = googleChartHeader + sCurrentLine + "\n";
            }
            in = this.getClass().getResourceAsStream("googleChartfooter.txt");
            br = new BufferedReader(new InputStreamReader(in));
            sCurrentLine = null;
            while ((sCurrentLine = br.readLine()) != null) {
                googleChartFooter = googleChartFooter + sCurrentLine + "\n";
            }
        }
        catch (FileNotFoundException e) {
            logger.log(Level.SEVERE, "Exception occurred", e);
            CytoscapeUtilities.notifyUser("Failed to load google chart template. FileNotFoundException.");
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Exception occurred", e);
            CytoscapeUtilities.notifyUser("Failed to load google chart template. IOException.");
        }
        googleChartFooter = googleChartFooter.replace("TITLEPLACEHOLDER", title);
        String base_name = directory + System.getProperty("file.separator") + fileName;
        try {
            PrintWriter html_writer = new PrintWriter(base_name + ".html", "UTF-8");
            PrintWriter txt_writer = new PrintWriter(base_name + ".txt", "UTF-8");
            html_writer.println(googleChartHeader);
            Iterator<String> i = data.keySet().iterator();
            while (i.hasNext()) {
                String current_key = i.next();
                Integer current_value = data.get(current_key);
                if (i.hasNext()) {
                    html_writer.println("['" + current_key + "'," + current_value + "],");
                } else {
                    html_writer.println("['" + current_key + "'," + current_value + "]");
                }
                txt_writer.println(current_key + "\t" + current_value);
            }
            html_writer.println(googleChartFooter);
            html_writer.close();
            txt_writer.close();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Exception occurred", e);
            CytoscapeUtilities.notifyUser("Failed to create file. IOException. - " + base_name);
        }
    }
}

