/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csapps.socialnetwork.model.academia;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.baderlab.csapps.socialnetwork.CytoscapeUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncitesInstitutionLocationMap {
    private static final Logger logger = Logger.getLogger(IncitesInstitutionLocationMap.class.getName());
    private Map<String, String> locationMap = null;
    private Map<String, Integer> locationRankingMap = null;

    public IncitesInstitutionLocationMap() {
        if (this.locationMap == null) {
            try {
                InputStream in = this.getClass().getResourceAsStream("locationsmap.txt");
                this.locationMap = new HashMap<String, String>();
                BufferedReader br = new BufferedReader(new InputStreamReader(in));
                String sCurrentLine = null;
                while ((sCurrentLine = br.readLine()) != null) {
                    String[] tokens = sCurrentLine.split("\t");
                    if (tokens.length == 2) {
                        this.locationMap.put(tokens[0], tokens[1]);
                        continue;
                    }
                    System.out.println("misformed line in locationmap file\n \"" + sCurrentLine + "\n");
                }
            }
            catch (FileNotFoundException e) {
                logger.log(Level.SEVERE, "Exception occurred", e);
                CytoscapeUtilities.notifyUser("Failed to load location map. FileNotFoundException.");
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Exception occurred", e);
                CytoscapeUtilities.notifyUser("Failed to load location map. IOException.");
            }
        }
    }

    public Map<String, String> getLocationMap() {
        return this.locationMap;
    }

    public Map<String, Integer> getLocationRankingMap() {
        if (this.locationRankingMap == null) {
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            String[] locations = new String[]{"UNIV TORONTO", "Ontario", "Canada", "United States", "International", "Other"};
            for (int i = 0; i < 6; ++i) {
                map.put(locations[i], 6 - i);
            }
            this.setLocationRankingMap(map);
        }
        return this.locationRankingMap;
    }

    public void setLocationMap(Map<String, String> locationMap) {
        this.locationMap = locationMap;
    }

    private void setLocationRankingMap(Map<String, Integer> map) {
        this.locationRankingMap = map;
    }
}

