/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csapps.socialnetwork.model.academia.parsers.pubmed;

import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.baderlab.csapps.socialnetwork.CytoscapeUtilities;
import org.baderlab.csapps.socialnetwork.model.academia.Author;
import org.baderlab.csapps.socialnetwork.model.academia.Publication;
import org.baderlab.csapps.socialnetwork.model.academia.Tag;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EutilsRetrievalParser
extends DefaultHandler {
    private static final Logger logger = Logger.getLogger(EutilsRetrievalParser.class.getName());
    boolean isAuthor = false;
    boolean isJournal = false;
    boolean isPMID = false;
    boolean isPubDate = false;
    boolean isTimesCited = false;
    boolean isTitle = false;
    private Author author = null;
    private StringBuilder journal = null;
    private ArrayList<Author> pubAuthorList = new ArrayList();
    private StringBuilder pubDate = null;
    private ArrayList<Publication> pubList = new ArrayList();
    private StringBuilder pmid = null;
    private StringBuilder timesCited = null;
    private StringBuilder title = null;

    public EutilsRetrievalParser(String queryKey, String webEnv, int retStart, int retMax, int totalPubs) {
        try {
            SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
            while (retStart < totalPubs) {
                Tag tag = new Tag(queryKey, webEnv, retStart, retMax);
                String url = String.format("http://eutils.ncbi.nlm.nih.gov/entrez/eutils/esummary.fcgi?db=pubmed%s", tag);
                saxParser.parse(url, (DefaultHandler)this);
                retStart += retMax;
            }
        }
        catch (ParserConfigurationException e) {
            logger.log(Level.SEVERE, "Exception occurred", e);
            CytoscapeUtilities.notifyUser("Encountered temporary server issues. Please try again some other time.");
        }
        catch (SAXException e) {
            logger.log(Level.SEVERE, "Exception occurred", e);
            CytoscapeUtilities.notifyUser("Encountered temporary server issues. Please try again some other time.");
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Exception occurred", e);
            CytoscapeUtilities.notifyUser("Unable to connect to PubMed. Please check your internet connection.");
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.isPubDate) {
            this.pubDate.append(ch, start, length);
            this.isPubDate = false;
        }
        if (this.isAuthor) {
            this.author = new Author(new String(ch, start, length), -2113004178);
            if (!this.pubAuthorList.contains(this.author)) {
                this.pubAuthorList.add(this.author);
            }
            this.isAuthor = false;
        }
        if (this.isJournal) {
            this.journal.append(ch, start, length);
            this.isJournal = false;
        }
        if (this.isTitle) {
            this.title.append(ch, start, length);
            this.isTitle = false;
        }
        if (this.isTimesCited) {
            this.timesCited.append(ch, start, length);
            this.isTimesCited = false;
        }
        if (this.isPMID) {
            this.pmid.append(ch, start, length);
            this.isPMID = false;
        }
    }

    public boolean contains(Attributes attributes, String text) {
        for (int i = 0; i < attributes.getLength(); ++i) {
            if (!attributes.getValue(i).equalsIgnoreCase(text)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equalsIgnoreCase("DocSum")) {
            Publication publication = new Publication(this.title != null ? this.title.toString() : null, this.pubDate != null ? this.pubDate.toString() : null, this.journal != null ? this.journal.toString() : null, this.timesCited != null ? this.timesCited.toString() : null, null, this.pubAuthorList);
            publication.setPMID(this.pmid.toString());
            this.pubList.add(publication);
            this.pubAuthorList.clear();
            this.journal = null;
            this.pubDate = null;
            this.title = null;
            this.timesCited = null;
            this.pmid = null;
        }
    }

    public ArrayList<Publication> getPubList() {
        return this.pubList;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.contains(attributes, "Author")) {
            this.isAuthor = true;
        }
        if (this.contains(attributes, "FullJournalName")) {
            this.isJournal = true;
            this.journal = new StringBuilder();
        }
        if (this.contains(attributes, "PubDate")) {
            this.isPubDate = true;
            this.pubDate = new StringBuilder();
        }
        if (this.contains(attributes, "Title")) {
            this.isTitle = true;
            this.title = new StringBuilder();
        }
        if (this.contains(attributes, "PmcRefCount")) {
            this.isTimesCited = true;
            this.timesCited = new StringBuilder();
        }
        if (qName.equals("Id")) {
            this.isPMID = true;
            this.pmid = new StringBuilder();
        }
    }
}

