/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.csplugins.wordcloud;

import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.csplugins.wordcloud.CloudParameters;
import cytoscape.csplugins.wordcloud.SemanticSummaryManager;
import cytoscape.csplugins.wordcloud.WordCloudVisualStyle;
import cytoscape.data.CyAttributes;
import cytoscape.layout.CyLayouts;
import cytoscape.util.CytoscapeAction;
import cytoscape.view.CyNetworkView;
import cytoscape.visual.CalculatorCatalog;
import cytoscape.visual.VisualMappingManager;
import cytoscape.visual.VisualStyle;
import giny.model.Edge;
import giny.model.Node;
import java.awt.event.ActionEvent;
import java.util.HashMap;

public class CreateCloudNetworkAction
extends CytoscapeAction {
    private static final long serialVersionUID = 2683655996962050569L;
    public static String WORD_VAL = "Word_Prob";
    public static String CO_VAL = "CO_Prob";
    public static String INTERACTION_TYPE = "CO";
    private static final char controlChar = '\u001f';

    public CreateCloudNetworkAction() {
        super("Create Cloud Network");
    }

    public void actionPerformed(ActionEvent ae) {
        CloudParameters curCloud = SemanticSummaryManager.getInstance().getCurCloud();
        HashMap<String, Double> ratios = curCloud.getRatios();
        HashMap<String, Double> pairRatios = curCloud.getPairRatios();
        String newNetworkName = curCloud.getNextNetworkName();
        CyNetwork network = Cytoscape.createNetwork((String)newNetworkName);
        for (String curWord : ratios.keySet()) {
            CyNode node = Cytoscape.getCyNode((String)curWord, (boolean)true);
            network.addNode((Node)node);
            Double nodeRatio = ratios.get(curWord);
            String attName = newNetworkName + ":" + WORD_VAL;
            CyAttributes nodeAttrs = Cytoscape.getNodeAttributes();
            nodeAttrs.setAttribute(node.getIdentifier(), attName, nodeRatio);
        }
        for (String curEdge : pairRatios.keySet()) {
            Double edgeRatio = pairRatios.get(curEdge);
            String[] nodeNames = curEdge.split(Character.toString('\u001f'));
            String nodeName1 = nodeNames[0];
            String nodeName2 = nodeNames[1];
            CyNode node1 = Cytoscape.getCyNode((String)nodeName1, (boolean)false);
            CyNode node2 = Cytoscape.getCyNode((String)nodeName2, (boolean)false);
            Double node1Ratio = ratios.get(nodeName1);
            Double node2Ratio = ratios.get(nodeName2);
            Double conditionalRatio = edgeRatio / (node1Ratio * node2Ratio);
            if (!(conditionalRatio > 1.0)) continue;
            CyEdge edge = Cytoscape.getCyEdge((Node)node1, (Node)node2, (String)"interaction", (Object)INTERACTION_TYPE, (boolean)true);
            String attName = newNetworkName + ":" + CO_VAL;
            CyAttributes edgeAttrs = Cytoscape.getEdgeAttributes();
            edgeAttrs.setAttribute(edge.getIdentifier(), attName, conditionalRatio);
            network.addEdge((Edge)edge);
        }
        CyNetworkView view = Cytoscape.createNetworkView((CyNetwork)network);
        Cytoscape.firePropertyChange((String)"NETWORK_VIEW_CREATED", (Object)network, (Object)view);
        VisualMappingManager manager = Cytoscape.getVisualMappingManager();
        CalculatorCatalog catalog = manager.getCalculatorCatalog();
        String vs_name = newNetworkName + "WordCloud_style";
        VisualStyle vs = catalog.getVisualStyle(vs_name);
        if (vs == null) {
            WordCloudVisualStyle wc_vs = new WordCloudVisualStyle(vs_name, newNetworkName, curCloud);
            vs = wc_vs.createVisualStyle(network, newNetworkName);
            catalog.addVisualStyle(vs);
        }
        view.setVisualStyle(vs.getName());
        manager.setVisualStyle(vs);
        view.redrawGraph(true, true);
        view.applyLayout(CyLayouts.getLayout((String)"force-directed"));
    }
}

