/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.csplugins.wordcloud;

import cytoscape.csplugins.wordcloud.CloudParameters;
import cytoscape.csplugins.wordcloud.WordPair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterPriorityQueue {
    private ArrayList<WordPair> queue = new ArrayList();
    private CloudParameters params = new CloudParameters();
    private boolean initialized = false;
    private static final char controlChar = '\u001f';

    public void initialize(CloudParameters cloudParams) {
        this.params = cloudParams;
        this.queue = new ArrayList();
        if (!this.params.getRatiosInitialized()) {
            this.params.updateRatios();
        }
        Set<String> pairNames = this.params.getSelectedPairCounts().keySet();
        for (String curName : pairNames) {
            String first = curName.split(Character.toString('\u001f'))[0];
            String second = curName.split(Character.toString('\u001f'))[1];
            WordPair curPair = new WordPair(first, second, this.params);
            curPair.calculateProbability();
            this.queue.add(curPair);
        }
        Collections.sort(this.queue);
        Collections.reverse(this.queue);
        this.initialized = true;
    }

    public WordPair peak() {
        if (!this.queue.isEmpty()) {
            return this.queue.get(0);
        }
        return null;
    }

    public WordPair remove() {
        WordPair removedPair = !this.queue.isEmpty() ? this.queue.remove(0) : null;
        if (removedPair != null) {
            String firstWord = removedPair.getFirstWord();
            String secondWord = removedPair.getSecondWord();
            ArrayList<WordPair> toRemove = new ArrayList<WordPair>();
            for (WordPair curPair : this.queue) {
                String curFirst = curPair.getFirstWord();
                String curSecond = curPair.getSecondWord();
                if (!firstWord.equals(curFirst) && !secondWord.equals(curSecond) && (!firstWord.equals(curSecond) || !secondWord.equals(curFirst))) continue;
                toRemove.add(curPair);
            }
            for (WordPair curPair : toRemove) {
                if (!this.queue.contains(curPair)) continue;
                this.queue.remove(curPair);
            }
        }
        return removedPair;
    }

    public int size() {
        return this.queue.size();
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public ArrayList<WordPair> getQueue() {
        return this.queue;
    }

    public void setQueue(ArrayList<WordPair> aQueue) {
        this.queue = aQueue;
    }

    public CloudParameters getCloudParameters() {
        return this.params;
    }

    public void setCloudParameters(CloudParameters cloudParams) {
        this.params = cloudParams;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialialized(boolean val) {
        this.initialized = val;
    }
}

