/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.csplugins.wordcloud;

import cytoscape.Cytoscape;
import cytoscape.csplugins.wordcloud.CloudDisplayPanel;
import cytoscape.csplugins.wordcloud.SemanticSummaryManager;
import cytoscape.csplugins.wordcloud.SemanticSummaryPluginAction;
import cytoscape.util.CyFileFilter;
import cytoscape.util.CytoscapeAction;
import cytoscape.util.FileUtil;
import cytoscape.view.cytopanels.CytoPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class SaveCloudAction
extends CytoscapeAction {
    public static String SESSION_EXT = ".png";

    public SaveCloudAction() {
        super("Save Cloud Image");
    }

    public void actionPerformed(ActionEvent ae) {
        String name;
        try {
            name = FileUtil.getFile((String)"Save Current Cloud as PNG File", (int)FileUtil.SAVE, (CyFileFilter[])new CyFileFilter[0]).toString();
        }
        catch (Exception exp) {
            return;
        }
        if (!name.endsWith(SESSION_EXT)) {
            name = name + SESSION_EXT;
        }
        this.saveFile(name);
    }

    private void saveFile(String name) {
        CloudDisplayPanel panel = SemanticSummaryManager.getInstance().getCloudWindow();
        String cloudName = SemanticSummaryManager.getInstance().getCurCloud().getCloudName();
        CytoPanel cytoPanel = Cytoscape.getDesktop().getCytoPanel(5);
        Dimension curSize = cytoPanel.getSelectedComponent().getSize();
        JScrollPane scroll = panel.cloudScroll;
        JFrame frame = new JFrame(cloudName);
        int scrollHeight = scroll.getSize().height;
        JPanel flowPanel = panel.getTagCloudFlowPanel();
        int flowHeight = flowPanel.getSize().height;
        int width = curSize.width;
        Dimension fullSize = new Dimension(width, flowHeight += 5);
        scroll.setPreferredSize(fullSize);
        frame.getContentPane().add(scroll);
        scroll.revalidate();
        frame.pack();
        frame.setLocation(-100, -100);
        frame.setVisible(true);
        Dimension imageSize = frame.getSize();
        BufferedImage b = new BufferedImage(imageSize.width, imageSize.height, 1);
        Graphics2D g = b.createGraphics();
        frame.printAll(g);
        try {
            ImageIO.write((RenderedImage)b, "png", new File(name));
        }
        catch (Exception e) {
            // empty catch block
        }
        frame.dispose();
        panel.add((Component)scroll, "Center");
        new SemanticSummaryPluginAction().loadCloudPanel();
    }
}

