/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.csplugins.wordcloud;

import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.csplugins.wordcloud.CloudDisplayPanel;
import cytoscape.csplugins.wordcloud.CloudParameters;
import cytoscape.csplugins.wordcloud.SemanticSummaryManager;
import cytoscape.csplugins.wordcloud.SemanticSummaryParameters;
import cytoscape.csplugins.wordcloud.SemanticSummaryPluginAction;
import cytoscape.util.CytoscapeAction;
import cytoscape.view.CyNetworkView;
import cytoscape.view.CytoscapeDesktop;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateCloudAction
extends CytoscapeAction {
    private static final long serialVersionUID = -814444939886393362L;

    public UpdateCloudAction() {
        super("Update Cloud");
    }

    public void actionPerformed(ActionEvent ae) {
        this.doRealAction();
    }

    public void doRealAction() {
        Set nodes;
        Boolean isDifferent;
        SemanticSummaryPluginAction init = new SemanticSummaryPluginAction();
        init.doRealAction();
        SemanticSummaryParameters networkParams = SemanticSummaryManager.getInstance().getCurNetwork();
        CloudParameters cloudParams = SemanticSummaryManager.getInstance().getCurCloud();
        CyNetwork network = Cytoscape.getCurrentNetwork();
        CyNetworkView view = Cytoscape.getCurrentNetworkView();
        if (networkParams.networkHasChanged(network)) {
            networkParams.updateParameters(network);
        }
        if ((isDifferent = Boolean.valueOf(this.checkSelectionChange(cloudParams, nodes = network.getSelectedNodes()))).booleanValue() && !cloudParams.equals(SemanticSummaryManager.getInstance().getNullCloudParameters())) {
            CytoscapeDesktop parent = Cytoscape.getDesktop();
            int value = 1;
            Object[] options = new Object[]{"Continue", "Revert"};
            value = JOptionPane.showOptionDialog((Component)parent, "Network node selection has changed. Continue with current selection or revert to the original?", "Node Selection Changed", 2, 1, null, options, options[0]);
            if (value == 0) {
                if (nodes.size() == 0) {
                    JOptionPane.showMessageDialog(view.getComponent(), "Please select one or more nodes.");
                    return;
                }
                ArrayList<String> nodeNames = new ArrayList<String>();
                for (CyNode curNode : nodes) {
                    String curName = curNode.toString();
                    nodeNames.add(curName);
                }
                cloudParams.setSelectedNodes(nodeNames);
                cloudParams.setSelectedNumNodes(nodeNames.size());
            } else if (value == 1) {
                List<String> selNodeNames = cloudParams.getSelectedNodes();
                HashSet<CyNode> selNodes = new HashSet<CyNode>();
                for (int i = 0; i < selNodeNames.size(); ++i) {
                    String curNodeID = selNodeNames.get(i);
                    CyNode curNode = Cytoscape.getCyNode((String)curNodeID);
                    selNodes.add(curNode);
                }
                network.unselectAllNodes();
                network.unselectAllEdges();
                network.setSelectedNodeState(selNodes, true);
                view.redrawGraph(false, true);
            }
        }
        cloudParams.retrieveInputVals();
        cloudParams.calculateFontSizes();
        CloudDisplayPanel cloudPanel = SemanticSummaryManager.getInstance().getCloudWindow();
        cloudPanel.updateCloudDisplay(cloudParams);
    }

    private boolean checkSelectionChange(CloudParameters params, Set<CyNode> nodes) {
        Boolean isChanged = false;
        List<String> oldNames = params.getSelectedNodes();
        HashSet<String> oldNamesHash = new HashSet<String>();
        for (int i = 0; i < oldNames.size(); ++i) {
            String curNode = oldNames.get(i);
            oldNamesHash.add(curNode);
        }
        if (oldNamesHash.size() != nodes.size()) {
            return true;
        }
        Iterator<CyNode> iter = nodes.iterator();
        while (iter.hasNext()) {
            String nodeName = iter.next().getIdentifier();
            if (oldNamesHash.contains(nodeName)) continue;
            isChanged = true;
            break;
        }
        return isChanged;
    }
}

