/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.csplugins.wordcloud;

import cytoscape.csplugins.wordcloud.WidestStringProvider;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WidestStringComboBoxModel
extends DefaultComboBoxModel
implements WidestStringProvider {
    private String widest = null;
    private boolean widestValid = false;

    public WidestStringComboBoxModel() {
    }

    public WidestStringComboBoxModel(Object[] items) {
        super(items);
    }

    public WidestStringComboBoxModel(Vector<?> v) {
        super(v);
    }

    @Override
    public void addElement(Object anObject) {
        this.updateWidest(anObject, true);
        super.addElement(anObject);
    }

    @Override
    public void insertElementAt(Object anObject, int index) {
        this.updateWidest(anObject, true);
        super.insertElementAt(anObject, index);
    }

    @Override
    public void removeAllElements() {
        this.resetWidest();
        super.removeAllElements();
    }

    @Override
    public void removeElement(Object anObject) {
        this.updateWidest(anObject, false);
        super.removeElement(anObject);
    }

    @Override
    public void removeElementAt(int index) {
        this.updateWidest(this.getElementAt(index), false);
        super.removeElementAt(index);
    }

    @Override
    public void resetWidest() {
        this.widest = null;
        this.widestValid = false;
    }

    @Override
    public String getWidest() {
        if (!this.widestValid) {
            this.findWidest();
        }
        return this.widest;
    }

    private void updateWidest(Object anObject, boolean adding) {
        String label = this.getLabel(anObject);
        if (this.widestValid) {
            if (adding) {
                if (label.length() > this.widest.length()) {
                    this.widest = label;
                }
            } else if (this.widest.equals(label)) {
                this.resetWidest();
            }
        } else if (adding) {
            this.widest = label;
            this.widestValid = true;
        }
    }

    private void findWidest() {
        int size = this.getSize();
        this.widest = "";
        for (int i = 0; i < size; ++i) {
            String label = this.getLabel(this.getElementAt(i));
            if (label.length() <= this.widest.length()) continue;
            this.widest = label;
        }
        this.widestValid = true;
    }

    protected String getLabel(Object anObject) {
        return anObject != null ? anObject.toString() : "";
    }
}

