/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.csplugins.wordcloud;

import cytoscape.Cytoscape;
import cytoscape.view.CyNetworkView;
import java.util.HashMap;
import java.util.TreeSet;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WordDelimiters {
    private TreeSet<String> delimsInUse = new TreeSet();
    private TreeSet<String> delimsToAdd = new TreeSet();
    private TreeSet<String> userDelims = new TreeSet();
    private HashMap<String, String> regexTranslation = new HashMap();
    private static final String DELIMITER = "SAVEDELIMITER";
    private static final String FIRSTDELIMITER = "NewLineEquivalent";
    private static final String SECONDDELIMITER = "TabbedEquivalent";

    public WordDelimiters() {
        this.delimsInUse.add("tab");
        this.delimsInUse.add("space");
        this.delimsInUse.add("newline");
        this.delimsInUse.add("carriage return");
        this.delimsInUse.add("form feed");
        this.delimsInUse.add("!");
        this.delimsInUse.add("\"");
        this.delimsInUse.add("#");
        this.delimsInUse.add("$");
        this.delimsInUse.add("%");
        this.delimsInUse.add("&");
        this.delimsInUse.add("(");
        this.delimsInUse.add(")");
        this.delimsInUse.add("*");
        this.delimsInUse.add("+");
        this.delimsInUse.add(",");
        this.delimsInUse.add(".");
        this.delimsInUse.add("/");
        this.delimsInUse.add(":");
        this.delimsInUse.add(";");
        this.delimsInUse.add("<");
        this.delimsInUse.add("=");
        this.delimsInUse.add(">");
        this.delimsInUse.add("?");
        this.delimsInUse.add("@");
        this.delimsInUse.add("[");
        this.delimsInUse.add("\\");
        this.delimsInUse.add("]");
        this.delimsInUse.add("^");
        this.delimsInUse.add("_");
        this.delimsInUse.add("`");
        this.delimsInUse.add("{");
        this.delimsInUse.add("|");
        this.delimsInUse.add("}");
        this.delimsInUse.add("~");
        this.delimsToAdd.add("-");
        this.delimsToAdd.add("'");
        this.regexTranslation.put("tab", "\\t");
        this.regexTranslation.put("space", " ");
        this.regexTranslation.put("newline", "\\n");
        this.regexTranslation.put("carriage return", "\\r");
        this.regexTranslation.put("form feed", "\\f");
        this.regexTranslation.put("!", "!");
        this.regexTranslation.put("\"", "\"");
        this.regexTranslation.put("#", "#");
        this.regexTranslation.put("$", "$");
        this.regexTranslation.put("%", "%");
        this.regexTranslation.put("&", "&");
        this.regexTranslation.put("(", "(");
        this.regexTranslation.put(")", ")");
        this.regexTranslation.put("*", "*");
        this.regexTranslation.put("+", "+");
        this.regexTranslation.put(",", ",");
        this.regexTranslation.put(".", ".");
        this.regexTranslation.put("/", "/");
        this.regexTranslation.put(":", ":");
        this.regexTranslation.put(";", ";");
        this.regexTranslation.put("<", "<");
        this.regexTranslation.put("=", "=");
        this.regexTranslation.put(">", ">");
        this.regexTranslation.put("?", "?");
        this.regexTranslation.put("@", "@");
        this.regexTranslation.put("[", "\\[");
        this.regexTranslation.put("\\", "\\\\");
        this.regexTranslation.put("]", "\\]");
        this.regexTranslation.put("^", "\\^");
        this.regexTranslation.put("_", "_");
        this.regexTranslation.put("`", "`");
        this.regexTranslation.put("{", "{");
        this.regexTranslation.put("|", "|");
        this.regexTranslation.put("}", "}");
        this.regexTranslation.put("~", "~");
        this.regexTranslation.put("-", "\\-");
        this.regexTranslation.put("'", "'");
    }

    public WordDelimiters(String propFile) {
        this();
        String curDelim;
        String[] delims;
        String value;
        HashMap<String, String> props = new HashMap<String, String>();
        String[] lines = propFile.split(FIRSTDELIMITER);
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            String[] tokens = line.split(SECONDDELIMITER);
            if (tokens.length != 2) continue;
            props.put(tokens[0], tokens[1]);
        }
        if (props.get("DelimsInUse") != null || props.get("DelimsToAdd") != null) {
            this.delimsInUse = new TreeSet();
            this.delimsToAdd = new TreeSet();
        }
        if ((value = (String)props.get("DelimsInUse")) != null) {
            delims = value.split(DELIMITER);
            for (int i = 0; i < delims.length; ++i) {
                curDelim = delims[i];
                this.delimsInUse.add(curDelim);
            }
        }
        if ((value = (String)props.get("DelimsToAdd")) != null) {
            delims = value.split(DELIMITER);
            for (int i = 0; i < delims.length; ++i) {
                curDelim = delims[i];
                this.delimsToAdd.add(curDelim);
            }
        }
        if ((value = (String)props.get("AddedDelims")) != null) {
            delims = value.split(DELIMITER);
            for (int i = 0; i < delims.length; ++i) {
                curDelim = delims[i];
                this.userDelims.add(curDelim);
            }
        }
    }

    public String toString() {
        StringBuffer delimVariables = new StringBuffer();
        StringBuffer output = new StringBuffer();
        if (this.delimsInUse.size() > 0) {
            for (String curDelim : this.delimsInUse) {
                output.append(curDelim + DELIMITER);
            }
            delimVariables.append("DelimsInUseTabbedEquivalent" + output.toString() + FIRSTDELIMITER);
        }
        output = new StringBuffer();
        if (this.delimsToAdd.size() > 0) {
            for (String curWord : this.delimsToAdd) {
                output.append(curWord + DELIMITER);
            }
            delimVariables.append("DelimsToAddTabbedEquivalent" + output.toString() + FIRSTDELIMITER);
        }
        output = new StringBuffer();
        if (this.userDelims.size() > 0) {
            for (String curWord : this.userDelims) {
                output.append(curWord + DELIMITER);
            }
            delimVariables.append("AddedDelimsTabbedEquivalent" + output.toString() + FIRSTDELIMITER);
        }
        return delimVariables.toString();
    }

    public String getRegex() {
        String reg = "";
        for (String curDelim : this.delimsInUse) {
            String addDelim = this.translateToRegex(curDelim);
            reg = reg + addDelim;
        }
        String regEx = "[" + reg + "]";
        return regEx;
    }

    public void addDelimToUse(String delim) {
        if (this.delimsToAdd.contains(delim)) {
            this.delimsToAdd.remove(delim);
            this.delimsInUse.add(delim);
        } else if (!this.userDelims.contains(delim)) {
            this.userDelims.add(delim);
        }
    }

    public void removeDelimiter(String delim) {
        if (delim.equals("newline") || delim.equals("tab")) {
            CyNetworkView view = Cytoscape.getCurrentNetworkView();
            JOptionPane.showMessageDialog(view.getComponent(), delim + " is not currently enabled for removal from the list of delimters.");
        } else if (this.userDelims.contains(delim)) {
            this.userDelims.remove(delim);
        } else if (this.delimsInUse.contains(delim)) {
            this.delimsInUse.remove(delim);
            this.delimsToAdd.add(delim);
        }
    }

    public String translateToRegex(String val) {
        if (this.regexTranslation.containsKey(val)) {
            return this.regexTranslation.get(val);
        }
        return null;
    }

    public TreeSet<String> getDelimsInUse() {
        return this.delimsInUse;
    }

    public TreeSet<String> getDelimsToAdd() {
        return this.delimsToAdd;
    }

    public TreeSet<String> getUserDelims() {
        return this.userDelims;
    }

    public HashMap<String, String> getRegExTranslation() {
        return this.regexTranslation;
    }
}

