/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.csplugins.wordcloud;

import cytoscape.csplugins.wordcloud.SemanticSummaryPlugin;
import cytoscape.data.readers.TextFileReader;
import cytoscape.data.readers.TextJarReader;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WordFilter {
    private HashSet<String> stopWords = new HashSet();
    private HashSet<String> flaggedWords = new HashSet();
    private HashSet<String> addedWords = new HashSet();
    private HashSet<String> numberWords = new HashSet();
    private Boolean filterNums = false;
    public static final String stopWordFile = "StopWords.txt";
    public static final String flaggedWordFile = "FlaggedWords.txt";
    public static final String separator = "/";
    public static final String resources = "resources";
    public static final String newline = "\n";
    private static final String DELIMITER = "WordFilterDelimiter";

    public WordFilter() {
        String stopPath = "resources/StopWords.txt";
        String flaggedPath = "resources/FlaggedWords.txt";
        this.initialize(stopPath, this.stopWords);
        this.initialize(flaggedPath, this.flaggedWords);
        this.initializeNums();
    }

    public WordFilter(String propFile) {
        String curWord;
        String[] words;
        HashMap<String, String> props = new HashMap<String, String>();
        String[] lines = propFile.split(newline);
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            String[] tokens = line.split("\t");
            if (tokens.length != 2) continue;
            props.put(tokens[0], tokens[1]);
        }
        String value = (String)props.get("StopWords");
        if (value != null) {
            words = value.split(DELIMITER);
            for (int i = 0; i < words.length; ++i) {
                curWord = words[i];
                this.stopWords.add(curWord);
            }
        }
        if ((value = (String)props.get("FlaggedWords")) != null) {
            words = value.split(DELIMITER);
            for (int i = 0; i < words.length; ++i) {
                curWord = words[i];
                this.flaggedWords.add(curWord);
            }
        }
        if ((value = (String)props.get("AddedWords")) != null) {
            words = value.split(DELIMITER);
            for (int i = 0; i < words.length; ++i) {
                curWord = words[i];
                this.addedWords.add(curWord);
            }
        }
        this.initializeNums();
        value = (String)props.get("FilterNums");
        if (value != null) {
            this.filterNums = Boolean.parseBoolean(value);
        }
    }

    public boolean contains(String aWord) {
        if (this.stopWords.contains(aWord)) {
            return true;
        }
        if (this.flaggedWords.contains(aWord)) {
            return true;
        }
        if (this.addedWords.contains(aWord)) {
            return true;
        }
        if (this.filterNums.booleanValue()) {
            return this.numberWords.contains(aWord);
        }
        return false;
    }

    public void add(String aWord) {
        this.addedWords.add(aWord);
    }

    public void remove(String aWord) {
        if (this.stopWords.contains(aWord)) {
            this.stopWords.remove(aWord);
        } else if (this.flaggedWords.contains(aWord)) {
            this.flaggedWords.remove(aWord);
        } else if (this.addedWords.contains(aWord)) {
            this.addedWords.remove(aWord);
        }
    }

    private void initialize(String resourcePath, HashSet<String> wordSet) {
        URL myURL = SemanticSummaryPlugin.class.getResource(resourcePath);
        try {
            TextJarReader reader = new TextJarReader(myURL.toString());
            reader.read();
            String fullText = reader.getText();
            StringTokenizer token = new StringTokenizer(fullText);
            while (token.hasMoreTokens()) {
                String curWord = token.nextToken();
                wordSet.add(curWord);
            }
        }
        catch (Exception e) {
            File f;
            try {
                f = new File(myURL.toURI());
            }
            catch (URISyntaxException ex) {
                f = new File(myURL.getPath());
            }
            String path = f.getAbsolutePath();
            TextFileReader reader = new TextFileReader(path);
            reader.read();
            String fullText = reader.getText();
            String[] lines = fullText.split(newline);
            for (int i = 0; i < lines.length; ++i) {
                String curWord = lines[i];
                wordSet.add(curWord);
            }
        }
    }

    public String toString() {
        StringBuffer filterVariables = new StringBuffer();
        StringBuffer output = new StringBuffer();
        if (this.stopWords.size() > 0) {
            for (String curWord : this.stopWords) {
                output.append(curWord + DELIMITER);
            }
            filterVariables.append("StopWords\t" + output.toString() + newline);
        }
        output = new StringBuffer();
        if (this.flaggedWords.size() > 0) {
            for (String curWord : this.flaggedWords) {
                output.append(curWord + DELIMITER);
            }
            filterVariables.append("FlaggedWords\t" + output.toString() + newline);
        }
        output = new StringBuffer();
        if (this.addedWords.size() > 0) {
            for (String curWord : this.addedWords) {
                output.append(curWord + DELIMITER);
            }
            filterVariables.append("AddedWords\t" + output.toString() + newline);
        }
        filterVariables.append("FilterNums\t" + this.filterNums + newline);
        return filterVariables.toString();
    }

    private void initializeNums() {
        this.numberWords = new HashSet();
        for (int i = 0; i < 1000; ++i) {
            String value = Integer.toString(i);
            this.numberWords.add(value);
        }
    }

    public HashSet<String> getStopWords() {
        return this.stopWords;
    }

    public HashSet<String> getFlaggedWords() {
        return this.flaggedWords;
    }

    public HashSet<String> getAddedWords() {
        return this.addedWords;
    }

    public HashSet<String> getNumWords() {
        return this.numberWords;
    }

    public Boolean getFilterNums() {
        return this.filterNums;
    }

    public void setFilterNums(Boolean val) {
        this.filterNums = val;
    }
}

