/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.csplugins.wordcloud;

import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.csplugins.wordcloud.CloudParameters;
import cytoscape.csplugins.wordcloud.WordDelimiters;
import cytoscape.csplugins.wordcloud.WordFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SemanticSummaryParameters {
    private String networkName;
    private HashMap<String, CloudParameters> clouds = new HashMap();
    private List<String> nodeList = new ArrayList<String>();
    private Integer cloudCount = 1;
    private static final String CLOUDNAME = "Cloud";
    private static final String SEPARATER = "_";
    private static final Integer MINFONTSIZE = 12;
    private static final Integer MAXFONTSIZE = 64;
    private static final String NODEDELIMITER = "SSParamNodeDelimiter";
    private WordFilter filter = new WordFilter();
    private WordDelimiters delimiters = new WordDelimiters();
    private boolean isStemming = false;

    public SemanticSummaryParameters() {
    }

    public SemanticSummaryParameters(String propFile) {
        this();
        HashMap<String, String> props = new HashMap<String, String>();
        String[] lines = propFile.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            String[] tokens = line.split("\t");
            if (tokens.length != 2) continue;
            props.put(tokens[0], tokens[1]);
        }
        this.networkName = (String)props.get("NetworkName");
        this.cloudCount = new Integer((String)props.get("CloudCount"));
        String value = (String)props.get("NodeList");
        String[] nodes = value.split(NODEDELIMITER);
        ArrayList<String> nodeNameList = new ArrayList<String>();
        for (int i = 0; i < nodes.length; ++i) {
            String nodeName = nodes[i];
            nodeNameList.add(nodeName);
        }
        this.nodeList = nodeNameList;
        String val = (String)props.get("isStemming");
        this.isStemming = val == null ? false : Boolean.parseBoolean((String)props.get("isStemming"));
    }

    public void addCloud(String name, CloudParameters params) {
        if (!this.clouds.containsKey(name)) {
            this.clouds.put(name, params);
        }
    }

    public void removeCloud(String name) {
        if (this.clouds.containsKey(name)) {
            this.clouds.remove(name);
        }
    }

    public boolean containsCloud(String name) {
        return this.clouds.containsKey(name);
    }

    public CloudParameters getCloud(String name) {
        if (this.containsCloud(name)) {
            return this.clouds.get(name);
        }
        return null;
    }

    public void networkChanged() {
        Set<String> cloudNames = this.clouds.keySet();
        for (String curCloud : cloudNames) {
            CloudParameters cloudParams = this.clouds.get(curCloud);
            cloudParams.setCountInitialized(false);
            cloudParams.setSelInitialized(false);
            cloudParams.setRatiosInitialized(false);
        }
    }

    public String getNextCloudName() {
        String name = "Cloud_" + this.cloudCount;
        Integer n = this.cloudCount;
        Integer n2 = this.cloudCount = Integer.valueOf(this.cloudCount + 1);
        return name;
    }

    public String toString() {
        StringBuffer paramVariables = new StringBuffer();
        paramVariables.append("NetworkName\t" + this.networkName + "\n");
        paramVariables.append("CloudCount\t" + this.cloudCount + "\n");
        StringBuffer output = new StringBuffer();
        for (int i = 0; i < this.nodeList.size(); ++i) {
            output.append(this.nodeList.get(i).toString() + NODEDELIMITER);
        }
        paramVariables.append("NodeList\t" + output.toString() + "\n");
        paramVariables.append("isStemming\t" + this.isStemming + "\n");
        return paramVariables.toString();
    }

    public String printHashMap(HashMap map) {
        StringBuffer result = new StringBuffer();
        for (Object key : map.keySet()) {
            result.append(key.toString() + "\t" + map.get(key).toString() + "\n");
        }
        return result.toString();
    }

    public void updateParameters(CyNetwork network) {
        this.setNetworkName(network.getTitle());
        List nodes = network.nodesList();
        ArrayList<String> nodeNames = new ArrayList<String>();
        for (CyNode curNode : nodes) {
            String curName = curNode.toString();
            nodeNames.add(curName);
        }
        this.setNetworkNodes(nodeNames);
        this.networkChanged();
    }

    public boolean networkHasChanged(CyNetwork network) {
        List nodes = network.nodesList();
        Boolean isChanged = false;
        List<String> oldNames = this.getNetworkNodes();
        HashSet<String> oldNamesHash = new HashSet<String>();
        for (int i = 0; i < oldNames.size(); ++i) {
            String curNode = oldNames.get(i);
            oldNamesHash.add(curNode);
        }
        if (oldNamesHash.size() != nodes.size()) {
            return true;
        }
        Iterator iter = nodes.iterator();
        while (iter.hasNext()) {
            String nodeName = ((CyNode)iter.next()).getIdentifier();
            if (oldNamesHash.contains(nodeName)) continue;
            isChanged = true;
            break;
        }
        return isChanged;
    }

    public String getNetworkName() {
        return this.networkName;
    }

    public void setNetworkName(String network) {
        this.networkName = network;
    }

    public HashMap<String, CloudParameters> getClouds() {
        return this.clouds;
    }

    public void setClouds(HashMap<String, CloudParameters> cloudMap) {
        this.clouds = cloudMap;
    }

    public List<String> getNetworkNodes() {
        return this.nodeList;
    }

    public void setNetworkNodes(List<String> nodes) {
        this.nodeList = nodes;
    }

    public Integer getMaxFont() {
        return MAXFONTSIZE;
    }

    public Integer getMinFont() {
        return MINFONTSIZE;
    }

    public Integer getCloudCount() {
        return this.cloudCount;
    }

    public String getCloudName() {
        return CLOUDNAME;
    }

    public String getSeparater() {
        return SEPARATER;
    }

    public WordFilter getFilter() {
        return this.filter;
    }

    public void setFilter(WordFilter aFilter) {
        this.filter = aFilter;
    }

    public WordDelimiters getDelimiter() {
        return this.delimiters;
    }

    public void setDelimiter(WordDelimiters aDelimiter) {
        this.delimiters = aDelimiter;
    }

    public boolean getIsStemming() {
        return this.isStemming;
    }

    public void setIsStemming(boolean val) {
        this.isStemming = val;
    }
}

