/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.csplugins.wordcloud;

import cytoscape.csplugins.wordcloud.CloudParameters;
import cytoscape.csplugins.wordcloud.SingleWordCluster;
import cytoscape.csplugins.wordcloud.WordPair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WordClusters {
    private ArrayList<SingleWordCluster> clusters = new ArrayList();
    private CloudParameters params = new CloudParameters();
    boolean initialized = false;

    public void initialize(CloudParameters cloudParams) {
        this.params = cloudParams;
        if (!this.params.getSelInitialized()) {
            this.params.updateSelectedCounts();
        }
        Set<String> words = this.params.getSelectedCounts().keySet();
        this.clusters = new ArrayList();
        for (String curWord : words) {
            SingleWordCluster curList = new SingleWordCluster();
            curList.initialize(cloudParams);
            curList.add(curWord);
            this.clusters.add(curList);
        }
        this.initialized = true;
    }

    public void combineClusters(WordPair aPair) {
        String curWord;
        int i;
        if (!this.isValidPair(aPair)) {
            return;
        }
        String firstWord = aPair.getFirstWord();
        String secondWord = aPair.getSecondWord();
        SingleWordCluster firstCluster = null;
        SingleWordCluster secondCluster = null;
        for (SingleWordCluster curCluster : this.clusters) {
            if (curCluster == null) continue;
            ArrayList<String> curList = curCluster.getWordList();
            int size = curList.size();
            String firstItem = curList.get(0);
            String lastItem = curList.get(size - 1);
            if (firstItem.equals(secondWord)) {
                secondCluster = curCluster;
            }
            if (!lastItem.equals(firstWord)) continue;
            firstCluster = curCluster;
        }
        SingleWordCluster newCluster = new SingleWordCluster();
        newCluster.initialize(this.params);
        ArrayList<String> firstList = firstCluster.getWordList();
        ArrayList<String> secondList = secondCluster.getWordList();
        for (i = 0; i < firstList.size(); ++i) {
            curWord = firstList.get(i);
            newCluster.add(curWord);
        }
        for (i = 0; i < secondList.size(); ++i) {
            curWord = secondList.get(i);
            newCluster.add(curWord);
        }
        this.clusters.remove(firstCluster);
        this.clusters.remove(secondCluster);
        this.clusters.add(newCluster);
    }

    private boolean isValidPair(WordPair aPair) {
        boolean isValid = false;
        String firstWord = aPair.getFirstWord();
        String secondWord = aPair.getSecondWord();
        Object firstCluster = null;
        SingleWordCluster secondCluster = null;
        for (SingleWordCluster curCluster : this.clusters) {
            if (curCluster == null) continue;
            ArrayList<String> curList = curCluster.getWordList();
            int size = curList.size();
            String firstItem = curList.get(0);
            String lastItem = curList.get(size - 1);
            if (firstItem.equals(secondWord)) {
                secondCluster = curCluster;
            }
            if (!lastItem.equals(firstWord)) continue;
            firstCluster = curCluster;
        }
        if (firstCluster != null && secondCluster != null && !firstCluster.equals(secondCluster)) {
            isValid = true;
        }
        return isValid;
    }

    public void orderClusters() {
        Collections.sort(this.clusters);
        Collections.reverse(this.clusters);
    }

    public ArrayList<SingleWordCluster> getClusters() {
        return this.clusters;
    }

    public void setClusters(ArrayList<SingleWordCluster> clusterSet) {
        this.clusters = clusterSet;
    }

    public CloudParameters getCloudParameters() {
        return this.params;
    }

    public void setCloudParameters(CloudParameters cloudParams) {
        this.params = cloudParams;
    }
}

