/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.csplugins.wordcloud;

import cytoscape.Cytoscape;
import cytoscape.csplugins.wordcloud.AddDelimiterDialog;
import cytoscape.csplugins.wordcloud.CloudDisplayStyles;
import cytoscape.csplugins.wordcloud.CloudListMouseListener;
import cytoscape.csplugins.wordcloud.CloudListSelectionHandler;
import cytoscape.csplugins.wordcloud.CloudParameters;
import cytoscape.csplugins.wordcloud.CollapsiblePanel;
import cytoscape.csplugins.wordcloud.CreateCloudAction;
import cytoscape.csplugins.wordcloud.CreateCloudNetworkAction;
import cytoscape.csplugins.wordcloud.DeleteCloudAction;
import cytoscape.csplugins.wordcloud.SemanticSummaryManager;
import cytoscape.csplugins.wordcloud.SemanticSummaryParameters;
import cytoscape.csplugins.wordcloud.SliderBarPanel;
import cytoscape.csplugins.wordcloud.UpdateCloudAction;
import cytoscape.csplugins.wordcloud.WidestStringComboBoxModel;
import cytoscape.csplugins.wordcloud.WidestStringComboBoxPopupMenuListener;
import cytoscape.csplugins.wordcloud.WordDelimiters;
import cytoscape.csplugins.wordcloud.WordFilter;
import cytoscape.data.CyAttributes;
import cytoscape.util.swing.CheckBoxJList;
import cytoscape.view.CytoscapeDesktop;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SemanticSummaryInputPanel
extends JPanel
implements ItemListener,
ActionListener {
    private static final long serialVersionUID = 2453517387682663100L;
    private DecimalFormat decFormat = new DecimalFormat();
    private NumberFormat intFormat;
    private JFormattedTextField maxWordsTextField;
    private JFormattedTextField clusterCutoffTextField;
    private JTextField addWordTextField;
    private JComboBox cmbRemoval;
    private JComboBox cmbStyle;
    private JComboBox cmbDelimiterRemoval;
    private JComboBox cmbDelimiterAddition;
    private JLabel networkLabel;
    private DefaultListModel listValues;
    private JList cloudList;
    private CloudListSelectionHandler handler;
    private JButton removeWordButton;
    private JButton addWordButton;
    private JButton addDelimiterButton;
    private JButton removeDelimiterButton;
    private JButton createNetworkButton;
    private JCheckBox numExclusion;
    private JCheckBox useNetworkCounts;
    private SliderBarPanel sliderPanel;
    private CheckBoxJList attributeList;
    private JPopupMenu attributeSelectionPopupMenu;
    private JTextArea attNames;
    private static final String addedSeparator = "--Added Words--";
    private static final String flaggedSeparator = "--Flagged Words--";
    private static final String stopSeparator = "--Stop Words--";
    private static final String commonDelimiters = "--Common Delimiters--";
    private static final String userAddDelimiters = "--User Defined--";
    private static final String selectMe = "Select to add your own";
    private static final int DEF_ROW_HEIGHT = 20;

    public SemanticSummaryInputPanel() {
        this.decFormat.setParseIntegerOnly(false);
        this.intFormat = NumberFormat.getIntegerInstance();
        this.intFormat.setParseIntegerOnly(true);
        this.setLayout(new BorderLayout());
        JPanel cloudList = this.createCloudListPanel();
        JScrollPane cloudListScroll = new JScrollPane(cloudList);
        JPanel optionsPanel = this.createOptionsPanel();
        JScrollPane optionsScroll = new JScrollPane(optionsPanel);
        optionsScroll.setHorizontalScrollBarPolicy(31);
        JPanel bottomPanel = this.createBottomPanel();
        this.add((Component)cloudListScroll, "North");
        this.add((Component)optionsScroll, "Center");
        this.add((Component)bottomPanel, "South");
    }

    public JPanel createCloudListPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JPanel networkPanel = new JPanel();
        networkPanel.setLayout(new FlowLayout());
        this.networkLabel = new JLabel();
        networkPanel.add(this.networkLabel);
        this.listValues = new DefaultListModel();
        this.cloudList = new JList(this.listValues);
        this.cloudList.setSelectionMode(0);
        this.cloudList.setSelectedIndex(0);
        this.cloudList.setVisibleRowCount(10);
        this.cloudList.setFixedCellHeight(20);
        this.cloudList.addMouseListener(new CloudListMouseListener());
        ListSelectionModel listSelectionModel = this.cloudList.getSelectionModel();
        this.handler = new CloudListSelectionHandler();
        listSelectionModel.addListSelectionListener(this.handler);
        JScrollPane listScrollPane = new JScrollPane(this.cloudList);
        panel.add((Component)networkPanel, "North");
        panel.add((Component)listScrollPane, "Center");
        return panel;
    }

    public JPanel createOptionsPanel() {
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel("Cloud Parameters");
        collapsiblePanel.setCollapsed(false);
        collapsiblePanel.getTitleComponent().setToolTipText("Parameters that can be set differently for each individual cloud");
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        CollapsiblePanel semAnalysis = this.createSemAnalysisPanel();
        semAnalysis.setCollapsed(false);
        CollapsiblePanel displaySettings = this.createDisplaySettingsPanel();
        displaySettings.setCollapsed(true);
        CollapsiblePanel cloudLayout = this.createCloudLayoutPanel();
        cloudLayout.setCollapsed(true);
        panel.add(semAnalysis);
        panel.add(displaySettings);
        panel.add(cloudLayout);
        collapsiblePanel.getContentPane().add((Component)panel, "North");
        CollapsiblePanel collapsiblePanel2 = new CollapsiblePanel("Network Parameters");
        collapsiblePanel2.setCollapsed(false);
        collapsiblePanel2.getTitleComponent().setToolTipText("Parameters that will be applied to all clouds created from the current network");
        JPanel networkPanel = new JPanel();
        networkPanel.setLayout(new BoxLayout(networkPanel, 1));
        CollapsiblePanel exclusionList = this.createExclusionListPanel();
        exclusionList.setCollapsed(true);
        networkPanel.add(exclusionList);
        CollapsiblePanel tokenizationPanel = this.createTokenizationPanel();
        tokenizationPanel.setCollapsed(true);
        networkPanel.add(tokenizationPanel);
        collapsiblePanel2.getContentPane().add((Component)networkPanel, "North");
        JPanel newPanel = new JPanel();
        newPanel.setLayout(new BorderLayout());
        newPanel.add((Component)collapsiblePanel, "North");
        newPanel.add((Component)collapsiblePanel2, "Center");
        return newPanel;
    }

    private CollapsiblePanel createSemAnalysisPanel() {
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel("Attribute Choice");
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(0, 1));
        JPanel attributePanel = new JPanel();
        attributePanel.setLayout(new GridBagLayout());
        this.attributeList = new CheckBoxJList();
        DefaultListModel model = new DefaultListModel();
        this.attributeList.setModel(model);
        this.attributeList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                SemanticSummaryInputPanel.this.updateAttNames();
            }
        });
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setPreferredSize(new Dimension(300, 200));
        scrollPane.setViewportView((Component)this.attributeList);
        this.attributeSelectionPopupMenu = new JPopupMenu();
        this.attributeSelectionPopupMenu.add(scrollPane);
        JButton attributeButton = new JButton("Edit");
        attributeButton.setToolTipText("Edit nodes values to use for semantic analysis");
        attributeButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                SemanticSummaryInputPanel.this.attributeSelectionPopupMenu.show(e.getComponent(), 0, e.getComponent().getPreferredSize().height);
            }
        });
        this.attNames = new JTextArea();
        this.attNames.setColumns(15);
        this.attNames.setEditable(false);
        JScrollPane attListPane = new JScrollPane();
        attListPane.setPreferredSize(this.attNames.getPreferredSize());
        attListPane.setViewportView(this.attNames);
        attListPane.setHorizontalScrollBarPolicy(31);
        attListPane.setVerticalScrollBarPolicy(22);
        JLabel attributeLabel = new JLabel("Current Values:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        attributePanel.add((Component)attributeLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        attributePanel.add((Component)attListPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        attributePanel.add((Component)attributeButton, gridBagConstraints);
        this.refreshAttributeCMB();
        panel.add(attributePanel);
        collapsiblePanel.getContentPane().add((Component)panel, "North");
        return collapsiblePanel;
    }

    private CollapsiblePanel createDisplaySettingsPanel() {
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel("Advanced");
        CloudParameters params = SemanticSummaryManager.getInstance().getCurCloud();
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        JLabel maxWordsLabel = new JLabel("Max Num of Words");
        this.maxWordsTextField = new JFormattedTextField(this.intFormat);
        this.maxWordsTextField.setColumns(10);
        this.maxWordsTextField.setValue(params.getDefaultMaxWords());
        this.maxWordsTextField.addPropertyChangeListener(new FormattedTextFieldAction());
        StringBuffer buf = new StringBuffer();
        buf.append("<html>Sets a limit on the number of words to display in the cloud<br>");
        buf.append("<b>Acceptable Values:</b> greater than or equal to 0</html>");
        this.maxWordsTextField.setToolTipText(buf.toString());
        JPanel maxWordsPanel = new JPanel();
        maxWordsPanel.setLayout(new BorderLayout());
        maxWordsPanel.add((Component)maxWordsLabel, "West");
        maxWordsPanel.add((Component)this.maxWordsTextField, "East");
        JLabel clusterCutoffLabel = new JLabel("Word Aggregation Cutoff");
        this.clusterCutoffTextField = new JFormattedTextField(this.decFormat);
        this.clusterCutoffTextField.setColumns(3);
        this.clusterCutoffTextField.setValue(params.getDefaultClusterCutoff());
        this.clusterCutoffTextField.addPropertyChangeListener(new FormattedTextFieldAction());
        buf = new StringBuffer();
        buf.append("<html>Cutoff for placing two words in the same cluster - ratio of the observed joint probability of the words to their joint probability if the words appeared independently of each other<br>");
        buf.append("<b>Acceptable Values:</b> greater than or equal to 0</html>");
        this.clusterCutoffTextField.setToolTipText(buf.toString());
        JPanel clusterCutoffPanel = new JPanel();
        clusterCutoffPanel.setLayout(new BorderLayout());
        clusterCutoffPanel.add((Component)clusterCutoffLabel, "West");
        clusterCutoffPanel.add((Component)this.clusterCutoffTextField, "East");
        JPanel netNormalizationPanel = new JPanel();
        netNormalizationPanel.setLayout(new GridBagLayout());
        this.useNetworkCounts = new JCheckBox("Normalize word size using selection/network ratios");
        this.useNetworkCounts.setToolTipText("Enables word size to be calculated using using counts over the entire network, rather than just selected nodes");
        this.useNetworkCounts.addActionListener(this);
        this.useNetworkCounts.setSelected(false);
        this.useNetworkCounts.setEnabled(false);
        this.sliderPanel = new SliderBarPanel(0.0, 1.0, "Network Normalization", "Network Normalization", 10);
        this.sliderPanel.setEnabled(false);
        this.sliderPanel.setVisible(false);
        buf = new StringBuffer();
        buf.append("<html>Determines how much weight to give the whole network when normalizing the selected nodes<br>");
        buf.append("<b>Acceptable Values:</b> greater than or equal to 0 and less than or equal to 1</html>");
        this.sliderPanel.setToolTipText(buf.toString());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        netNormalizationPanel.add((Component)this.useNetworkCounts, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        netNormalizationPanel.add((Component)this.sliderPanel, gridBagConstraints);
        panel.add(maxWordsPanel);
        panel.add(clusterCutoffPanel);
        panel.add(netNormalizationPanel);
        collapsiblePanel.getContentPane().add((Component)panel, "North");
        return collapsiblePanel;
    }

    private CollapsiblePanel createExclusionListPanel() {
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel("Word Exclusion List");
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(0, 1));
        JLabel addWordLabel = new JLabel("Add Word");
        this.addWordTextField = new JFormattedTextField();
        this.addWordTextField.setColumns(15);
        SemanticSummaryParameters networkParams = SemanticSummaryManager.getInstance().getCurNetwork();
        if (networkParams.equals(SemanticSummaryManager.getInstance().getNullSemanticSummary())) {
            this.addWordTextField.setEditable(false);
        } else {
            this.addWordTextField.setEditable(true);
        }
        this.addWordTextField.setText("");
        this.addWordTextField.addPropertyChangeListener(new FormattedTextFieldAction());
        StringBuffer buf = new StringBuffer();
        buf.append("<html>Allows for specification of an additional word to be excluded when doing semantic analysis<br>");
        buf.append("<b>Acceptable Values:</b> Only alpha numeric values - no spaces allowed</html>");
        this.addWordTextField.setToolTipText(buf.toString());
        this.addWordButton = new JButton();
        this.addWordButton.setText("Add");
        this.addWordButton.setEnabled(false);
        this.addWordButton.addActionListener(this);
        JPanel wordPanel = new JPanel();
        wordPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        wordPanel.add((Component)addWordLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        wordPanel.add((Component)this.addWordTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        wordPanel.add((Component)this.addWordButton, gridBagConstraints);
        JLabel removeWordLabel = new JLabel("Remove Word");
        WidestStringComboBoxModel wscbm = new WidestStringComboBoxModel();
        this.cmbRemoval = new JComboBox(wscbm);
        this.cmbRemoval.addPopupMenuListener(new WidestStringComboBoxPopupMenuListener());
        this.cmbRemoval.setEditable(false);
        Dimension d = this.cmbRemoval.getPreferredSize();
        this.cmbRemoval.setPreferredSize(new Dimension(15, d.height));
        this.cmbRemoval.addItemListener(this);
        this.cmbRemoval.setToolTipText("Allows for selection a word to remove from the semantic analysis exclusion list");
        this.removeWordButton = new JButton();
        this.removeWordButton.setText("Remove");
        this.removeWordButton.setEnabled(false);
        this.removeWordButton.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        wordPanel.add((Component)removeWordLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        wordPanel.add((Component)this.cmbRemoval, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        wordPanel.add((Component)this.removeWordButton, gridBagConstraints);
        this.refreshRemovalCMB();
        this.numExclusion = new JCheckBox("Add the numbers 0 - 999 to the word exclusion list");
        buf = new StringBuffer();
        buf.append("<html>Causes numbers in the range 0 - 999 that appear as <b>separate words</b> to be excluded<br>");
        buf.append("<b>Hint:</b> To exclude numbers that appear within a word, either add the entire word to the exclusion list<br>");
        buf.append("or add the specific number to the list of delimiters used for word tokenization</html>");
        this.numExclusion.setToolTipText(buf.toString());
        this.numExclusion.addActionListener(this);
        this.numExclusion.setSelected(false);
        this.numExclusion.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        wordPanel.add((Component)this.numExclusion, gridBagConstraints);
        panel.add(wordPanel);
        collapsiblePanel.getContentPane().add((Component)panel, "North");
        return collapsiblePanel;
    }

    private CollapsiblePanel createTokenizationPanel() {
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel("Word Tokenization");
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(0, 1));
        JLabel addDelimiterLabel = new JLabel("Add Delimiter");
        WidestStringComboBoxModel wscbm = new WidestStringComboBoxModel();
        this.cmbDelimiterAddition = new JComboBox(wscbm);
        this.cmbDelimiterAddition.addPopupMenuListener(new WidestStringComboBoxPopupMenuListener());
        this.cmbDelimiterAddition.setEditable(false);
        Dimension d = this.cmbDelimiterAddition.getPreferredSize();
        this.cmbDelimiterAddition.setPreferredSize(new Dimension(15, d.height));
        this.cmbDelimiterAddition.addItemListener(this);
        StringBuffer buf = new StringBuffer();
        buf.append("<html>Allows for specification of an additional delimiter to be used when tokenizing nodes<br>");
        buf.append("<b>Acceptable Values:</b> Values entered must have proper escape character if necessary</html>");
        this.cmbDelimiterAddition.setToolTipText(buf.toString());
        this.addDelimiterButton = new JButton();
        this.addDelimiterButton.setText("Add");
        this.addDelimiterButton.setEnabled(false);
        this.addDelimiterButton.addActionListener(this);
        JPanel wordPanel = new JPanel();
        wordPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        wordPanel.add((Component)addDelimiterLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        wordPanel.add((Component)this.cmbDelimiterAddition, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        wordPanel.add((Component)this.addDelimiterButton, gridBagConstraints);
        JLabel removeDelimiterLabel = new JLabel("Remove Delimiter");
        wscbm = new WidestStringComboBoxModel();
        this.cmbDelimiterRemoval = new JComboBox(wscbm);
        this.cmbDelimiterRemoval.addPopupMenuListener(new WidestStringComboBoxPopupMenuListener());
        this.cmbDelimiterRemoval.setEditable(false);
        d = this.cmbDelimiterRemoval.getPreferredSize();
        this.cmbDelimiterRemoval.setPreferredSize(new Dimension(15, d.height));
        this.cmbDelimiterRemoval.addItemListener(this);
        this.cmbDelimiterRemoval.setToolTipText("Allows for selection of a delimiter to remove from the list used when tokenizing");
        this.removeDelimiterButton = new JButton();
        this.removeDelimiterButton.setText("Remove");
        this.removeDelimiterButton.setEnabled(false);
        this.removeDelimiterButton.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        wordPanel.add((Component)removeDelimiterLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        wordPanel.add((Component)this.cmbDelimiterRemoval, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        wordPanel.add((Component)this.removeDelimiterButton, gridBagConstraints);
        this.updateDelimiterCMBs();
        panel.add(wordPanel);
        collapsiblePanel.getContentPane().add((Component)panel, "North");
        return collapsiblePanel;
    }

    private CollapsiblePanel createCloudLayoutPanel() {
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel("Layout");
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(0, 1));
        JPanel cloudLayoutPanel = new JPanel();
        cloudLayoutPanel.setLayout(new GridBagLayout());
        JLabel cloudStyleLabel = new JLabel("Cloud Style: ");
        WidestStringComboBoxModel wscbm = new WidestStringComboBoxModel();
        this.cmbStyle = new JComboBox(wscbm);
        this.cmbStyle.addPopupMenuListener(new WidestStringComboBoxPopupMenuListener());
        this.cmbStyle.setEditable(false);
        Dimension d = this.cmbStyle.getPreferredSize();
        this.cmbStyle.setPreferredSize(new Dimension(15, d.height));
        StringBuffer toolTip = new StringBuffer();
        toolTip.append("<html>--Visual style for the cloud layout--<br>");
        toolTip.append("<b>Clustered:</b> If a style with clustering is selected, then the cloud will be comprised of groups of words.<br>");
        toolTip.append("Each cluster is build by analyzing which words appear next to each other and what order they appear.<br>");
        toolTip.append("<b> No Clustering:</b> When a non-clustering option is selected, words appear in decreasing order of of size.");
        this.cmbStyle.setToolTipText(toolTip.toString());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        cloudLayoutPanel.add((Component)cloudStyleLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        cloudLayoutPanel.add((Component)this.cmbStyle, gridBagConstraints);
        this.buildStyleCMB();
        panel.add(cloudLayoutPanel);
        JLabel createNetworkLabel = new JLabel("Network View:");
        this.createNetworkButton = new JButton("Export Cloud to Network");
        this.createNetworkButton.setEnabled(false);
        this.createNetworkButton.setToolTipText("Creates a new network based on the current cloud");
        this.createNetworkButton.addActionListener((ActionListener)((Object)new CreateCloudNetworkAction()));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        cloudLayoutPanel.add((Component)createNetworkLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        cloudLayoutPanel.add((Component)this.createNetworkButton, gridBagConstraints);
        collapsiblePanel.getContentPane().add((Component)panel, "North");
        return collapsiblePanel;
    }

    private JPanel createBottomPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout());
        JButton deleteButton = new JButton("Delete");
        JButton updateButton = new JButton("Update");
        JButton createButton = new JButton("Create");
        createButton.addActionListener((ActionListener)((Object)new CreateCloudAction()));
        deleteButton.addActionListener((ActionListener)((Object)new DeleteCloudAction()));
        updateButton.addActionListener((ActionListener)((Object)new UpdateCloudAction()));
        panel.add(deleteButton);
        panel.add(updateButton);
        panel.add(createButton);
        return panel;
    }

    public void setNetworkList(SemanticSummaryParameters params) {
        this.networkLabel.setText("");
        this.listValues.clear();
        this.networkLabel.setText(params.getNetworkName());
        ArrayList<CloudParameters> clouds = new ArrayList<CloudParameters>(params.getClouds().values());
        Collections.sort(clouds);
        for (CloudParameters curParam : clouds) {
            String curCloud = curParam.getCloudName();
            this.listValues.addElement(curCloud);
        }
        SemanticSummaryManager.getInstance().setCurNetwork(params);
        SemanticSummaryManager.getInstance().setCurCloud(SemanticSummaryManager.getInstance().getNullCloudParameters());
        this.updateUI();
    }

    public void loadCurrentCloud(CloudParameters params) {
        this.attributeList.setSelectedItems(params.getAttributeNames());
        this.updateAttNames();
        this.maxWordsTextField.setValue(params.getMaxWords());
        this.clusterCutoffTextField.setValue(params.getClusterCutoff());
        this.cmbStyle.setSelectedItem(params.getDisplayStyle());
        this.addWordTextField.setText("");
        this.setupNetworkNormalization(params);
        SemanticSummaryParameters networkParams = SemanticSummaryManager.getInstance().getCurNetwork();
        if (networkParams.equals(SemanticSummaryManager.getInstance().getNullSemanticSummary())) {
            this.addWordTextField.setEditable(false);
            this.addWordButton.setEnabled(false);
            this.numExclusion.setEnabled(false);
            this.useNetworkCounts.setEnabled(false);
        } else {
            this.addWordTextField.setEditable(true);
            this.addWordButton.setEnabled(true);
            this.numExclusion.setEnabled(true);
            this.useNetworkCounts.setEnabled(true);
        }
        if (params.equals(SemanticSummaryManager.getInstance().getNullCloudParameters())) {
            this.createNetworkButton.setEnabled(false);
        } else {
            this.createNetworkButton.setEnabled(true);
        }
        SemanticSummaryManager.getInstance().setCurCloud(params);
        this.refreshNetworkSettings();
    }

    public void addNewCloud(CloudParameters params) {
        ListSelectionModel listSelectionModel = this.cloudList.getSelectionModel();
        listSelectionModel.removeListSelectionListener(this.handler);
        SemanticSummaryManager.getInstance().setCurCloud(params);
        String cloudName = params.getCloudName();
        this.listValues.addElement(cloudName);
        int index = this.listValues.lastIndexOf(cloudName);
        this.cloudList.setSelectedIndex(index);
        listSelectionModel.addListSelectionListener(this.handler);
    }

    public void setUserDefaults() {
        CloudParameters params = SemanticSummaryManager.getInstance().getCurCloud();
        this.attributeList.setSelectedIndex(0);
        this.updateAttNames();
        this.maxWordsTextField.setValue(params.getDefaultMaxWords());
        this.clusterCutoffTextField.setValue(params.getDefaultClusterCutoff());
        this.cmbStyle.setSelectedItem(params.getDefaultDisplayStyle());
        this.setupNetworkNormalization(params);
        this.sliderPanel.setNetNormValue(params.getDefaultNetWeight());
        this.refreshNetworkSettings();
        this.updateUI();
    }

    private void updateDelimiterCMBs() {
        DefaultComboBoxModel cmb = (DefaultComboBoxModel)this.cmbDelimiterAddition.getModel();
        cmb.removeAllElements();
        SemanticSummaryParameters networkParams = SemanticSummaryManager.getInstance().getCurNetwork();
        WordDelimiters curDelimiters = networkParams.getDelimiter();
        Boolean isNull = false;
        if (networkParams.equals(SemanticSummaryManager.getInstance().getNullSemanticSummary())) {
            isNull = true;
        }
        cmb.addElement(commonDelimiters);
        if (!isNull.booleanValue()) {
            for (String curDelim : curDelimiters.getDelimsToAdd()) {
                cmb.addElement(curDelim);
            }
        }
        cmb.addElement(userAddDelimiters);
        if (!isNull.booleanValue()) {
            cmb.addElement(selectMe);
        }
        this.cmbDelimiterAddition.repaint();
        cmb = (DefaultComboBoxModel)this.cmbDelimiterRemoval.getModel();
        cmb.removeAllElements();
        cmb.addElement(commonDelimiters);
        if (!isNull.booleanValue()) {
            for (String curDelim : curDelimiters.getDelimsInUse()) {
                cmb.addElement(curDelim);
            }
        }
        cmb.addElement(userAddDelimiters);
        if (!isNull.booleanValue()) {
            for (String curDelim : curDelimiters.getUserDelims()) {
                cmb.addElement(curDelim);
            }
        }
        this.cmbDelimiterRemoval.repaint();
    }

    private void updateCMBRemoval() {
        int i;
        String curWord2;
        DefaultComboBoxModel cmb = (DefaultComboBoxModel)this.cmbRemoval.getModel();
        cmb.removeAllElements();
        SemanticSummaryParameters networkParams = SemanticSummaryManager.getInstance().getCurNetwork();
        WordFilter curFilter = networkParams.getFilter();
        Boolean isNull = false;
        if (networkParams.equals(SemanticSummaryManager.getInstance().getNullSemanticSummary())) {
            isNull = true;
        }
        cmb.addElement(addedSeparator);
        if (!isNull.booleanValue()) {
            ArrayList<String> addedList = new ArrayList<String>();
            for (String curWord2 : curFilter.getAddedWords()) {
                addedList.add(curWord2);
            }
            Collections.sort(addedList);
            for (i = 0; i < addedList.size(); ++i) {
                curWord2 = (String)addedList.get(i);
                cmb.addElement(curWord2);
            }
        }
        cmb.addElement(flaggedSeparator);
        if (!isNull.booleanValue()) {
            ArrayList<String> flaggedList = new ArrayList<String>();
            for (String curWord2 : curFilter.getFlaggedWords()) {
                flaggedList.add(curWord2);
            }
            Collections.sort(flaggedList);
            for (i = 0; i < flaggedList.size(); ++i) {
                curWord2 = (String)flaggedList.get(i);
                cmb.addElement(curWord2);
            }
        }
        cmb.addElement(stopSeparator);
        if (!isNull.booleanValue()) {
            ArrayList<String> stopList = new ArrayList<String>();
            for (String curWord2 : curFilter.getStopWords()) {
                stopList.add(curWord2);
            }
            Collections.sort(stopList);
            for (int i2 = 0; i2 < stopList.size(); ++i2) {
                curWord2 = (String)stopList.get(i2);
                cmb.addElement(curWord2);
            }
        }
    }

    public void refreshRemovalCMB() {
        this.updateCMBRemoval();
        this.cmbRemoval.repaint();
    }

    private void updateNumExclusionBox() {
        SemanticSummaryParameters networkParams = SemanticSummaryManager.getInstance().getCurNetwork();
        WordFilter curFilter = networkParams.getFilter();
        Boolean val = curFilter.getFilterNums();
        this.numExclusion.setSelected(val);
    }

    public void refreshNetworkSettings() {
        this.refreshRemovalCMB();
        this.updateNumExclusionBox();
        this.updateDelimiterCMBs();
    }

    private void updateCMBAttributes() {
        int i;
        ListSelectionListener[] listeners = this.attributeList.getListSelectionListeners();
        for (int i2 = 0; i2 < listeners.length; ++i2) {
            ListSelectionListener curListener = listeners[i2];
            this.attributeList.removeListSelectionListener(curListener);
        }
        DefaultListModel listModel = (DefaultListModel)this.attributeList.getModel();
        listModel.removeAllElements();
        listModel.addElement(SemanticSummaryManager.getInstance().getNullCloudParameters().getDefaultAttName());
        Vector<Object> av = this.getCyAttributesList("node");
        for (i = 0; i < av.size(); ++i) {
            listModel.addElement(av.elementAt(i));
        }
        for (i = 0; i < listeners.length; ++i) {
            ListSelectionListener curListener = listeners[i];
            this.attributeList.addListSelectionListener(curListener);
        }
    }

    public void refreshAttributeCMB() {
        this.updateCMBAttributes();
        CloudParameters curCloud = SemanticSummaryManager.getInstance().getCurCloud();
        ArrayList<String> curAttList = curCloud == SemanticSummaryManager.getInstance().getNullCloudParameters() ? curCloud.getAttributeNames() : curCloud.getAttributeNames();
        this.attributeList.setSelectedItems(curAttList);
        this.attributeList.repaint();
    }

    private void buildStyleCMB() {
        DefaultComboBoxModel cmb = (DefaultComboBoxModel)this.cmbStyle.getModel();
        cmb.removeAllElements();
        cmb.addElement(CloudDisplayStyles.CLUSTERED_STANDARD);
        cmb.addElement(CloudDisplayStyles.CLUSTERED_BOXES);
        cmb.addElement(CloudDisplayStyles.NO_CLUSTERING);
        this.cmbStyle.setSelectedItem(CloudDisplayStyles.DEFAULT_STYLE);
        this.cmbStyle.repaint();
    }

    private Vector<Object> getCyAttributesList(String pType) {
        Vector<String> attributeList = new Vector<String>();
        CyAttributes attributes = null;
        if (pType.equalsIgnoreCase("node")) {
            attributes = Cytoscape.getNodeAttributes();
        } else if (pType.equalsIgnoreCase("edge")) {
            attributes = Cytoscape.getEdgeAttributes();
        }
        String[] attributeNames = attributes.getAttributeNames();
        if (attributeNames != null) {
            for (int i = 0; i < attributeNames.length; ++i) {
                byte type = attributes.getType(attributeNames[i]);
                if (!attributes.getUserVisible(attributeNames[i]) || attributeNames[i].contains("vizmap")) continue;
                if (type == 4) {
                    attributeList.add(attributeNames[i]);
                    continue;
                }
                if (type != -2) continue;
                attributeList.add(attributeNames[i]);
            }
            Collections.sort(attributeList);
        }
        Vector<Object> retList = new Vector<Object>();
        for (int i = 0; i < attributeList.size(); ++i) {
            retList.add(attributeList.elementAt(i));
        }
        return retList;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source instanceof JComboBox) {
            String selectItem;
            Object selectObject;
            JComboBox cmb = (JComboBox)source;
            if (cmb == this.cmbRemoval && (selectObject = this.cmbRemoval.getSelectedItem()) != null) {
                selectItem = selectObject.toString();
                if (selectItem.equalsIgnoreCase(addedSeparator) || selectItem.equalsIgnoreCase(flaggedSeparator) || selectItem.equalsIgnoreCase(stopSeparator)) {
                    this.removeWordButton.setEnabled(false);
                } else {
                    this.removeWordButton.setEnabled(true);
                }
            }
            if (cmb == this.cmbDelimiterRemoval && (selectObject = this.cmbDelimiterRemoval.getSelectedItem()) != null) {
                selectItem = selectObject.toString();
                if (selectItem.equalsIgnoreCase(commonDelimiters) || selectItem.equalsIgnoreCase(userAddDelimiters)) {
                    this.removeDelimiterButton.setEnabled(false);
                } else {
                    this.removeDelimiterButton.setEnabled(true);
                }
            }
            if (cmb == this.cmbDelimiterAddition && (selectObject = this.cmbDelimiterAddition.getSelectedItem()) != null) {
                selectItem = selectObject.toString();
                if (selectItem.equalsIgnoreCase(commonDelimiters) || selectItem.equalsIgnoreCase(userAddDelimiters)) {
                    this.addDelimiterButton.setEnabled(false);
                } else {
                    this.addDelimiterButton.setEnabled(true);
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object _actionObject = e.getSource();
        if (_actionObject instanceof JButton) {
            WordDelimiters curDelimiters;
            SemanticSummaryParameters networkParams;
            String selectItem;
            Object selectObject;
            JButton _btn = (JButton)_actionObject;
            if (!(_btn != this.removeWordButton || (selectObject = this.cmbRemoval.getSelectedItem()) == null || (selectItem = selectObject.toString()).equalsIgnoreCase(addedSeparator) && selectItem.equalsIgnoreCase(flaggedSeparator) && selectItem.equalsIgnoreCase(stopSeparator))) {
                networkParams = SemanticSummaryManager.getInstance().getCurNetwork();
                WordFilter curFilter = networkParams.getFilter();
                curFilter.remove(selectItem);
                networkParams.networkChanged();
                this.refreshRemovalCMB();
            }
            if (_btn == this.addWordButton) {
                String value = this.addWordTextField.getText();
                if (value.matches("")) {
                    return;
                }
                if (value.matches("[\\w]*")) {
                    SemanticSummaryParameters networkParams2 = SemanticSummaryManager.getInstance().getCurNetwork();
                    WordFilter curFilter = networkParams2.getFilter();
                    value.toLowerCase();
                    curFilter.add(value);
                    networkParams2.networkChanged();
                    this.refreshRemovalCMB();
                    this.addWordTextField.setText(null);
                } else {
                    this.addWordTextField.setSelectionStart(0);
                    this.addWordTextField.setSelectionEnd(value.length());
                    this.addWordTextField.updateUI();
                    String message = "You can only add a word that contains letters or numbers and no spaces";
                    JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), message, "Parameter out of bounds", 2);
                }
            }
            if (!(_btn != this.removeDelimiterButton || (selectObject = this.cmbDelimiterRemoval.getSelectedItem()) == null || (selectItem = selectObject.toString()).equalsIgnoreCase(commonDelimiters) && selectItem.equalsIgnoreCase(userAddDelimiters))) {
                networkParams = SemanticSummaryManager.getInstance().getCurNetwork();
                curDelimiters = networkParams.getDelimiter();
                curDelimiters.removeDelimiter(selectItem);
                networkParams.networkChanged();
                this.updateDelimiterCMBs();
            }
            if (!(_btn != this.addDelimiterButton || (selectObject = this.cmbDelimiterAddition.getSelectedItem()) == null || (selectItem = selectObject.toString()).equalsIgnoreCase(commonDelimiters) && selectItem.equalsIgnoreCase(userAddDelimiters))) {
                if (selectItem.equals(selectMe)) {
                    CytoscapeDesktop parent = Cytoscape.getDesktop();
                    AddDelimiterDialog dialog = new AddDelimiterDialog((Component)parent, true);
                    dialog.setLocationRelativeTo((Component)parent);
                    dialog.setVisible(true);
                    selectItem = dialog.getNewDelimiter();
                }
                if (!selectItem.equals("")) {
                    networkParams = SemanticSummaryManager.getInstance().getCurNetwork();
                    curDelimiters = networkParams.getDelimiter();
                    curDelimiters.addDelimToUse(selectItem);
                    networkParams.networkChanged();
                    this.updateDelimiterCMBs();
                }
            }
        } else if (_actionObject instanceof JCheckBox) {
            Boolean selected;
            JCheckBox _box = (JCheckBox)_actionObject;
            if (_box == this.numExclusion) {
                selected = this.numExclusion.isSelected();
                SemanticSummaryParameters networkParams = SemanticSummaryManager.getInstance().getCurNetwork();
                WordFilter curFilter = networkParams.getFilter();
                curFilter.setFilterNums(selected);
                networkParams.networkChanged();
            }
            if (_box == this.useNetworkCounts) {
                selected = this.useNetworkCounts.isSelected();
                CloudParameters cloudParams = SemanticSummaryManager.getInstance().getCurCloud();
                if (!cloudParams.equals(SemanticSummaryManager.getInstance().getNullCloudParameters())) {
                    cloudParams.setUseNetNormal(selected);
                }
                if (selected.booleanValue()) {
                    this.sliderPanel.setVisible(true);
                    this.sliderPanel.setEnabled(true);
                    Double netNormalization = cloudParams.getNetWeightFactor();
                    this.sliderPanel.setNetNormValue(netNormalization);
                } else {
                    CytoscapeDesktop parent = Cytoscape.getDesktop();
                    int value = 1;
                    value = JOptionPane.showConfirmDialog((Component)parent, "Network normalization will now be set to 0.  Do you want to continue?", "Network Normalization", 0);
                    if (value == 0) {
                        this.sliderPanel.setVisible(false);
                        this.sliderPanel.setEnabled(false);
                        cloudParams.setNetWeightFactor(0.0);
                        this.sliderPanel.setNetNormValue(0.0);
                        UpdateCloudAction action = new UpdateCloudAction();
                        action.doRealAction();
                    } else {
                        this.sliderPanel.setVisible(true);
                        this.sliderPanel.setEnabled(true);
                        Double netNormalization = cloudParams.getNetWeightFactor();
                        this.sliderPanel.setNetNormValue(netNormalization);
                        this.useNetworkCounts.setSelected(true);
                        cloudParams.setUseNetNormal(true);
                    }
                }
            }
        }
    }

    private void setupNetworkNormalization(CloudParameters params) {
        ChangeListener[] listeners = this.sliderPanel.getSlider().getChangeListeners();
        for (int i = 0; i < listeners.length; ++i) {
            this.sliderPanel.getSlider().removeChangeListener(listeners[i]);
        }
        Boolean useNetNorm = params.getUseNetNormal();
        this.useNetworkCounts.setSelected(useNetNorm);
        this.sliderPanel.setVisible(useNetNorm);
        this.sliderPanel.setEnabled(useNetNorm);
        this.sliderPanel.setNetNormValue(params.getNetWeightFactor());
        this.sliderPanel.setLabel(this.sliderPanel.getSlider().getValue());
        for (int i = 0; i < listeners.length; ++i) {
            this.sliderPanel.getSlider().addChangeListener(listeners[i]);
        }
    }

    private void updateAttNames() {
        String nameList = "";
        if (!this.attributeList.isSelectionEmpty()) {
            Object[] names = this.attributeList.getSelectedValues();
            for (int i = 0; i < names.length; ++i) {
                if (!(names[i] instanceof String)) continue;
                String curName = (String)names[i];
                nameList = i != names.length - 1 ? nameList + curName + "\n" : nameList + curName;
            }
        }
        this.attNames.setText(nameList);
    }

    public JFormattedTextField getMaxWordsTextField() {
        return this.maxWordsTextField;
    }

    public JFormattedTextField getClusterCutoffTextField() {
        return this.clusterCutoffTextField;
    }

    public JTextField getAddWordTextField() {
        return this.addWordTextField;
    }

    public JButton getAddWordButton() {
        return this.addWordButton;
    }

    public JLabel getNetworkLabel() {
        return this.networkLabel;
    }

    public DefaultListModel getListValues() {
        return this.listValues;
    }

    public JList getCloudList() {
        return this.cloudList;
    }

    public JComboBox getCMBRemoval() {
        return this.cmbRemoval;
    }

    public JComboBox getCMBStyle() {
        return this.cmbStyle;
    }

    public CloudListSelectionHandler getCloudListSelectionHandler() {
        return this.handler;
    }

    public JCheckBox getNumExclusion() {
        return this.numExclusion;
    }

    public void setNumExclusion(JCheckBox box) {
        this.numExclusion = box;
    }

    public JComboBox getCMBDelimiterRemoval() {
        return this.cmbDelimiterRemoval;
    }

    public JComboBox getCMBDelimiterAddition() {
        return this.cmbDelimiterAddition;
    }

    public JButton getAddDelimiterButton() {
        return this.addDelimiterButton;
    }

    public JButton getRemoveDelimiterButton() {
        return this.removeDelimiterButton;
    }

    public JCheckBox getUseNetworkCounts() {
        return this.useNetworkCounts;
    }

    public SliderBarPanel getSliderBarPanel() {
        return this.sliderPanel;
    }

    public CheckBoxJList getAttributeList() {
        return this.attributeList;
    }

    public JPopupMenu getAttributePopupMenu() {
        return this.attributeSelectionPopupMenu;
    }

    public JTextArea getAttNames() {
        return this.attNames;
    }

    public JButton getCreateNetworkButton() {
        return this.createNetworkButton;
    }

    private class FormattedTextFieldAction
    implements PropertyChangeListener {
        private FormattedTextFieldAction() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            String value;
            JFormattedTextField source = (JFormattedTextField)e.getSource();
            CloudParameters params = SemanticSummaryManager.getInstance().getCurCloud();
            String message = "The value you have entered is invalid. \n";
            boolean invalid = false;
            if (source == SemanticSummaryInputPanel.this.maxWordsTextField) {
                Number value2 = (Number)SemanticSummaryInputPanel.this.maxWordsTextField.getValue();
                if (value2 == null || value2.intValue() < 0) {
                    Integer defaultMaxWords = params.getDefaultMaxWords();
                    SemanticSummaryInputPanel.this.maxWordsTextField.setValue(defaultMaxWords);
                    message = message + "The maximum number of words to display must be greater than or equal to 0.";
                    invalid = true;
                }
            } else if (source == SemanticSummaryInputPanel.this.clusterCutoffTextField) {
                Number value3 = (Number)SemanticSummaryInputPanel.this.clusterCutoffTextField.getValue();
                if (value3 == null || !(value3.doubleValue() >= 0.0)) {
                    Double defaultClusterCutoff = params.getDefaultClusterCutoff();
                    SemanticSummaryInputPanel.this.clusterCutoffTextField.setValue(defaultClusterCutoff);
                    message = message + "The cluster cutoff must be greater than or equal to 0";
                    invalid = true;
                }
            } else if (source != SemanticSummaryInputPanel.this.addWordTextField || (value = SemanticSummaryInputPanel.this.addWordTextField.getText()).equals("") || value.matches("[\\w]*")) {
                // empty if block
            }
            if (invalid) {
                JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), message, "Parameter out of bounds", 2);
            }
        }
    }
}

