/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.csplugins.wordcloud;

import cytoscape.csplugins.wordcloud.CloudParameters;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleWordCluster
implements Comparable<SingleWordCluster> {
    private ArrayList<String> wordList = new ArrayList();
    private Integer totalSum = 0;
    private Integer numItems = 0;
    private CloudParameters params = new CloudParameters();
    private boolean initialized = false;

    public void initialize(CloudParameters cloudParams) {
        this.params = cloudParams;
        this.initialized = true;
    }

    public void add(String aWord) {
        if (!this.initialized) {
            return;
        }
        Integer fontSize = this.params.calculateFontSize(aWord);
        this.totalSum = this.totalSum + fontSize;
        this.numItems = this.numItems + 1;
        this.wordList.add(aWord);
    }

    public String remove(String aWord) {
        if (!this.wordList.contains(aWord)) {
            return null;
        }
        Integer fontSize = this.params.calculateFontSize(aWord);
        this.totalSum = this.totalSum - fontSize;
        this.numItems = this.numItems - 1;
        this.wordList.remove(aWord);
        return aWord;
    }

    public Double computeRootMean() {
        if (this.totalSum == 0 || this.numItems == 0) {
            return 0.0;
        }
        return (double)this.totalSum.intValue() / Math.pow(this.numItems.intValue(), 0.5);
    }

    public Integer getLargestFont() {
        Integer largest = 0;
        for (String curWord : this.wordList) {
            Integer curSize = this.params.calculateFontSize(curWord);
            if (largest >= curSize) continue;
            largest = curSize;
        }
        return largest;
    }

    public Double calculateWeightedSum() {
        Double sum = 0.0;
        Double k = 2.0;
        for (String curWord : this.wordList) {
            Integer curSize = this.params.calculateFontSize(curWord);
            sum = sum + Math.pow(curSize.intValue(), k);
        }
        sum = Math.pow(sum, 1.0 / k);
        return sum;
    }

    @Override
    public int compareTo(SingleWordCluster o) {
        Double thisCount = this.calculateWeightedSum();
        Double compareCount = o.calculateWeightedSum();
        if (thisCount < compareCount) {
            return -1;
        }
        if (thisCount > compareCount) {
            return 1;
        }
        String thisWord = this.getWordList().get(0);
        String compareWord = this.getWordList().get(0);
        return thisWord.compareTo(compareWord);
    }

    public ArrayList<String> getWordList() {
        return this.wordList;
    }

    public Integer getTotalSum() {
        return this.totalSum;
    }

    public Integer getNumItems() {
        return this.numItems;
    }
}

