/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.csplugins.wordcloud;

import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.csplugins.wordcloud.CloudDisplayStyles;
import cytoscape.csplugins.wordcloud.CloudWordInfo;
import cytoscape.csplugins.wordcloud.SemanticSummaryClusterBuilder;
import cytoscape.csplugins.wordcloud.SemanticSummaryInputPanel;
import cytoscape.csplugins.wordcloud.SemanticSummaryManager;
import cytoscape.csplugins.wordcloud.SemanticSummaryParameters;
import cytoscape.csplugins.wordcloud.SliderBarPanel;
import cytoscape.csplugins.wordcloud.WordDelimiters;
import cytoscape.csplugins.wordcloud.WordFilter;
import cytoscape.data.CyAttributes;
import cytoscape.view.CytoscapeDesktop;
import java.awt.Component;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.JFormattedTextField;
import javax.swing.JOptionPane;
import javax.swing.JSlider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloudParameters
implements Comparable<CloudParameters> {
    private String cloudName;
    private ArrayList<String> attributeNames;
    private String displayStyle;
    private SemanticSummaryParameters networkParams;
    private List<String> selectedNodes;
    private Integer selectedNumNodes;
    private Integer networkNumNodes;
    private Integer maxWords;
    private Integer cloudNum;
    private HashMap<String, List<String>> stringNodeMapping;
    private HashMap<String, Integer> networkCounts;
    private HashMap<String, Integer> selectedCounts;
    private HashMap<String, Integer> networkPairCounts;
    private HashMap<String, Integer> selectedPairCounts;
    private HashMap<String, Double> ratios;
    private HashMap<String, Double> pairRatios;
    private ArrayList<CloudWordInfo> cloudWords;
    private Double netWeightFactor;
    private Double clusterCutoff;
    private Double minRatio;
    private Double maxRatio;
    private Double meanRatio;
    private Double meanWeight;
    private Double minWeight;
    private Double maxWeight;
    private boolean countInitialized = false;
    private boolean selInitialized = false;
    private boolean ratiosInitialized = false;
    private boolean useNetNormal = false;
    private static final String NODEDELIMITER = "CloudParamNodeDelimiter";
    private static final String WORDDELIMITER = "CloudParamWordDelimiter";
    private static final char controlChar = '\u001f';
    private Integer networkCount = 1;
    private static final String NETWORKNAME = "Net";
    private static final String SEPARATER = "_";
    private Double defaultNetWeight = 0.0;
    private String defaultAttName = "nodeID";
    private Integer defaultMaxWords = 250;
    private Double defaultClusterCutoff = 1.0;
    private String defaultStyle = CloudDisplayStyles.DEFAULT_STYLE;

    public CloudParameters() {
        this.selectedNodes = new ArrayList<String>();
        this.stringNodeMapping = new HashMap();
        this.networkCounts = new HashMap();
        this.selectedCounts = new HashMap();
        this.networkPairCounts = new HashMap();
        this.selectedPairCounts = new HashMap();
        this.ratios = new HashMap();
        this.pairRatios = new HashMap();
        this.cloudWords = new ArrayList();
        this.netWeightFactor = this.getDefaultNetWeight();
        this.clusterCutoff = this.getDefaultClusterCutoff();
        this.maxWords = this.getDefaultMaxWords();
        this.displayStyle = this.getDefaultDisplayStyle();
        this.attributeNames = new ArrayList();
        this.attributeNames.add(this.getDefaultAttName());
    }

    public CloudParameters(String propFile) {
        this();
        HashMap<String, String> props = new HashMap<String, String>();
        String[] lines = propFile.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            String[] tokens = line.split("\t");
            if (tokens.length != 2) continue;
            props.put(tokens[0], tokens[1]);
        }
        this.cloudName = (String)props.get("CloudName");
        this.displayStyle = (String)props.get("DisplayStyle");
        this.selectedNumNodes = new Integer((String)props.get("SelectedNumNodes"));
        this.networkNumNodes = new Integer((String)props.get("NetworkNumNodes"));
        this.netWeightFactor = new Double((String)props.get("NetWeightFactor"));
        this.clusterCutoff = new Double((String)props.get("ClusterCutoff"));
        this.countInitialized = Boolean.parseBoolean((String)props.get("CountInitialized"));
        this.selInitialized = Boolean.parseBoolean((String)props.get("SelInitialized"));
        this.ratiosInitialized = Boolean.parseBoolean((String)props.get("RatiosInitialized"));
        this.maxRatio = new Double((String)props.get("MaxRatio"));
        this.minRatio = new Double((String)props.get("MinRatio"));
        this.maxWords = new Integer((String)props.get("MaxWords"));
        this.cloudNum = new Integer((String)props.get("CloudNum"));
        String val = (String)props.get("UseNetNormal");
        this.useNetNormal = val == null ? true : Boolean.parseBoolean((String)props.get("UseNetNormal"));
        val = (String)props.get("MeanRatio");
        if (val == null) {
            this.ratiosInitialized = false;
        } else {
            this.meanRatio = new Double((String)props.get("MeanRatio"));
        }
        val = (String)props.get("MeanWeight");
        if (val != null) {
            this.meanWeight = new Double((String)props.get("MeanWeight"));
        }
        if ((val = (String)props.get("MinWeight")) != null) {
            this.minWeight = new Double((String)props.get("MinWeight"));
        }
        if ((val = (String)props.get("MaxWeight")) != null) {
            this.maxWeight = new Double((String)props.get("MaxWeight"));
        }
        if ((val = (String)props.get("NetworkCount")) != null) {
            this.networkCount = new Integer((String)props.get("NetworkCount"));
        }
        String value = (String)props.get("AttributeName");
        String[] attributes = value.split(WORDDELIMITER);
        ArrayList<String> attributeList = new ArrayList<String>();
        for (int i = 0; i < attributes.length; ++i) {
            String curAttribute = attributes[i];
            attributeList.add(curAttribute);
        }
        this.attributeNames = attributeList;
        value = (String)props.get("SelectedNodes");
        String[] nodes = value.split(NODEDELIMITER);
        ArrayList<String> nodeNameList = new ArrayList<String>();
        for (int i = 0; i < nodes.length; ++i) {
            String nodeName = nodes[i];
            nodeNameList.add(nodeName);
        }
        this.selectedNodes = nodeNameList;
        if (props.containsKey("CloudWords")) {
            String value2 = (String)props.get("CloudWords");
            String[] words = value2.split(WORDDELIMITER);
            ArrayList<CloudWordInfo> cloudWordList = new ArrayList<CloudWordInfo>();
            for (int i = 0; i < words.length; ++i) {
                String wordInfo = words[i];
                CloudWordInfo curInfo = new CloudWordInfo(wordInfo);
                curInfo.setCloudParameters(this);
                cloudWordList.add(curInfo);
            }
            this.cloudWords = cloudWordList;
        } else {
            this.cloudWords = new ArrayList();
        }
    }

    public void initializeNetworkCounts() {
        if (this.countInitialized) {
            return;
        }
        this.networkCounts = new HashMap();
        this.networkPairCounts = new HashMap();
        this.stringNodeMapping = new HashMap();
        SemanticSummaryParameters networkParams = this.getNetworkParams();
        List<String> networkNodes = networkParams.getNetworkNodes();
        for (String curNodeID : networkNodes) {
            CyNode curNode = Cytoscape.getCyNode((String)curNodeID);
            if (curNode == null) {
                CytoscapeDesktop desktop = Cytoscape.getDesktop();
                JOptionPane.showMessageDialog((Component)desktop, "Node no longer exists: " + curNodeID);
                continue;
            }
            for (int i = 0; i < this.attributeNames.size(); ++i) {
                String curAttribute = this.attributeNames.get(i);
                String nodeValue = this.getNodeAttributeVal(curNode, curAttribute);
                if (nodeValue == null) continue;
                List<String> wordSet = this.processNodeString(nodeValue);
                String lastWord = "";
                for (String curWord : wordSet) {
                    WordFilter filter = networkParams.getFilter();
                    if (filter.contains(curWord)) continue;
                    HashMap<String, List<String>> curMapping = this.getStringNodeMapping();
                    if (!curMapping.containsKey(curWord)) {
                        curMapping.put(curWord, new ArrayList());
                        this.networkCounts.put(curWord, 0);
                    }
                    curMapping.get(curWord).add(curNode.toString());
                    Integer num = this.networkCounts.get(curWord);
                    num = num + 1;
                    this.networkCounts.put(curWord, num);
                    if (!lastWord.equals("")) {
                        Integer curPairCount = 0;
                        String pairName = lastWord + '\u001f' + curWord;
                        if (this.networkPairCounts.containsKey(pairName)) {
                            curPairCount = this.networkPairCounts.get(pairName);
                        }
                        curPairCount = curPairCount + 1;
                        this.networkPairCounts.put(pairName, curPairCount);
                    }
                    lastWord = curWord;
                }
            }
        }
        this.networkNumNodes = networkNodes.size() * this.attributeNames.size();
        this.countInitialized = true;
    }

    public void updateSelectedCounts() {
        if (this.selInitialized) {
            return;
        }
        if (!this.countInitialized) {
            this.initializeNetworkCounts();
        }
        this.selectedCounts = new HashMap();
        this.selectedPairCounts = new HashMap();
        List<String> selectedNodes = this.getSelectedNodes();
        for (String curNodeID : selectedNodes) {
            CyNode curNode = Cytoscape.getCyNode((String)curNodeID);
            if (curNode == null) {
                CytoscapeDesktop desktop = Cytoscape.getDesktop();
                JOptionPane.showMessageDialog((Component)desktop, "Node no longer exists: " + curNodeID);
                continue;
            }
            for (int i = 0; i < this.attributeNames.size(); ++i) {
                String curAttribute = this.attributeNames.get(i);
                String nodeValue = this.getNodeAttributeVal(curNode, curAttribute);
                if (nodeValue == null) continue;
                List<String> wordSet = this.processNodeString(nodeValue);
                String lastWord = "";
                for (String curWord : wordSet) {
                    WordFilter filter = this.networkParams.getFilter();
                    if (filter.contains(curWord)) continue;
                    Integer curCount = 0;
                    if (this.selectedCounts.containsKey(curWord)) {
                        curCount = this.selectedCounts.get(curWord);
                    }
                    curCount = curCount + 1;
                    this.selectedCounts.put(curWord, curCount);
                    if (!lastWord.equals("")) {
                        Integer curPairCount = 0;
                        String pairName = lastWord + '\u001f' + curWord;
                        if (this.selectedPairCounts.containsKey(pairName)) {
                            curPairCount = this.selectedPairCounts.get(pairName);
                        }
                        curPairCount = curPairCount + 1;
                        this.selectedPairCounts.put(pairName, curPairCount);
                    }
                    lastWord = curWord;
                }
            }
        }
        this.selectedNumNodes = selectedNodes.size() * this.attributeNames.size();
        this.calculateWeights();
        this.selInitialized = true;
    }

    public void calculateWeights() {
        Double curMin = 0.0;
        Double curMax = 0.0;
        Double total = 0.0;
        int count = 0;
        Set<String> words = this.selectedCounts.keySet();
        Iterator<String> iter = words.iterator();
        boolean initialized = false;
        while (iter.hasNext()) {
            String curWord = iter.next();
            Integer selTotal = this.getSelectedNumNodes();
            Integer selCount = this.selectedCounts.get(curWord);
            Integer netCount = this.networkCounts.get(curWord);
            Double newNetCount = Math.pow(netCount.intValue(), 0.0);
            Integer netTotal = this.getNetworkNumNodes();
            Double newNetTotal = Math.pow(netTotal.intValue(), 0.0);
            Double numerator = (double)selCount.intValue() * newNetTotal;
            Double denominator = (double)selTotal.intValue() * newNetCount;
            Double ratio = numerator / denominator;
            total = total + ratio;
            ++count;
            if (!initialized) {
                curMax = ratio;
                curMin = ratio;
                initialized = true;
            }
            if (ratio > curMax) {
                curMax = ratio;
            }
            if (!(ratio < curMin)) continue;
            curMin = ratio;
        }
        this.setMinWeight(curMin);
        this.setMeanWeight(total / (double)count);
        this.setMaxWeight(curMax);
    }

    public void updateRatios() {
        if (this.ratiosInitialized) {
            return;
        }
        if (!this.selInitialized) {
            this.updateSelectedCounts();
        }
        if (this.meanWeight == null || this.minWeight == null || this.maxWeight == null) {
            this.calculateWeights();
        }
        this.ratios = new HashMap();
        Double curMin = 0.0;
        Double curMax = 0.0;
        Double total = 0.0;
        int count = 0;
        Set<String> words = this.selectedCounts.keySet();
        Iterator<String> iter = words.iterator();
        boolean initialized = false;
        while (iter.hasNext()) {
            String curWord = iter.next();
            Integer selTotal = this.getSelectedNumNodes();
            Integer selCount = this.selectedCounts.get(curWord);
            Integer netCount = this.networkCounts.get(curWord);
            Double newNetCount = Math.pow(netCount.intValue(), this.netWeightFactor);
            Integer netTotal = this.getNetworkNumNodes();
            Double newNetTotal = Math.pow(netTotal.intValue(), this.netWeightFactor);
            Double numerator = (double)selCount.intValue() * newNetTotal;
            Double denominator = (double)selTotal.intValue() * newNetCount;
            Double ratio = numerator / denominator;
            this.ratios.put(curWord, ratio);
            total = total + ratio;
            ++count;
            if (!initialized) {
                curMax = ratio;
                curMin = ratio;
                initialized = true;
            }
            if (ratio > curMax) {
                curMax = ratio;
            }
            if (!(ratio < curMin)) continue;
            curMin = ratio;
        }
        this.setMaxRatio(curMax);
        this.setMinRatio(curMin);
        this.setMeanRatio(total / (double)count);
        this.pairRatios = new HashMap();
        words = this.selectedPairCounts.keySet();
        for (String curWord : words) {
            Integer selTotal = this.getSelectedNumNodes();
            Integer selPairCount = this.selectedPairCounts.get(curWord);
            Integer netPairCount = this.networkPairCounts.get(curWord);
            Double newNetCount = Math.pow(netPairCount.intValue(), this.netWeightFactor);
            Integer netTotal = this.getNetworkNumNodes();
            Double newNetTotal = Math.pow(netTotal.intValue(), this.netWeightFactor);
            Double numerator = (double)selPairCount.intValue() * newNetTotal;
            Double denominator = (double)selTotal.intValue() * newNetCount;
            Double ratio = numerator / denominator;
            this.pairRatios.put(curWord, ratio);
        }
        this.ratiosInitialized = true;
    }

    public void calculateFontSizes() {
        if (!this.ratiosInitialized) {
            this.updateRatios();
        }
        this.cloudWords = new ArrayList();
        if (this.displayStyle.equals(CloudDisplayStyles.NO_CLUSTERING)) {
            Set<String> words = this.ratios.keySet();
            for (String curWord : words) {
                Integer fontSize = this.calculateFontSize(curWord);
                CloudWordInfo curInfo = new CloudWordInfo(curWord, fontSize);
                curInfo.setCloudParameters(this);
                this.cloudWords.add(curInfo);
            }
            Collections.sort(this.cloudWords);
        } else {
            SemanticSummaryClusterBuilder builder = new SemanticSummaryClusterBuilder();
            builder.initialize(this);
            builder.clusterData(this.getClusterCutoff());
            builder.buildCloudWords();
            this.cloudWords = builder.getCloudWords();
        }
    }

    public Integer calculateFontSize(String aWord) {
        if (!this.ratios.containsKey(aWord)) {
            return 0;
        }
        Double ratio = this.ratios.get(aWord);
        Double zeroedMinWeight = this.minWeight - this.minWeight;
        Double zeroedMeanWeight = this.meanWeight - this.minWeight;
        Double zeroedMaxWeight = this.maxWeight - this.minWeight;
        Double zeroedMinRatio = this.minRatio - this.minRatio;
        Double zeroedMeanRatio = this.meanRatio - this.minRatio;
        Double zeroedMaxRatio = this.maxRatio - this.minRatio;
        Double zeroedRatio = ratio - this.minRatio;
        Double newRatio = zeroedRatio * zeroedMeanWeight / zeroedMeanRatio;
        Integer maxFont = this.networkParams.getMaxFont();
        Integer minFont = this.networkParams.getMinFont();
        if (zeroedMaxRatio.equals(zeroedMinRatio)) {
            return minFont + (maxFont - minFont) / 2;
        }
        Double slope = (double)(maxFont - minFont) / (zeroedMaxWeight - zeroedMinWeight);
        Double yIntercept = (double)maxFont.intValue() - slope * zeroedMaxWeight;
        long temp = Math.round(slope * newRatio + yIntercept);
        Integer fontSize = Math.round(temp);
        return fontSize;
    }

    public void retrieveInputVals() {
        SemanticSummaryInputPanel inputPanel = SemanticSummaryManager.getInstance().getInputWindow();
        SliderBarPanel panel = inputPanel.getSliderBarPanel();
        JSlider slider = panel.getSlider();
        Double netNorm = (double)slider.getValue() / panel.getPrecision();
        this.setNetWeightFactor(netNorm);
        Boolean selected = inputPanel.getUseNetworkCounts().isSelected();
        this.useNetNormal = selected;
        Object[] attributes = inputPanel.getAttributeList().getSelectedValues();
        ArrayList<String> attributeList = new ArrayList<String>();
        for (int i = 0; i < attributes.length; ++i) {
            Object curAttribute = attributes[i];
            if (curAttribute instanceof String) {
                attributeList.add((String)curAttribute);
            }
            this.setAttributeNames(attributeList);
        }
        JFormattedTextField maxWordsTextField = inputPanel.getMaxWordsTextField();
        Number value = (Number)maxWordsTextField.getValue();
        if (value != null && value.intValue() >= 0) {
            this.setMaxWords(value.intValue());
        } else {
            maxWordsTextField.setValue(this.defaultMaxWords);
            this.setMaxWords(this.defaultMaxWords);
            String message = "The maximum number of words to display must be greater than or equal to 0.";
            JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), message, "Parameter out of bounds", 2);
        }
        JFormattedTextField clusterCutoffTextField = inputPanel.getClusterCutoffTextField();
        value = (Number)clusterCutoffTextField.getValue();
        if (value != null && value.doubleValue() >= 0.0) {
            this.setClusterCutoff(value.doubleValue());
        } else {
            clusterCutoffTextField.setValue(this.defaultClusterCutoff);
            this.setClusterCutoff(this.defaultClusterCutoff);
            String message = "The cluster cutoff must be greater than or equal to 0";
            JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), message, "Parameter out of bounds", 2);
        }
        Object style = inputPanel.getCMBStyle().getSelectedItem();
        if (style instanceof String) {
            this.setDisplayStyle((String)style);
        } else {
            this.setDisplayStyle(this.defaultStyle);
            inputPanel.getCMBStyle().setSelectedItem(this.defaultStyle);
            String message = "You must select one of the available styles.";
            JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), message, "Parameter out of bounds", 2);
        }
    }

    public String toString() {
        int i;
        StringBuffer paramVariables = new StringBuffer();
        paramVariables.append("CloudName\t" + this.cloudName + "\n");
        paramVariables.append("DisplayStyle\t" + this.displayStyle + "\n");
        StringBuffer output = new StringBuffer();
        for (i = 0; i < this.selectedNodes.size(); ++i) {
            output.append(this.selectedNodes.get(i).toString() + NODEDELIMITER);
        }
        paramVariables.append("SelectedNodes\t" + output.toString() + "\n");
        output = new StringBuffer();
        for (i = 0; i < this.attributeNames.size(); ++i) {
            output.append(this.attributeNames.get(i) + WORDDELIMITER);
        }
        paramVariables.append("AttributeName\t" + output.toString() + "\n");
        paramVariables.append("NetworkNumNodes\t" + this.networkNumNodes + "\n");
        paramVariables.append("SelectedNumNodes\t" + this.selectedNumNodes + "\n");
        paramVariables.append("NetWeightFactor\t" + this.netWeightFactor + "\n");
        paramVariables.append("ClusterCutoff\t" + this.clusterCutoff + "\n");
        paramVariables.append("CountInitialized\t" + this.countInitialized + "\n");
        paramVariables.append("SelInitialized\t" + this.selInitialized + "\n");
        paramVariables.append("RatiosInitialized\t" + this.ratiosInitialized + "\n");
        paramVariables.append("MinRatio\t" + this.minRatio + "\n");
        paramVariables.append("MaxRatio\t" + this.maxRatio + "\n");
        paramVariables.append("MaxWords\t" + this.maxWords + "\n");
        paramVariables.append("MeanRatio\t" + this.meanRatio + "\n");
        paramVariables.append("MeanWeight\t" + this.meanWeight + "\n");
        paramVariables.append("MaxWeight\t" + this.maxWeight + "\n");
        paramVariables.append("MinWeight\t" + this.minWeight + "\n");
        paramVariables.append("CloudNum\t" + this.cloudNum + "\n");
        paramVariables.append("UseNetNormal\t" + this.useNetNormal + "\n");
        paramVariables.append("NetworkCount\t" + this.networkCount + "\n");
        StringBuffer output2 = new StringBuffer();
        for (int i2 = 0; i2 < this.cloudWords.size(); ++i2) {
            output2.append(this.cloudWords.get(i2).toString() + WORDDELIMITER);
        }
        paramVariables.append("CloudWords\t" + output2.toString() + "\n");
        return paramVariables.toString();
    }

    public String printHashMap(HashMap map) {
        StringBuffer result = new StringBuffer();
        for (Object key : map.keySet()) {
            Object value = map.get(key);
            StringBuffer stringValue = new StringBuffer();
            if (value instanceof List) {
                List valueList = (List)value;
                for (int i = 0; i < valueList.size(); ++i) {
                    String name = (String)valueList.get(i);
                    stringValue.append(name + NODEDELIMITER);
                }
            } else if (value instanceof Integer) {
                stringValue.append(value.toString());
            } else if (value instanceof Double) {
                stringValue.append(value.toString());
            } else {
                stringValue.append(value.toString());
            }
            result.append(key.toString() + "\t" + stringValue.toString() + "\n");
        }
        return result.toString();
    }

    public HashMap repopulateHashmap(String fileInput, int type) {
        HashMap<String, Serializable> newMap = type == 1 ? new HashMap<String, Serializable>() : (type == 2 ? new HashMap() : (type == 3 ? new HashMap() : new HashMap()));
        if (!fileInput.equals("")) {
            String[] lines = fileInput.split("\n");
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                String[] tokens = line.split("\t");
                if (type == 1) {
                    newMap.put(tokens[0], Integer.valueOf(Integer.parseInt(tokens[1])));
                }
                if (type == 2) {
                    String[] nodes = tokens[1].split(NODEDELIMITER);
                    ArrayList<String> nodeNames = new ArrayList<String>();
                    for (int j = 0; j < nodes.length; ++j) {
                        nodeNames.add(nodes[j]);
                    }
                    newMap.put(tokens[0], nodeNames);
                }
                if (type != 3) continue;
                newMap.put(tokens[0], Double.valueOf(Double.parseDouble(tokens[1])));
            }
        }
        return newMap;
    }

    private String getNodeAttributeVal(CyNode curNode, String attributeName) {
        String nodeValue = "";
        if (attributeName.equals("nodeID")) {
            nodeValue = curNode.toString();
        } else {
            CyAttributes cyNodeAttrs = Cytoscape.getNodeAttributes();
            if (cyNodeAttrs.getType(attributeName) == 4) {
                nodeValue = cyNodeAttrs.getStringAttribute(curNode.getIdentifier(), attributeName);
            } else if (cyNodeAttrs.getType(attributeName) == -2) {
                List attribute = cyNodeAttrs.getListAttribute(curNode.getIdentifier(), attributeName);
                if (attribute == null) {
                    return null;
                }
                for (Object curObj : attribute) {
                    if (!(curObj instanceof String)) continue;
                    String curObjString = (String)curObj;
                    nodeValue = nodeValue + curObjString + " ";
                }
            } else {
                CytoscapeDesktop desktop = Cytoscape.getDesktop();
                JOptionPane.showMessageDialog((Component)desktop, "Current implementation does not handle non-String attributes.");
                return null;
            }
        }
        return nodeValue;
    }

    private List<String> processNodeString(String nodeValue) {
        nodeValue = nodeValue.toLowerCase();
        String controlString = Character.toString('\u001f');
        WordDelimiters delims = this.getNetworkParams().getDelimiter();
        nodeValue = nodeValue.replaceAll(delims.getRegex(), controlString);
        for (String userDelim : delims.getUserDelims()) {
            nodeValue = nodeValue.replaceAll(userDelim, controlString);
        }
        ArrayList<String> wordSet = new ArrayList<String>();
        StringTokenizer token = new StringTokenizer(nodeValue, controlString);
        while (token.hasMoreTokens()) {
            String a = token.nextToken();
            if (wordSet.contains(a)) continue;
            wordSet.add(a);
        }
        return wordSet;
    }

    @Override
    public int compareTo(CloudParameters compare) {
        Integer thisCount = this.getCloudNum();
        Integer compareCount = compare.getCloudNum();
        return thisCount.compareTo(compareCount);
    }

    public String getNextNetworkName() {
        String name = this.networkParams.getNetworkName() + "-" + this.cloudName + "-" + NETWORKNAME + SEPARATER + this.networkCount;
        Integer n = this.networkCount;
        Integer n2 = this.networkCount = Integer.valueOf(this.networkCount + 1);
        return name;
    }

    public String getCloudName() {
        return this.cloudName;
    }

    public void setCloudName(String name) {
        this.cloudName = name;
    }

    public ArrayList<String> getAttributeNames() {
        return this.attributeNames;
    }

    public void setAttributeNames(ArrayList<String> names) {
        Boolean changed = false;
        if (names.size() != this.attributeNames.size()) {
            changed = true;
        } else {
            for (int i = 0; i < names.size(); ++i) {
                String curAttribute = names.get(i);
                if (this.attributeNames.contains(curAttribute)) continue;
                changed = true;
            }
        }
        if (changed.booleanValue()) {
            this.countInitialized = false;
            this.selInitialized = false;
            this.ratiosInitialized = false;
        }
        this.attributeNames = names;
    }

    public void addAttributeName(String name) {
        if (!this.attributeNames.contains(name)) {
            this.attributeNames.add(name);
            this.countInitialized = false;
            this.selInitialized = false;
            this.ratiosInitialized = false;
        }
    }

    public SemanticSummaryParameters getNetworkParams() {
        return this.networkParams;
    }

    public void setNetworkParams(SemanticSummaryParameters params) {
        this.networkParams = params;
    }

    public List<String> getSelectedNodes() {
        return this.selectedNodes;
    }

    public void setSelectedNodes(List<String> nodes) {
        this.selectedNodes = nodes;
        this.selInitialized = false;
        this.ratiosInitialized = false;
    }

    public Integer getSelectedNumNodes() {
        return this.selectedNumNodes;
    }

    public void setSelectedNumNodes(Integer num) {
        this.selectedNumNodes = num;
    }

    public HashMap<String, List<String>> getStringNodeMapping() {
        return this.stringNodeMapping;
    }

    public void setStringNodeMapping(HashMap<String, List<String>> mapping) {
        this.stringNodeMapping = mapping;
    }

    public HashMap<String, Integer> getNetworkCounts() {
        return this.networkCounts;
    }

    public void setNetworkCounts(HashMap<String, Integer> counts) {
        this.networkCounts = counts;
    }

    public HashMap<String, Integer> getSelectedCounts() {
        return this.selectedCounts;
    }

    public void setSelectedCounts(HashMap<String, Integer> counts) {
        this.selectedCounts = counts;
    }

    public HashMap<String, Integer> getSelectedPairCounts() {
        return this.selectedPairCounts;
    }

    public void setSelectedPairCounts(HashMap<String, Integer> counts) {
        this.selectedPairCounts = counts;
    }

    public HashMap<String, Integer> getNetworkPairCounts() {
        return this.networkPairCounts;
    }

    public void setNetworkPairCounts(HashMap<String, Integer> counts) {
        this.networkPairCounts = counts;
    }

    public HashMap<String, Double> getRatios() {
        return this.ratios;
    }

    public void setRatios(HashMap<String, Double> r) {
        this.ratios = r;
    }

    public HashMap<String, Double> getPairRatios() {
        return this.pairRatios;
    }

    public void setPairRatios(HashMap<String, Double> r) {
        this.pairRatios = r;
    }

    public ArrayList<CloudWordInfo> getCloudWordInfoList() {
        return this.cloudWords;
    }

    public void setCloudWordInfoList(ArrayList<CloudWordInfo> words) {
        this.cloudWords = words;
    }

    public Integer getNetworkNumNodes() {
        return this.networkNumNodes;
    }

    public void setNetworkNumNodes(Integer num) {
        this.networkNumNodes = num;
    }

    public Double getMinRatio() {
        return this.minRatio;
    }

    public void setMinRatio(Double ratio) {
        this.minRatio = ratio;
    }

    public Double getMaxRatio() {
        return this.maxRatio;
    }

    public void setMaxRatio(Double ratio) {
        this.maxRatio = ratio;
    }

    public Double getMeanRatio() {
        return this.meanRatio;
    }

    public void setMeanRatio(Double ratio) {
        this.meanRatio = ratio;
    }

    public Double getMinWeight() {
        return this.minWeight;
    }

    public void setMinWeight(Double val) {
        this.minWeight = val;
    }

    public Double getMaxWeight() {
        return this.maxWeight;
    }

    public void setMaxWeight(Double val) {
        this.maxWeight = val;
    }

    public Double getMeanWeight() {
        return this.meanWeight;
    }

    public void setMeanWeight(Double val) {
        this.meanWeight = val;
    }

    public boolean getCountInitialized() {
        return this.countInitialized;
    }

    public void setCountInitialized(boolean val) {
        this.countInitialized = val;
    }

    public boolean getSelInitialized() {
        return this.selInitialized;
    }

    public void setSelInitialized(boolean val) {
        this.selInitialized = val;
    }

    public boolean getRatiosInitialized() {
        return this.ratiosInitialized;
    }

    public void setRatiosInitialized(boolean val) {
        this.ratiosInitialized = val;
    }

    public Double getNetWeightFactor() {
        return this.netWeightFactor;
    }

    public void setNetWeightFactor(Double val) {
        if (!this.netWeightFactor.equals(val)) {
            this.ratiosInitialized = false;
        }
        this.netWeightFactor = val;
    }

    public Double getClusterCutoff() {
        return this.clusterCutoff;
    }

    public void setClusterCutoff(Double val) {
        this.clusterCutoff = val;
    }

    public Integer getMaxWords() {
        return this.maxWords;
    }

    public void setMaxWords(Integer val) {
        this.maxWords = val;
    }

    public Double getDefaultNetWeight() {
        return this.defaultNetWeight;
    }

    public String getDefaultAttName() {
        return this.defaultAttName;
    }

    public Integer getDefaultMaxWords() {
        return this.defaultMaxWords;
    }

    public Double getDefaultClusterCutoff() {
        return this.defaultClusterCutoff;
    }

    public String getDefaultDisplayStyle() {
        return this.defaultStyle;
    }

    public Integer getCloudNum() {
        return this.cloudNum;
    }

    public void setCloudNum(Integer num) {
        this.cloudNum = num;
    }

    public String getDisplayStyle() {
        return this.displayStyle;
    }

    public void setDisplayStyle(String style) {
        this.displayStyle = style;
    }

    public boolean getUseNetNormal() {
        return this.useNetNormal;
    }

    public void setUseNetNormal(boolean val) {
        this.useNetNormal = val;
    }
}

