/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.csplugins.wordcloud;

import cytoscape.csplugins.wordcloud.CloudParameters;
import cytoscape.csplugins.wordcloud.CloudWordInfo;
import cytoscape.csplugins.wordcloud.ClusterPriorityQueue;
import cytoscape.csplugins.wordcloud.SingleWordCluster;
import cytoscape.csplugins.wordcloud.WordClusters;
import cytoscape.csplugins.wordcloud.WordPair;
import java.awt.Color;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SemanticSummaryClusterBuilder {
    private CloudParameters params = new CloudParameters();
    private ClusterPriorityQueue queue = new ClusterPriorityQueue();
    private WordClusters clusters = new WordClusters();
    private ArrayList<CloudWordInfo> cloudWords = new ArrayList();
    boolean initialized = false;
    private static final Integer NUMCOLORS = 7;

    public void initialize(CloudParameters cloudParams) {
        this.params = cloudParams;
        this.queue.initialize(cloudParams);
        this.clusters.initialize(cloudParams);
        this.initialized = true;
    }

    public void clusterData(Double cutoffVal) {
        if (!this.initialized) {
            return;
        }
        boolean isDone = false;
        while (!isDone && !this.queue.isEmpty()) {
            WordPair curPair = this.queue.peak();
            if (curPair.getProbability() < cutoffVal) {
                isDone = true;
                continue;
            }
            curPair = this.queue.remove();
            this.clusters.combineClusters(curPair);
        }
        this.clusters.orderClusters();
    }

    private Color getClusterColor(Integer clusterNum) {
        Color textColor;
        Integer rem = clusterNum % NUMCOLORS;
        switch (rem) {
            case 0: {
                textColor = Color.BLACK;
                break;
            }
            case 1: {
                textColor = new Color(204, 0, 0);
                break;
            }
            case 2: {
                textColor = new Color(0, 110, 0);
                break;
            }
            case 3: {
                textColor = new Color(255, 179, 0);
                break;
            }
            case 4: {
                textColor = new Color(0, 0, 160);
                break;
            }
            case 5: {
                textColor = new Color(130, 32, 130);
                break;
            }
            case 6: {
                textColor = Color.GRAY;
                break;
            }
            default: {
                textColor = Color.BLACK;
            }
        }
        return textColor;
    }

    public void buildCloudWords() {
        if (!this.initialized) {
            return;
        }
        this.cloudWords = new ArrayList();
        Integer wordCount = 0;
        for (int i = 0; i < this.clusters.getClusters().size(); ++i) {
            SingleWordCluster curCluster = this.clusters.getClusters().get(i);
            ArrayList<String> curList = curCluster.getWordList();
            Color clusterColor = this.getClusterColor(i);
            for (int j = 0; j < curList.size(); ++j) {
                String curWord = curList.get(j);
                Integer fontSize = this.params.calculateFontSize(curWord);
                CloudWordInfo curInfo = new CloudWordInfo(curWord, fontSize);
                curInfo.setCloudParameters(this.params);
                curInfo.setTextColor(clusterColor);
                curInfo.setCluster(i);
                curInfo.setWordNumber(wordCount);
                Integer n = wordCount;
                Integer n2 = wordCount = Integer.valueOf(wordCount + 1);
                this.cloudWords.add(curInfo);
            }
        }
    }

    public void setCloudParameters(CloudParameters cloudParams) {
        this.params = cloudParams;
    }

    public CloudParameters getCloudParameters() {
        return this.params;
    }

    public void setCloudWords(ArrayList<CloudWordInfo> cloudWordInput) {
        this.cloudWords = cloudWordInput;
    }

    public ArrayList<CloudWordInfo> getCloudWords() {
        return this.cloudWords;
    }

    public void setClusters(WordClusters clusterSet) {
        this.clusters = clusterSet;
    }

    public WordClusters getClusters() {
        return this.clusters;
    }

    public void setQueue(ClusterPriorityQueue aQueue) {
        this.queue = aQueue;
    }

    public ClusterPriorityQueue getQueue() {
        return this.queue;
    }

    public void setInitialized(boolean val) {
        this.initialized = val;
    }

    public boolean getInitialized() {
        return this.initialized;
    }

    public Integer getNumColors() {
        return NUMCOLORS;
    }
}

