/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.csplugins.wordcloud;

import cytoscape.csplugins.wordcloud.SliderBarActionListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import prefuse.data.query.NumberRangeModel;

public class SliderBarPanel
extends JPanel {
    private final int DIM_HEIGHT = 72;
    private final int DIM_WIDTH = 150;
    private int min;
    private int max;
    private NumberRangeModel rangeModel;
    private double precision = 1000.0;
    private int dec_precision = (int)Math.log10(this.precision);
    private JLabel label;
    private String sliderLabel;
    private JSlider slider;

    public SliderBarPanel(double min, double max, String sliderLabel, String attrib, int desired_width) {
        this.setPreferredSize(new Dimension(150, 72));
        this.setLayout(new BorderLayout(0, 0));
        this.setOpaque(false);
        if (min <= 1.0 && max <= 1.0) {
            this.min = (int)(min * this.precision);
            this.max = (int)(max * this.precision);
        } else {
            this.min = (int)min;
            this.max = (int)max;
        }
        this.sliderLabel = sliderLabel;
        this.label = new JLabel(sliderLabel);
        Dimension currentsize = this.label.getPreferredSize();
        currentsize.height = 6;
        this.label.setPreferredSize(currentsize);
        this.initPanel(attrib, desired_width);
    }

    public void initPanel(String attrib, int desired_width) {
        this.slider = new JSlider(0, this.min, this.max, this.min);
        this.slider.addChangeListener(new SliderBarActionListener(this, attrib));
        this.slider.setMajorTickSpacing((this.max - this.min) / 5);
        this.slider.setPaintTicks(true);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        labelTable.put(new Integer(this.min), new JLabel("" + (double)this.min / this.precision));
        labelTable.put(new Integer(this.max), new JLabel("" + (double)this.max / this.precision));
        this.slider.setLabelTable(labelTable);
        this.slider.setPaintLabels(true);
        Dimension currentsize = this.slider.getPreferredSize();
        currentsize.width = desired_width;
        currentsize.height = 66;
        this.slider.setPreferredSize(currentsize);
        this.setLayout(new GridLayout(2, 1));
        this.add((Component)this.label, "North");
        this.add((Component)this.slider, "South");
        this.revalidate();
    }

    public void setNetNormValue(Double val) {
        long value = Math.round(val * this.getPrecision());
        int intValue = (int)value;
        this.getSlider().setValue(intValue);
    }

    public void setLabel(int current_value) {
        this.label.setText(String.format("<html>" + this.sliderLabel + " &#8594; " + "<font size=\"-2\"> %." + this.dec_precision + "f </font></html>", (double)current_value / this.precision));
        this.revalidate();
    }

    public void setEnabled(boolean enabled) {
        this.slider.setEnabled(enabled);
        this.label.setEnabled(enabled);
    }

    public double getPrecision() {
        return this.precision;
    }

    public double getMin() {
        return (double)this.min / this.precision;
    }

    public void setMin(double min) {
        this.min = (int)(min * this.precision);
    }

    public double getMax() {
        return (double)this.max / this.precision;
    }

    public void setMax(double max) {
        this.max = (int)(max * this.precision);
    }

    public NumberRangeModel getRangeModel() {
        return this.rangeModel;
    }

    public void setRangeModel(NumberRangeModel rangeModel) {
        this.rangeModel = rangeModel;
    }

    public JSlider getSlider() {
        return this.slider;
    }
}

