f.FisherTestGS_Wrap <- function (Sample2GS.tab, Sample2class.df)

# Input Description
# - Sample2GS.tab (from: f.Comp_Sample2GS)
#   - colnames: GS ID
#   - rownames: Sample ID
# - Sample2class.df (from: f.Comp_Sample2class)
#   - Class
#   - SampleID

	{

	# The unitary Fisher's test is defined inside the wrap function
	# to take advantage of the following variables as global:
	# - case_tot.n
	# - ctrl_tot.n

	f.FisherTestGS_Unit <- function (counts.nv)
	# first count: case, second count: ctrl
		{

		table.mx <- 
			matrix (
				data  = c (counts.nv, c (case_tot.n, ctrl_tot.n) - counts.nv), 
				ncol  = 2, 
				nrow  = 2, 
				byrow = T)

		test.result <- fisher.test (table.mx, alternative = "greater")
	
		return (test.result$p.value)

		}
	
	GS_sel.ID <- colnames (Sample2GS.tab)[apply (Sample2GS.tab, 2, sum) > 0]
		
	case.sample <- Sample2class.df$SampleID[Sample2class.df$Class == "case"]
	ctrl.sample <- Sample2class.df$SampleID[Sample2class.df$Class == "control"]

	# some samples are absent from the counts, as they have no CNV
	# therefore the previous arrays have to be subset to avoid
	# 'subscript out of bounds'
	
	mapped.samples <- rownames (Sample2GS.tab)
	
	Sample2GS_case.tab <- Sample2GS.tab[intersect (case.sample, mapped.samples), ]
	Sample2GS_ctrl.tab <- Sample2GS.tab[intersect (ctrl.sample, mapped.samples), ]

	case_counts.nv <- apply (Sample2GS_case.tab, 2, sum)
	ctrl_counts.nv <- apply (Sample2GS_ctrl.tab, 2, sum)
	
	case_tot.n <- length (case.sample)
	ctrl_tot.n <- length (ctrl.sample)

	counts.mx <- cbind (case_counts.nv, ctrl_counts.nv)
	colnames (counts.mx) <- c ("case", "ctrl")
	rownames (counts.mx) <- colnames (Sample2GS.tab)

	# !WARNING!
	# gene-sets with no counts are neglected

	pval.nv <- apply (counts.mx[GS_sel.ID, ], 1, f.FisherTestGS_Unit)
	# names (pval.nv) <- GS_sel.ID
	
	output.df <- 
		data.frame (
			GS_ID      = GS_sel.ID,
			CaseCounts = counts.mx[GS_sel.ID, "case"],
			CtrlCounts = counts.mx[GS_sel.ID, "ctrl"],
			pvalue     = pval.nv,
			stringsAsFactors = F
		)

	output.df <- output.df[order (output.df$pvalue, decreasing = F), ]

	# pval.nv <- sort (pval.nv, decreasing = F)

	return (output.df)
	
	}

f.FisherTestGS_FDR_Wrap <- function (Sample2GS.tab, Sample2class.df, iter.n = 1000)
# This function acts as a shell of the previous,
# generating both real and randomized data

	{

	cat ("\nComputing Real Enrichment")

	real_enr.df <- 
		f.FisherTestGS_Wrap (
			Sample2GS.tab   = Sample2GS.tab, 
			Sample2class.df = Sample2class.df
			)

	Sample2class_rand.ls <- rep (list (Sample2class.df), iter.n)
	cat ("\nGenerating Permutations\n")
			
	f.FDR_Unit <- function (sample2class_rand.df)
		{
		sample2class_rand.df$Class <- sample (sample2class_rand.df$Class)
		
		pvalue_rand.nv <- 
			f.FisherTestGS_Wrap (
				Sample2GS.tab   = Sample2GS.tab, 
				Sample2class.df = sample2class_rand.df
				)$pvalue
		
		cat (".")
		
		return (pvalue_rand.nv)
		}
	
	pvalues_rand.ls <- lapply (Sample2class_rand.ls, f.FDR_Unit)
	cat ("\n")

	cat ("\nComputing FDR")	
	f.Count <- function (pval_thr.n)
		{
		f.Count_Unit <- function (pval.nv)
			{return (sum (pval.nv <= pval_thr.n))}
		avg_rand.n <- mean (unlist (lapply (pvalues_rand.ls, f.Count_Unit)))
		obs.n <- sum (real_enr.df$pvalue <= pval_thr.n)
		return (avg_rand.n / obs.n)
		}
	
	FDR.nv <- unlist (lapply (as.list (real_enr.df$pvalue), f.Count))

	real_enr.df <- cbind (real_enr.df, FDR.nv)
	colnames (real_enr.df)[ncol (real_enr.df)] <- "FDR"
	
	return (real_enr.df)
	}
	