f.Comp_Sample2GS <- function (GS2genes.ls, Sample2genes.ls, Sample2class.df)

# Input description:
# - GS2genes.ls
#   - list with genes (slot values) in the gene-sets (slot names)
# - Sample2genes.ls (from f.Comp_Sample2genes)
# - Sample2class.df (Sample2class.df)
#   - Class 
#   - SampleID 

	{
	Sample2genes.df <- stack (Sample2genes.ls)
	GS2genes.df <- stack (GS2genes.ls)	
	
	# "value" column: genes
	Sample2genes2GS.df <- merge (Sample2genes.df, GS2genes.df, by.x = "values", by.y = "values")
	
	Sample2GS.tab <- table (Sample2genes2GS.df[, c ("ind.x", "ind.y")])
	
	# Rectify (max sample contribution = 1)
	Sample2GS_rect.tab <- Sample2GS.tab
	Sample2GS_rect.tab[	Sample2GS_rect.tab > 1] <- 1

	tot.n <- sum (Sample2GS.tab > 0)
	rec.n <- sum (Sample2GS.tab > 1)
	per.ch <- formatC (rec.n / tot.n * 100, format = "f", digits = 1)
	cat ("\nTotal positive sample-GS counts: "); cat (tot.n)
	cat ("\nof which, rectified to 1: "); cat (rec.n); cat (" ("); cat (per.ch); cat ("%)")
		
	return (Sample2GS_rect.tab)
	}